/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.jniscale.ArgStruct;
import com.zebra.jpos.service.scale.ScaleEventQueueEntry;
import com.zebra.jpos.service.scale.ScaleServiceImpl;
import com.zebra.jpos.service.scale.ScaleWeight;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public class LiveWeightThread
implements Runnable {
    Lock threadAccessLock = null;
    Condition readWeighRequestCondition = null;
    private volatile boolean threadTerminationRequested = false;
    private final int DELAY_BETWEEN_TWO_READS = 500;
    private final int CONSTANT_ZERO = 0;
    int delayBetweenTwoReads = 500;
    int scaleIndex = 0;
    ScaleServiceImpl scaleServiceImpl = null;
    private int stableScaleWeight = 0;
    private EventCallbacks eventCallbacks = null;
    private ArgStruct argStruct = null;
    private int previous_scale_weigth_status = -1;
    private int previous_weight = 0;

    public LiveWeightThread() {
        this.delayBetweenTwoReads = 500;
        this.scaleIndex = 0;
    }

    public LiveWeightThread(int n, int n2, ScaleServiceImpl scaleServiceImpl, EventCallbacks eventCallbacks) {
        this.delayBetweenTwoReads = n;
        this.scaleIndex = n2;
        this.scaleServiceImpl = scaleServiceImpl;
        this.eventCallbacks = eventCallbacks;
        this.threadAccessLock = new ReentrantLock();
        this.readWeighRequestCondition = this.threadAccessLock.newCondition();
    }

    public void terminateTheThread() {
        try {
            this.threadAccessLock.lock();
            this.threadTerminationRequested = true;
        }
        finally {
            this.threadAccessLock.unlock();
        }
    }

    public boolean getThreadTerminationRequested() {
        return this.threadTerminationRequested;
    }

    public boolean scheduleReadWeight(int n) {
        if (this.threadAccessLock.tryLock()) {
            try {
                this.delayBetweenTwoReads = n;
                this.readWeighRequestCondition.signal();
            }
            finally {
                this.threadAccessLock.unlock();
            }
            return true;
        }
        return false;
    }

    public int getScaleWeight() {
        return this.stableScaleWeight;
    }

    @Override
    public void run() {
        boolean bl = true;
        while (bl) {
            ScaleEventQueueEntry scaleEventQueueEntry;
            StatusUpdateEvent statusUpdateEvent;
            if (!this.threadAccessLock.tryLock()) continue;
            this.readWeighRequestCondition.signal();
            if (this.threadTerminationRequested) {
                bl = false;
                continue;
            }
            ScaleWeight scaleWeight = this.scaleServiceImpl.ReadWeight(this.scaleIndex);
            if (scaleWeight != null) {
                if (this.previous_scale_weigth_status != scaleWeight.getStatus() || scaleWeight.getStatus() == 11 && this.previous_weight != scaleWeight.getWeight()) {
                    if (scaleWeight.getStatus() == 11) {
                        this.previous_weight = scaleWeight.getWeight();
                        this.scaleServiceImpl.setScaleLiveWeight(scaleWeight.getWeight());
                    } else {
                        this.scaleServiceImpl.setScaleLiveWeight(0);
                    }
                    this.previous_scale_weigth_status = scaleWeight.getStatus();
                    statusUpdateEvent = new StatusUpdateEvent((Object)this.eventCallbacks, scaleWeight.getStatus());
                    scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)statusUpdateEvent, 3, 0);
                    this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                }
            } else if (this.previous_scale_weigth_status != 15) {
                this.scaleServiceImpl.setScaleLiveWeight(0);
                this.previous_scale_weigth_status = 15;
                statusUpdateEvent = new StatusUpdateEvent((Object)this.eventCallbacks, 15);
                scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)statusUpdateEvent, 3, 0);
                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
            }
            this.threadAccessLock.unlock();
            try {
                Thread.sleep(this.delayBetweenTwoReads);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(LiveWeightThread.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
    }
}

