/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.jniscale.ArgStruct;
import com.zebra.jpos.service.scale.ReceiveAsyncErrorResponse;
import com.zebra.jpos.service.scale.ScaleEventQueueEntry;
import com.zebra.jpos.service.scale.ScaleService12Impl;
import com.zebra.jpos.service.scale.ScaleServiceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

class ReadWeightAsyncModeThread
implements Runnable,
ReceiveAsyncErrorResponse {
    Lock accessLock = null;
    Condition scheduleRead = null;
    Map<Long, Integer> postedErrorEventSequenceNumbers = null;
    int timeout;
    int scaleIndex;
    volatile boolean bIsTerminateRequested = false;
    private ArgStruct argStruct = null;
    private ScaleServiceImpl scaleServiceImpl = null;
    public static EventCallbacks eventCallbacks = null;

    @Override
    public void receiveAsyncErrorResponse(long l, int n) {
        int n2 = 0;
        if (this.postedErrorEventSequenceNumbers.containsKey(l)) {
            switch (n) {
                case 11: {
                    n2 = this.postedErrorEventSequenceNumbers.get(l);
                    this.scheduleReadWeight(n2);
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
            }
            this.postedErrorEventSequenceNumbers.remove(l);
        }
    }

    public boolean scheduleReadWeight(int n) {
        if (this.accessLock.tryLock()) {
            try {
                this.timeout = n;
                this.scheduleRead.signal();
            }
            finally {
                this.accessLock.unlock();
            }
            return true;
        }
        return false;
    }

    public void requestTerminateThread() {
        this.bIsTerminateRequested = true;
        this.accessLock.lock();
        try {
            this.scheduleRead.signal();
        }
        finally {
            this.accessLock.unlock();
        }
    }

    public ReadWeightAsyncModeThread(ArgStruct argStruct, int n, ScaleServiceImpl scaleServiceImpl, EventCallbacks eventCallbacks) {
        this.argStruct = argStruct;
        this.scaleIndex = n;
        this.accessLock = new ReentrantLock();
        this.scheduleRead = this.accessLock.newCondition();
        this.scaleServiceImpl = scaleServiceImpl;
        ReadWeightAsyncModeThread.eventCallbacks = eventCallbacks;
        this.postedErrorEventSequenceNumbers = new HashMap<Long, Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = true;
        int[] nArray = new int[10];
        while (bl) {
            if (this.accessLock.tryLock()) {
                try {
                    this.scheduleRead.await();
                    if (this.bIsTerminateRequested) {
                        bl = false;
                        continue;
                    }
                    int n = -1;
                    ScaleServiceImpl.isAsyncTimeoutExceeded = false;
                    ScaleServiceImpl.isReadWeightInProgress = true;
                    long l = System.currentTimeMillis();
                    do {
                        ScaleService12Impl.invokeCorescannerReadWeight(this.scaleIndex, this.argStruct);
                        n = ScaleService12Impl.parseCorescannerReadWeightOutXmlAndGetWeight(this.argStruct, nArray, this.scaleServiceImpl.zeroValid);
                        long l2 = System.currentTimeMillis();
                        if (this.timeout != -1 && l2 - l > (long)this.timeout) {
                            ScaleServiceImpl.isAsyncTimeoutExceeded = true;
                        }
                        if (this.bIsTerminateRequested) break;
                    } while (!ScaleServiceImpl.isAsyncTimeoutExceeded && n != 6 && (n != 5 || !this.scaleServiceImpl.zeroValid));
                    if (!this.scaleServiceImpl.asyncMode) {
                        ScaleServiceImpl.isAsyncTimeoutExceeded = true;
                    }
                    DataEvent dataEvent = null;
                    ErrorEvent errorEvent = null;
                    long l3 = 0L;
                    boolean bl2 = false;
                    for (int i = 0; i < ScaleServiceImpl._queue.size(); ++i) {
                        if (ScaleServiceImpl._queue.get((int)i).iEventType != 0) continue;
                        bl2 = true;
                        break;
                    }
                    int n2 = 2;
                    int n3 = 12;
                    switch (n) {
                        case 4: {
                            int n4;
                            int n5;
                            if (bl2) {
                                n2 = 3;
                                n3 = 13;
                                n5 = 112;
                                n4 = 0;
                                errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                                l3 = errorEvent.getSequenceNumber();
                                this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 4;
                                n2 = 2;
                                n3 = 12;
                            }
                            n5 = 112;
                            n4 = 0;
                            errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                            l3 = errorEvent.getSequenceNumber();
                            this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 4;
                            break;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            if (bl2) {
                                n2 = 3;
                                n3 = 13;
                                n5 = 105;
                                n4 = 0;
                                errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                                l3 = errorEvent.getSequenceNumber();
                                this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 4;
                                n2 = 2;
                                n3 = 12;
                            }
                            n5 = 105;
                            n4 = 0;
                            errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                            l3 = errorEvent.getSequenceNumber();
                            this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 4;
                            break;
                        }
                        case 1: {
                            int n4;
                            int n5;
                            if (bl2) {
                                n2 = 3;
                                n3 = 13;
                                n5 = 112;
                                n4 = 0;
                                errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                                l3 = errorEvent.getSequenceNumber();
                                this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 4;
                                n2 = 2;
                                n3 = 12;
                            }
                            n5 = 112;
                            n4 = 0;
                            errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                            l3 = errorEvent.getSequenceNumber();
                            this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 4;
                            break;
                        }
                        case 6: {
                            dataEvent = new DataEvent((Object)eventCallbacks, nArray[0]);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)dataEvent, 0, nArray[0]);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 2;
                            break;
                        }
                        case 2: {
                            int n4;
                            int n5;
                            if (bl2) {
                                n2 = 3;
                                n3 = 13;
                                n5 = 114;
                                n4 = 201;
                                errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                                l3 = errorEvent.getSequenceNumber();
                                this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 4;
                                n2 = 2;
                                n3 = 12;
                            }
                            n5 = 114;
                            n4 = 201;
                            errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                            l3 = errorEvent.getSequenceNumber();
                            this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 4;
                            break;
                        }
                        case 3: {
                            int n4;
                            int n5;
                            if (bl2) {
                                n2 = 3;
                                n3 = 13;
                                n5 = 114;
                                n4 = 202;
                                errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                                l3 = errorEvent.getSequenceNumber();
                                this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 4;
                                n2 = 2;
                                n3 = 12;
                            }
                            n5 = 114;
                            n4 = 202;
                            errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                            l3 = errorEvent.getSequenceNumber();
                            this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 4;
                            break;
                        }
                        case 5: {
                            int n4;
                            int n5;
                            if (this.scaleServiceImpl.zeroValid) {
                                dataEvent = new DataEvent((Object)eventCallbacks, nArray[0]);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)dataEvent, 0, nArray[0]);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 2;
                                break;
                            }
                            if (bl2) {
                                n2 = 3;
                                n3 = 13;
                                n5 = 112;
                                n4 = 0;
                                errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                                l3 = errorEvent.getSequenceNumber();
                                this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                                ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                                this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                                ScaleServiceImpl.state = 4;
                                n2 = 2;
                                n3 = 12;
                            }
                            n5 = 112;
                            n4 = 0;
                            errorEvent = new ErrorEvent((Object)eventCallbacks, n5, n4, n2, n3);
                            l3 = errorEvent.getSequenceNumber();
                            this.postedErrorEventSequenceNumbers.put(l3, this.timeout);
                            ScaleEventQueueEntry scaleEventQueueEntry = new ScaleEventQueueEntry((JposEvent)errorEvent, 2, 0);
                            this.scaleServiceImpl.scaleEventQueue.enqueue(scaleEventQueueEntry);
                            ScaleServiceImpl.state = 4;
                            break;
                        }
                        default: {
                            ScaleServiceImpl.state = 4;
                        }
                    }
                    ScaleServiceImpl.isReadWeightInProgress = false;
                    continue;
                }
                catch (Exception exception) {
                    ScaleServiceImpl.isReadWeightInProgress = false;
                    continue;
                }
                finally {
                    this.accessLock.unlock();
                    continue;
                }
            }
            System.err.println("Async wait thread failed acquire the lock");
        }
    }
}

