/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.jniscale.ArgStruct;
import com.zebra.jpos.jniscale.JCoreScale;
import com.zebra.jpos.jniscale.JniXmlElement;
import com.zebra.jpos.service.scale.ScaleServiceImpl;
import com.zebra.jpos.service.scale.ScaleWeight;
import com.zebra.jpos.service.scale.XmlProcessor;
import com.zebra.jpos.serviceonscale.SvcAbstractService;
import com.zebra.log.scale.JCoreLogger;
import java.util.Arrays;
import jpos.JposException;
import jpos.services.ScaleService12;

public class ScaleService12Impl
extends ScaleServiceImpl
implements ScaleService12 {
    static final int READ_WEIGHT_SCALE_NOT_ENABLE = 0;
    static final int READ_WEIGHT_SCALE_NOT_READY = 1;
    static final int READ_WEIGHT_STABLE_WEIGHT_OVER_LIMIT = 2;
    static final int READ_WEIGHT_STABLE_WEIGHT_UNDER_ZERO = 3;
    static final int READ_WEIGHT_NON_STABLE_WEIGHT = 4;
    static final int READ_WEIGHT_STABLE_ZERO_WEIGHT = 5;
    static final int READ_WEIGHT_STABLE_NON_ZERO_WEIGHT = 6;
    static final int RSM_SCALE_READ_WEIGHT_INVALID = -1;
    static final int READ_WEIGHT_BUF_SIZE = 10;
    int[] WeightValue = new int[1];
    static final int MAXIMUM_ZERO_WEIGHT_THRESHLD_LBS = 600;
    static final int MAXIMUM_ZERO_WEIGHT_THRESHLD_KG = 300;
    static final int NON_EXTENDED_ERROR_CODE_VALUE = 0;

    public boolean getCapDisplay() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)false, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"getCapDisplay");
        if (SvcAbstractService.state == 107) {
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Service not open");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{false});
        return false;
    }

    public int getMaximumWeight() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)false, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ScannerService12Impl:: getMaximumWeight Started");
        if (!this.isOpen) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)101, (String)"ScannerService12Impl:: getMaximumWeight Device not opened");
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)107, (String)"ScannerService12Impl:: getMaximumWeight Device not connected");
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"getMaxWeight"});
        return this.getMaxWeight();
    }

    public int getMaxWeight() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        this.argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID);
        stringBuilder.append(scaleIndex);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST);
        stringBuilder.append(25006);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
        this.argStruct.inXml = stringBuilder.toString();
        this.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("ScannerService12Impl:: getMaxWeight ExecCommand completed outXml = " + this.argStruct.outXml));
        try {
            if (!this.argStruct.outXml.isEmpty()) {
                JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"getMaxWeightFromXml"});
                return ScaleService12Impl.getMaxWeightFromXml(this.argStruct.outXml);
            }
        }
        catch (Exception exception) {
            JposException jposException = new JposException(106, "XML parsing error");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{0});
        return 0;
    }

    public static int getMaxWeightFromXml(String string) throws JposException {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)true, (Object[])new Object[]{string});
        try {
            XmlProcessor xmlProcessor = new XmlProcessor();
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{Integer.parseInt(xmlProcessor.getAttributeValue(string))});
            return Integer.parseInt(xmlProcessor.getAttributeValue(string));
        }
        catch (Exception exception) {
            JposException jposException = new JposException(106, "XML parsing error");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
    }

    public int getWeightUnit() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)false, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"getWeightUnit");
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Device is closed.");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (this.weightUnit == 0) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{2});
            return 2;
        }
        if (this.weightUnit == 1) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{4});
            return 4;
        }
        JposException jposException = new JposException(111, "Weight Units Not Set.");
        JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
        throw jposException;
    }

    public synchronized void readWeight(int[] nArray, int n) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{Arrays.toString(nArray), n});
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("readWeight started. Timeout = " + n));
        if (!this.isOpen) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Device not Opened");
            JposException jposException = new JposException(101, "Device not Opened");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.claimed) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Device not Claimed");
            JposException jposException = new JposException(103, "Device not Claimed");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Device not connected");
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.deviceEnabled) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Device not Enabled");
            JposException jposException = new JposException(105, "Device not Enabled");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (-1 > n) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)106, (String)"readWeight Invalid timeout");
            JposException jposException = new JposException(106, "Invalid timeout");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("readWeight bSyncReadWeightOnZeroTimeout =  " + this.bSyncReadWeightOnZeroTimeout));
        if (this.asyncMode && (n != 0 || !this.bSyncReadWeightOnZeroTimeout)) {
            boolean bl;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Async mode true");
            if (nArray != null && nArray.length >= 1) {
                nArray[0] = 0;
            }
            if (!(bl = this.readWeightAsyncModeThread.scheduleReadWeight(n))) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight An asynchronous readWeight is in progress");
                JposException jposException = new JposException(113, "An asynchronous readWeight is in progress");
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
                throw jposException;
            }
        } else {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Async mode false");
            ScaleWeight.readWeight(scaleIndex, nArray, n, this.zeroValid, 2);
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    public static void invokeCorescannerReadWeight(int n, ArgStruct argStruct) {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, argStruct});
        argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID);
        stringBuilder.append(n);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST);
        stringBuilder.append(ArgStruct.RSM_SCALE_READ_WEIGHT);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
        argStruct.inXml = stringBuilder.toString();
        argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(argStruct);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    public static int parseCorescannerReadWeightOutXmlAndGetWeight(ArgStruct argStruct, int[] nArray, boolean bl) throws Exception {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{argStruct, Arrays.toString(nArray), bl});
        int n = -1;
        if (argStruct == null || argStruct.outXml.isEmpty()) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{n});
            return n;
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug] parseCorescannerReadWeightOutXmlAndGetWeight outXML = " + argStruct.outXml));
        n = ScaleService12Impl.parseGetWeightOutXml(argStruct.outXml, nArray, bl);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug] parseCorescannerReadWeightOutXmlAndGetWeight returning " + n + " attrData = " + nArray[0]));
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{n});
        return n;
    }

    private static int parseGetWeightOutXml(String string, int[] nArray, boolean bl) {
        int n = -1;
        try {
            int n2;
            nArray[0] = 0;
            String string2 = string.substring(string.indexOf("value") + 6);
            string2 = string2.substring(0, string2.indexOf("value") - 2);
            String[] stringArray = string2.split(" ");
            if (!string2.startsWith("0x")) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = "0x" + stringArray[n2];
                }
            }
            nArray[0] = (int)Long.decode(stringArray[2]).longValue() * 0x1000000;
            nArray[0] = nArray[0] + (int)Long.decode(stringArray[3]).longValue() * 65536;
            nArray[0] = nArray[0] + (int)Long.decode(stringArray[4]).longValue() * 256;
            nArray[0] = nArray[0] + (int)Long.decode(stringArray[5]).longValue();
            n = n2 = (int)Byte.decode(stringArray[0]).byteValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }
}

