/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.service.scale.ScaleService17Impl;
import com.zebra.jpos.service.scale.ScaleServiceImpl;
import com.zebra.jpos.serviceonscale.SvcAbstractService;
import com.zebra.log.scale.JCoreLogger;
import java.util.Iterator;
import java.util.LinkedList;
import jpos.JposException;
import jpos.services.ScaleService18;

public class ScaleService18Impl
extends ScaleService17Impl
implements ScaleService18 {
    public synchronized boolean getCapStatisticsReporting() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"getCapStatisticsReporting");
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this.capStatisticsReporting});
        return this.capStatisticsReporting;
    }

    public synchronized boolean getCapUpdateStatistics() throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"getCapUpdateStastistics");
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{this.capUpdateStatistics});
        return this.capUpdateStatistics;
    }

    public synchronized void resetStatistics(String string) throws JposException {
        Object object;
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"resetStatistics");
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.claimed) {
            JposException jposException = new JposException(103, "Device not Claimed");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.deviceEnabled) {
            JposException jposException = new JposException(105, "Device not Enabled");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.capStatisticsReporting) {
            JposException jposException = new JposException(106, "Statistics Reporting not supported");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.isEmpty()) {
            bl2 = true;
            bl = true;
        } else {
            bl = true;
            for (String string3 : object = string.split(",")) {
                if (string3.equals("GoodWeightReadCount")) {
                    bl2 = true;
                    continue;
                }
                if (string3.equals("M_")) continue;
                if (string3.equals("U_")) {
                    bl2 = true;
                    continue;
                }
                if (string3.isEmpty()) continue;
                bl = false;
            }
        }
        if (!bl) {
            object = new JposException(106, "Named Statistic(s) is(are) not defined");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{object});
            throw object;
        }
        if (bl2) {
            this.resetStat(15219);
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[0]);
    }

    private int getGoodWeightReadCount() {
        ScaleServiceImpl.ScaleRSMValue scaleRSMValue = new ScaleServiceImpl.ScaleRSMValue(this);
        scaleRSMValue.iAttrId = 15219;
        LinkedList<ScaleServiceImpl.ScaleRSMValue> linkedList = new LinkedList<ScaleServiceImpl.ScaleRSMValue>();
        linkedList.add(scaleRSMValue);
        this.getRSMAttributes(linkedList);
        return linkedList.get(0) != null ? ((ScaleServiceImpl.ScaleRSMValue)linkedList.get((int)0)).intValue : 0;
    }

    public void retrieveStatistics(String[] stringArray) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])stringArray);
        if (stringArray == null || stringArray.length != 1) {
            JCoreLogger.Log((boolean)false, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"retrieveStatistics", (String)"The input buffer is null or empty");
            JposException jposException = new JposException(106, "Invalid input parameters");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"retrieveStatistics started");
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Name: GoodWeightReadCount");
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Value: " + this.getGoodWeightReadCount()));
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.claimed) {
            JposException jposException = new JposException(103, "Device not Claimed");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.deviceEnabled) {
            JposException jposException = new JposException(105, "Device not Enabled");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.capStatisticsReporting) {
            JposException jposException = new JposException(106, "Statistics Reporting not supported");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        String string2 = stringArray[0];
        stringArray[0] = this.generateRetrieveStastisticsOutputXML(string2);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    private String generateRetrieveStastisticsOutputXML(String string) throws JposException {
        Iterator iterator;
        ScaleServiceImpl.ScaleRSMValue scaleRSMValue = new ScaleServiceImpl.ScaleRSMValue(this);
        scaleRSMValue.clean();
        scaleRSMValue.iAttrId = 15219;
        LinkedList<ScaleServiceImpl.ScaleRSMValue> linkedList = new LinkedList<ScaleServiceImpl.ScaleRSMValue>();
        linkedList.add(scaleRSMValue);
        this.getRSMAttributes(linkedList);
        scaleRSMValue = (ScaleServiceImpl.ScaleRSMValue)linkedList.get(0);
        int n = scaleRSMValue.intValue;
        String[] stringArray = string.split(",");
        LinkedList<String> linkedList2 = new LinkedList<String>();
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!(string2.matches("^[a-zA-Z0-9]*$") || string2.equals("U_") || string2.equals("M_"))) {
                throw new JposException(106, "Invalid statistics");
            }
            if (string2.equals("GoodWeightReadCount")) {
                bl = true;
                continue;
            }
            if (string2.equals("U_")) {
                bl = true;
                continue;
            }
            if (string2.equals("")) {
                bl = true;
                continue;
            }
            if (string2.equals("M_")) continue;
            linkedList2.add(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<UPOSStat>\n");
        stringBuilder.append("    <Event>\n");
        if (bl) {
            stringBuilder.append("        <Parameter>\n");
            stringBuilder.append("            <Name>GoodWeightReadCount</Name>\n");
            stringBuilder.append("            <Value>" + n + "</Value>\n");
            stringBuilder.append("        </Parameter>\n");
        }
        if ((iterator = linkedList2.iterator()).hasNext()) {
            String string3 = (String)iterator.next();
            throw new JposException(106, "Named statistic(s) are not defined");
        }
        int n2 = this.getDeviceServiceVersion();
        String string4 = this.getUposServiceVersionText(n2);
        stringBuilder.append("    </Event>\n");
        stringBuilder.append("    <Equipment>\n");
        stringBuilder.append("        <UnifiedPOSVersion>" + string4 + "</UnifiedPOSVersion>\n");
        stringBuilder.append("         <DeviceCategory UPOS=\"" + "Scale" + "\"/>\n");
        stringBuilder.append("         <ManufacturerName>Zebra Technologies</ManufacturerName>\n");
        stringBuilder.append("         <ModelName>" + this.modelNumber + "</ModelName>\n");
        stringBuilder.append("         <SerialNumber>" + this.serialNumber + "</SerialNumber>\n");
        stringBuilder.append("         <FirmwareRevision>" + this.firmwareVersion + "</FirmwareRevision>\n");
        stringBuilder.append("         <Interface>USB</Interface>\n");
        stringBuilder.append("     </Equipment>\n");
        stringBuilder.append("</UPOSStat>\n");
        return stringBuilder.toString();
    }

    private String getUposServiceVersionText(int n) {
        int n2 = n / 1000000;
        int n3 = (n - 1000000) / 1000;
        int n4 = (n - 1000000 - n3 * 1000) / 10;
        return n2 + "." + n3 + "." + n4;
    }

    public void updateStatistics(String string) throws JposException {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)false, (Object[])new Object[]{string});
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"updateStatistics");
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"retrieveStatistics");
        if (!this.isOpen) {
            JposException jposException = new JposException(101, "Device not opened");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.claimed) {
            JposException jposException = new JposException(103, "Device not Claimed");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (SvcAbstractService.state == 107) {
            JposException jposException = new JposException(107, "Device not connected");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.deviceEnabled) {
            JposException jposException = new JposException(105, "Device not Enabled");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!this.capStatisticsReporting) {
            JposException jposException = new JposException(106, "Statistics Reporting not supported");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        if (!string.isEmpty()) {
            if (string.startsWith("\"\"=")) {
                JposException jposException = new JposException(106, "Statistics update does not support for GoodReadWeightCount");
                JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
                throw jposException;
            }
            String[] stringArray = string.split(",");
            boolean bl = true;
            boolean bl2 = true;
            for (String string3 : stringArray) {
                if (string3.startsWith("GoodWeightReadCount=")) {
                    bl = false;
                    continue;
                }
                if (string3.startsWith("M_=")) continue;
                if (string3.startsWith("U_=")) {
                    bl = false;
                    continue;
                }
                if (string3.isEmpty()) continue;
                bl2 = false;
            }
            if (!bl || !bl2) {
                if (!bl2) {
                    JposException jposException = new JposException(106, "Named statistic(s) are not defined");
                    JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
                    throw jposException;
                }
                if (!bl) {
                    JposException jposException = new JposException(106, "Named statistic(s) cannot be updated");
                    JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
                    throw jposException;
                }
            }
        } else {
            JposException jposException = new JposException(106, "Stastistics invalid parameter");
            JCoreLogger.Log((char)'*', (String)string2, (boolean)false, (Object[])new Object[]{jposException});
            throw jposException;
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[0]);
    }
}

