/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.jniscale.ArgStruct;
import com.zebra.jpos.jniscale.GetScannerArgStruct;
import com.zebra.jpos.jniscale.JCoreScale;
import com.zebra.jpos.jniscale.JniXmlElement;
import com.zebra.jpos.jniscale.OpenArgStruct;
import com.zebra.jpos.service.scale.LiveWeightThread;
import com.zebra.jpos.service.scale.ReadWeightAsyncModeThread;
import com.zebra.jpos.service.scale.ReceiveAsyncErrorResponse;
import com.zebra.jpos.service.scale.ScaleDirectIOEventQueue;
import com.zebra.jpos.service.scale.ScaleDirectIOEventQueueEntry;
import com.zebra.jpos.service.scale.ScaleDirectIOEventSink;
import com.zebra.jpos.service.scale.ScaleEventQueueEntry;
import com.zebra.jpos.service.scale.ScaleEventSink;
import com.zebra.jpos.service.scale.ScaleStatusEventQueue;
import com.zebra.jpos.service.scale.ScaleStatusEventQueueEntry;
import com.zebra.jpos.service.scale.ScaleStatusEventSink;
import com.zebra.jpos.service.scale.ScaleWeight;
import com.zebra.jpos.service.scale.XmlProcessor;
import com.zebra.jpos.serviceonscale.SvcAbstractService;
import com.zebra.jpos.serviceonscale.SvcDirectIO;
import com.zebra.jpos.serviceonscale.SvcPnpEventHandle;
import com.zebra.jpos.serviceonscale.directio.DirectIOData;
import com.zebra.log.scale.JCoreLogger;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.StatusUpdateEvent;
import jpos.loader.JposServiceLoader;
import jpos.services.EventCallbacks;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ScaleServiceImpl
extends SvcAbstractService
implements ScaleEventSink,
ReceiveAsyncErrorResponse,
ScaleStatusEventSink,
ScaleDirectIOEventSink {
    boolean bSyncReadWeightOnZeroTimeout = false;
    private static final int INVALID_SCALE_ID = -1;
    private static final String XML_OPEN_INARGS = "<inArgs>";
    private static final String XML_OPEN_SCANNER_ID = "<scannerID>";
    private static final String XML_CLOSE_SCANNER_ID = "</scannerID>";
    private static final String XML_OPEN_CMDARGS = "<cmdArgs>";
    private static final String XML_OPEN_ARG_XML = "<arg-xml>";
    private static final String XML_OPEN_ATTRIBUTE_LIST = "<attrib_list>";
    private static final String XML_CLOSE_ATTRIBUTE_LIST = "</attrib_list>";
    private static final String XML_CLOSE_ARG_XML = "</arg-xml>";
    private static final String XML_CLOSE_CMDARGS = "</cmdArgs>";
    private static final String XML_CLOSE_INARGS = "</inArgs>";
    private static final String XML_ATTRIBUTE_SEPERATOR = ",";
    private static final String NO_OF_SUBSCRIPTIONS = "3";
    protected int iLiveWeightFrequency = 500;
    private int NcrScaleReadWeightTimeout = 150;
    private int NcrScaleStatusTimeout = 150;
    private int NcrScaleDIODirectTimeout = 150;
    protected LiveWeightThread readLiveWeight = null;
    protected Thread threadReadLiveWeight = null;
    protected SvcPnpEventHandle svcPnpEvenHandleThread = null;
    private final int healthCheckBeepPattern = 12;
    public static int errorCode = 0;
    public static int extErrorOverWeight = 0;
    public static int extErrorUnderZero = 0;
    public static int extErrorSameWeight = 0;
    public static int extErrorNonStableWeight = 0;
    public static int extErrorStableZeroWeight = 0;
    private final byte weightUnitKgFlag = 1;
    private final byte weightUnitPoundFlag = (byte)4;
    private final byte stableWeightUnderZeroFlag = (byte)2;
    private final byte stableWeightOverLimitFlag = (byte)4;
    private final byte stableZeroWeightFlag = (byte)8;
    private final byte scaleReqZeroingFlag = (byte)22;
    private final byte scaleStatusLength = (byte)4;
    private final byte scaleStatusBitTwoDefault = (byte)4;
    private final byte scaleStatusBitFourDefault = 0;
    private static final int DIO_STATUS_SUCCESS = 0;
    private static final int DIO_STATUS_FAIL = 1;
    public ScaleStatusEventQueue scaleStatusEvents = null;
    protected ScaleDirectIOEventQueue scaleDirectIOEvents = null;
    public static LinkedList<ScaleEventQueueEntry> _queue;
    public static boolean isAsyncTimeoutExceeded;
    public static boolean isReadWeightInProgress;
    public static boolean isZeroScale;
    private int clearScaleQueueOnRelease = 0;
    protected static ScaleServiceImpl scale;
    protected boolean capDisplayText = false;
    protected boolean capPriceCalculating = false;
    protected boolean capStatusUpdate = true;
    protected boolean capTareWeight = false;
    protected boolean capZeroScale = true;
    protected boolean asyncMode = false;
    protected static int powerState;
    protected int maxDisplayTextChars = 0;
    protected int maximumWeight;
    protected long salesPrice = 0L;
    protected int scaleLiveWeight = 0;
    protected int statusNotify;
    protected int tareWeight = 0;
    protected long unitPrice = 0L;
    protected int weightUnit = -1;
    protected boolean zeroValid = false;
    protected static int scaleIndex;
    private JposEntry.Prop jpeProp;
    protected String serialNumber = "";
    protected String modelNumber = "";
    protected String dateOfManufacture = "";
    protected String systemUpTime = "";
    protected String lastServiceDate = "";
    protected String firmwareVersion = "";
    protected ReadWeightAsyncModeThread readWeightAsyncModeThread = null;
    protected Thread threadReadWeightAsyncMode = null;
    protected ScaleEventQueue scaleEventQueue = null;
    protected static final String uposDeviceCategory = "Scale";
    protected static final String uposVersion = "1.14";
    protected static final String uposManifactureName = "Zebra Technologies";
    protected static final String uposInterface = "USB";

    @Override
    public void PowerNotificationEventHandler(ScaleStatusEventQueueEntry scaleStatusEventQueueEntry) {
        try {
            this.eventCallBacks.fireStatusUpdateEvent((StatusUpdateEvent)scaleStatusEventQueueEntry.jposEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void ScaleDirectIOEventHandler(ScaleDirectIOEventQueueEntry scaleDirectIOEventQueueEntry) {
        try {
            if (this.eventCallBacks != null) {
                this.eventCallBacks.fireDirectIOEvent((DirectIOEvent)scaleDirectIOEventQueueEntry.jposEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void scaleEventHandler(ScaleEventQueueEntry scaleEventQueueEntry) {
        switch (scaleEventQueueEntry.iEventType) {
            case 0: {
                int n = scaleEventQueueEntry.iWeight;
                this.eventCallBacks.fireDataEvent(new DataEvent(scaleEventQueueEntry.jpe.getSource(), n));
                break;
            }
            case 2: {
                ErrorEvent errorEvent = (ErrorEvent)scaleEventQueueEntry.jpe;
                this.eventCallBacks.fireErrorEvent(errorEvent);
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                StatusUpdateEvent statusUpdateEvent = (StatusUpdateEvent)scaleEventQueueEntry.jpe;
                this.eventCallBacks.fireStatusUpdateEvent(statusUpdateEvent);
                break;
            }
        }
    }

    @Override
    public void receiveAsyncErrorResponse(long l, int n) {
        this.readWeightAsyncModeThread.receiveAsyncErrorResponse(l, n);
    }

    public ScaleServiceImpl() {
        this.deviceServiceDescription = "UnifiedPOS Compatible Scale Driver, \u00a9 2024 Zebra Technologies Corp. and/or its affiliates. All rights reserved. ";
        this.physicalDeviceDescription = "";
        ScaleServiceImpl scaleServiceImpl = this;
        this.scaleEventQueue = new ScaleEventQueue(this, scaleServiceImpl);
        this.scaleStatusEvents = new ScaleStatusEventQueue(this);
        this.scaleDirectIOEvents = new ScaleDirectIOEventQueue(this);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.scaleEventQueue.requestTerminate();
        this.svcPnpEvenHandleThread.StopThread();
    }

    protected void getRSMAttributes(List<ScaleRSMValue> list) {
        this.invokeRSMGetAttr(list);
        try {
            this.parseRSMGetAttrOutXML(this.argStruct, list);
        }
        catch (SAXException sAXException) {
            Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, sAXException);
        }
        catch (IOException iOException) {
            Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, iOException);
        }
        catch (JposException jposException) {
            Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, jposException);
        }
    }

    protected void resetStat(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XML_OPEN_INARGS);
        stringBuffer.append("    <scannerID>" + scaleIndex + XML_CLOSE_SCANNER_ID);
        stringBuffer.append("    <cmdArgs>");
        stringBuffer.append("        <arg-xml>");
        stringBuffer.append("            <attrib_list>");
        stringBuffer.append("                <attribute>");
        stringBuffer.append("                    <id>5006</id>");
        stringBuffer.append("                    <datatype>W</datatype>");
        stringBuffer.append("                    <value>" + n + "</value>");
        stringBuffer.append("                </attribute>");
        stringBuffer.append("            </attrib_list>");
        stringBuffer.append("        </arg-xml>");
        stringBuffer.append("    </cmdArgs>");
        stringBuffer.append(XML_CLOSE_INARGS);
        this.argStruct.inXml = stringBuffer.toString();
        this.argStruct.opcode = ArgStruct.RSM_ATTR_SET;
        JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
    }

    private void invokeRSMGetAttr(List<ScaleRSMValue> list) {
        this.argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<inArgs><scannerID>" + scaleIndex + "</scannerID><cmdArgs><arg-xml><attrib_list>");
        for (int i = 0; i < list.size(); ++i) {
            ScaleRSMValue scaleRSMValue = list.get(i);
            int n = scaleRSMValue.iAttrId;
            stringBuilder.append(n);
            if (i == list.size() - 1) continue;
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
        }
        stringBuilder.append("</attrib_list></arg-xml></cmdArgs></inArgs>");
        this.argStruct.inXml = stringBuilder.toString();
        this.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
    }

    private void parseRSMGetAttrOutXML(ArgStruct argStruct, List<ScaleRSMValue> list) throws SAXException, IOException, JposException {
        if (argStruct == null) {
            return;
        }
        if (null != this.argStruct.outXml && !this.argStruct.outXml.equals("")) {
            StringBuffer stringBuffer = new StringBuffer(this.argStruct.outXml);
            for (int i = 0; i < list.size(); ++i) {
                ScaleRSMValue scaleRSMValue = list.get(i);
                this.searchForScaleAttributes(stringBuffer, scaleRSMValue, scaleRSMValue.iAttrId);
                list.set(i, scaleRSMValue);
            }
        }
    }

    private void retrieveScaleAssetInfo() {
        try {
            if (scaleIndex == -1) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"retrieveScaleAssetInfo failed: Invalid Scale ID -1");
                return;
            }
            this.argStruct.clearArgStruct();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(XML_OPEN_INARGS);
            stringBuilder.append(XML_OPEN_SCANNER_ID);
            stringBuilder.append(scaleIndex);
            stringBuilder.append(XML_CLOSE_SCANNER_ID);
            stringBuilder.append(XML_OPEN_CMDARGS);
            stringBuilder.append(XML_OPEN_ARG_XML);
            stringBuilder.append(XML_OPEN_ATTRIBUTE_LIST);
            stringBuilder.append(535);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(536);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(533);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(534);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(10012);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(20004);
            stringBuilder.append(XML_CLOSE_ATTRIBUTE_LIST);
            stringBuilder.append(XML_CLOSE_ARG_XML);
            stringBuilder.append(XML_CLOSE_CMDARGS);
            stringBuilder.append(XML_CLOSE_INARGS);
            this.argStruct.inXml = stringBuilder.toString();
            this.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Input XML for retrieveScaleAssetInfo: " + this.argStruct.inXml));
            JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Output XML for retrieveScaleAssetInfo: " + this.argStruct.outXml));
            this.dateOfManufacture = XmlProcessor.getAttributeValue(this.argStruct.outXml, 535);
            this.lastServiceDate = XmlProcessor.getAttributeValue(this.argStruct.outXml, 536);
            this.modelNumber = XmlProcessor.getAttributeValue(this.argStruct.outXml, 533);
            this.serialNumber = XmlProcessor.getAttributeValue(this.argStruct.outXml, 534);
            this.systemUpTime = XmlProcessor.getAttributeValue(this.argStruct.outXml, 10012);
            this.firmwareVersion = XmlProcessor.getAttributeValue(this.argStruct.outXml, 20004);
        }
        catch (JposException jposException) {
            Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, jposException);
        }
    }

    public synchronized void open(String string, EventCallbacks eventCallbacks) throws JposException {
        Object object;
        StringBuilder stringBuilder;
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][open]start to open the scale...logicalName: " + string));
        JposEntry jposEntry = JposServiceLoader.getManager().getEntryRegistry().getJposEntry(string);
        if (jposEntry == null) {
            throw new JposException(109, "Logical device could not be found");
        }
        JCoreLogger.SetLogEntries((JposEntry)jposEntry);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open]JposEntry was taken ");
        if (this.isOpen) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] Scale is already OPEN ");
            throw new JposException(106, "Service is already open");
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("open openArgStruct.status = " + this.openArgStruct.status));
        if (0L != this.openArgStruct.status) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"open. Closing before call open.");
            JCoreScale.jcoreScanner.Close(this.argStruct);
        }
        this.jposEntry = JposServiceLoader.getManager().getEntryRegistry().getJposEntry(string);
        if (this.jposEntry == null) {
            throw new JposException(109, "Logical device could not be found");
        }
        this.openArgStruct.ScannerTypes = new short[8];
        this.openArgStruct.lengthOfArray = 1;
        this.openArgStruct.ScannerTypes[0] = OpenArgStruct.SCANNER_TYPES_ALL;
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] before open the controller...");
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][open] OpenArgStruct.SCANNER_TYPES_ALL: " + OpenArgStruct.SCANNER_TYPES_ALL));
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][open] this.openArgStruct.ScannerTypes[0]: " + this.openArgStruct.ScannerTypes[0]));
        this.eventCallBacks = eventCallbacks;
        JCoreScale.jcoreScanner.Open(this.openArgStruct);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] after open the controller...");
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("open openArgStruct.status after Open = " + this.openArgStruct.status));
        if (0L != this.openArgStruct.status) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][open] openArgStruct.status != 0" + this.openArgStruct.status));
            throw new JposException(4, "Error opening Scale");
        }
        JCoreScale.jcoreScanner.GetScanners(this.getScannerArgStruct);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("after GetScanners-scannercount: " + this.getScannerArgStruct.scannerCount));
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("after GetScanners-outxml: " + this.getScannerArgStruct.outXml));
        if (this.getScannerArgStruct.scannerCount <= 0) {
            JCoreScale.jcoreScanner.Close(this.argStruct);
            throw new JposException(107, "No Device Detected");
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"calling to findScale");
        if (this.findScale()) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"findScale: success");
            this.statusNotify = 1;
            this.argStruct.clearArgStruct();
            stringBuilder = new StringBuilder();
            stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
            stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGINT);
            stringBuilder.append(NO_OF_SUBSCRIPTIONS);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGINT_E);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGINT);
            stringBuilder.append(JCoreScale.SUBSCRIBE_CMD_RESPONSE);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(JCoreScale.SUBSCRIBE_PNP);
            stringBuilder.append(XML_ATTRIBUTE_SEPERATOR);
            stringBuilder.append(JCoreScale.SUBSCRIBE_RMD);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGINT_E);
            stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
            stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
            this.argStruct.inXml = stringBuilder.toString();
            this.argStruct.opcode = ArgStruct.REGISTER_FOR_EVENTS;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] calling to REGISTER_FOR_EVENTS");
            object = new ScaleWeight(this.scaleStatusEvents, this.eventCallBacks.getEventSource(), this.scaleDirectIOEvents);
            ((ScaleWeight)object).initScaleEvents();
            JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
            if (0L != this.argStruct.status) {
                System.out.println("error registering events");
                throw new JposException(4, "Error Registering for Events");
            }
            this.jpeProp = this.jposEntry.getProp("productDescription");
            if (this.jpeProp != null) {
                this.physicalDeviceDescription = this.jpeProp.getValueAsString();
            }
            this.jpeProp = this.jposEntry.getProp("productName");
            if (this.jpeProp != null) {
                this.physicalDeviceName = this.jpeProp.getValueAsString();
            }
        } else {
            throw new JposException(107, "No Scale Detected");
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] calling to retrieveScaleAssertInfo()...");
        this.retrieveScaleAssetInfo();
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] creating SvcPnpEventHandle()..");
        this.svcPnpEvenHandleThread = new SvcPnpEventHandle();
        this.svcPnpEvenHandleThread.StartThread();
        this.capPowerReporting = 1;
        SvcAbstractService.state = 2;
        ScaleWeight.deviceAttached = true;
        this.isOpen = true;
        this.argStruct.clearArgStruct();
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] end calling to findScale()...");
        this.asyncMode = false;
        this.zeroValid = false;
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] create threads : ReadWeightAsyncModeThread and start");
        this.readWeightAsyncModeThread = new ReadWeightAsyncModeThread(this.argStruct, scaleIndex, this, this.eventCallBacks);
        this.threadReadWeightAsyncMode = new Thread(this.readWeightAsyncModeThread);
        this.threadReadWeightAsyncMode.start();
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][open] start startEventQueue ");
        this.scaleEventQueue.startEventQueue();
        this.scaleEventQueue.setDataEvent(false);
        this.scaleEventQueue.setbStatusEventEnabled(false);
        this.scaleStatusEvents.stopThread = false;
        this.scaleStatusEvents.start();
        this.scaleDirectIOEvents.stopThread = false;
        this.scaleDirectIOEvents.start();
        stringBuilder = jposEntry.getProp("SyncReadWeightOnZeroTimeout");
        if (stringBuilder != null) {
            object = stringBuilder.getValueAsString();
            this.bSyncReadWeightOnZeroTimeout = Boolean.parseBoolean((String)object);
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Property bSyncReadWeightOnZeroTimeout = " + this.bSyncReadWeightOnZeroTimeout));
        }
        if ((stringBuilder = jposEntry.getProp("LiveWeightFrequency")) != null) {
            this.iLiveWeightFrequency = Integer.parseInt(stringBuilder.getValueAsString());
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Property LiveWeightFrequency =  " + this.iLiveWeightFrequency));
        } else {
            this.iLiveWeightFrequency = 500;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Property LiveWeightFrequency is not found in jpos.xml, default value" + this.iLiveWeightFrequency));
        }
        try {
            errorCode = Integer.parseInt(this.jposEntry.getProp("ErrorCode").getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            errorCode = 114;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ErrorCode is not defined. Proceeding with the default error code");
        }
        catch (NumberFormatException numberFormatException) {
            errorCode = 114;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ErrorCode is not valid. Proceeding with the default error code");
        }
        try {
            extErrorOverWeight = Integer.parseInt(this.jposEntry.getProp("ExtErrorOverWeight").getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            extErrorOverWeight = 201;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorOverWeight is not defined. Proceeding with the default error code");
        }
        catch (NumberFormatException numberFormatException) {
            extErrorOverWeight = 201;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorOverWeight is not valid. Proceeding with the default error code");
        }
        try {
            extErrorUnderZero = Integer.parseInt(this.jposEntry.getProp("ExtErrorUnderZero").getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            extErrorUnderZero = 202;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorUnderZero is not defined. Proceeding with the default error code");
        }
        catch (NumberFormatException numberFormatException) {
            extErrorUnderZero = 202;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorOverWeight is not valid. Proceeding with the default error code");
        }
        try {
            extErrorSameWeight = Integer.parseInt(this.jposEntry.getProp("ExtErrorSameWeight").getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            extErrorSameWeight = 203;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorSameWeight is not defined. Proceeding with the default error code");
        }
        catch (NumberFormatException numberFormatException) {
            extErrorSameWeight = 203;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorOverWeight is not valid. Proceeding with the default error code");
        }
        try {
            extErrorNonStableWeight = Integer.parseInt(this.jposEntry.getProp("ExtErrorNonStableWeight").getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            extErrorNonStableWeight = 112;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorNonStableWeight is not defined. Proceeding with the default error code");
        }
        catch (NumberFormatException numberFormatException) {
            extErrorNonStableWeight = 112;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorNonStableWeight is not valid. Proceeding with the default error code");
        }
        try {
            extErrorStableZeroWeight = Integer.parseInt(this.jposEntry.getProp("ExtErrorStableZeroWeight").getValueAsString());
        }
        catch (NullPointerException nullPointerException) {
            extErrorStableZeroWeight = 112;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorStableZeroWeight is not defined. Proceeding with the default error code");
        }
        catch (NumberFormatException numberFormatException) {
            extErrorStableZeroWeight = 112;
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ExtErrorStableZeroWeight is not valid. Proceeding with the default error code");
        }
        try {
            this.NcrScaleReadWeightTimeout = Integer.parseInt(this.jposEntry.getProp("NcrScaleReadWeightTimeout").getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid Read Weight Time Out value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"NcrScaleReadWeightTimeout is not defined. Proceeding with the default value");
        }
        try {
            this.NcrScaleStatusTimeout = Integer.parseInt(this.jposEntry.getProp("NcrScaleStatusTimeout").getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid Status Time Out value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"NcrScaleStatusTimeout is not defined. Proceeding with the default value");
        }
        try {
            this.NcrScaleDIODirectTimeout = Integer.parseInt(this.jposEntry.getProp("NcrScaleDIODirectTimeout").getValueAsString());
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Invalid DIO Direct Time Out value. Proceeding with the default value");
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"NcrScaleDIODirectTimeout is not defined. Proceeding with the default value");
        }
        try {
            this.clearScaleQueueOnRelease = Integer.parseInt(this.jposEntry.getProp("ClearQueueOnRelease").getValueAsString());
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("Value of ClearQueueOnRelease =  " + this.clearScaleQueueOnRelease));
        }
        catch (NullPointerException nullPointerException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ClearQueueOnRelease is not defined. Proceeding with the default value");
        }
        catch (NumberFormatException numberFormatException) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"ClearQueueOnRelease is not valid. Proceeding with the default value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"close");
        if (this.claimed) {
            this.release();
        }
        if (!this.isOpen) {
            throw new JposException(101, "Device not opened");
        }
        this.checkHealthText = "";
        this.claimed = false;
        this.deviceEnabled = false;
        this.deviceServiceDescription = "UnifiedPOS Compatible Scale Service Driver, \u00a9 2024 Zebra Technologies Corp. and/or its affiliates. All rights reserved. ";
        this.freezeEvents = false;
        this.physicalDeviceDescription = "";
        this.physicalDeviceName = "";
        SvcAbstractService.state = 1;
        this.eventCallBacks = null;
        this.argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGINT);
        stringBuilder.append("1");
        stringBuilder.append(JniXmlElement.ELEMENT_ARGINT_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGINT);
        stringBuilder.append(JCoreScale.SUBSCRIBE_CMD_RESPONSE);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGINT_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
        this.argStruct.inXml = stringBuilder.toString();
        this.readWeightAsyncModeThread.requestTerminateThread();
        try {
            this.threadReadWeightAsyncMode.join();
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        if (this.readLiveWeight != null && !this.readLiveWeight.getThreadTerminationRequested()) {
            try {
                this.readLiveWeight.terminateTheThread();
                this.threadReadLiveWeight.join();
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
            this.readLiveWeight = null;
            this.threadReadLiveWeight = null;
        }
        JCoreScale.jcoreScanner.Close(this.argStruct);
        Thread thread = this.scaleStatusEvents;
        synchronized (thread) {
            this.scaleStatusEvents.stopThread = true;
            this.scaleStatusEvents.notify();
        }
        thread = this.scaleDirectIOEvents;
        synchronized (thread) {
            this.scaleDirectIOEvents.stopThread = true;
            this.scaleDirectIOEvents.notify();
        }
        this.svcPnpEvenHandleThread.StopThread();
        this.scaleEventQueue.requestTerminate();
        try {
            this.scaleEventQueue.join();
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        this.scaleEventQueue.setDataEvent(false);
        this.scaleEventQueue.setbStatusEventEnabled(false);
    }

    public synchronized void claim(int n) throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"claim");
        if (!this.isOpen) {
            throw new JposException(101, "Device not Opened");
        }
        if (SvcAbstractService.state == 107) {
            throw new JposException(107, "Device not connected");
        }
        if (this.claimed) {
            throw new JposException(102, "Device Already Claimed");
        }
        if (n < -1) {
            throw new JposException(106, "Invalid timeout");
        }
        long l = System.currentTimeMillis();
        while (n == -1 || System.currentTimeMillis() - l <= (long)n) {
            if (this.findScale() && this.getScannerArgStruct.scannerCount > 0) {
                this.claimed = true;
                this.scaleStatusEvents.deviceClaimed = true;
                this.scaleDirectIOEvents.deviceClaimed = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.claimed) {
            throw new JposException(107, "Device not connected");
        }
    }

    public synchronized void release() throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"release");
        if (!this.isOpen) {
            throw new JposException(101, "Device not Opened");
        }
        if (!this.claimed) {
            throw new JposException(103, "Device Not Claimed");
        }
        if (SvcAbstractService.state == 107) {
            throw new JposException(107, "Device not connected");
        }
        this.setDeviceEnabled(false);
        this.claimed = false;
        if (this.clearScaleQueueOnRelease == 1) {
            _queue.clear();
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Queue is cleared");
        }
    }

    public synchronized void setDeviceEnabled(boolean bl) throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("setDeviceEnabled fEnable : " + bl));
        if (!this.isOpen) {
            throw new JposException(101, "Device not opened");
        }
        if (SvcAbstractService.state == 107) {
            throw new JposException(107, "Device not connected");
        }
        if (!ScaleWeight.deviceAttached && bl) {
            throw new JposException(107, "Device not connected");
        }
        this.argStruct.clearArgStruct();
        if (bl && !this.claimed) {
            throw new JposException(103, "Device not claimed");
        }
        this.deviceEnabled = bl;
        if (this.deviceEnabled) {
            if (this.readLiveWeight != null && this.threadReadLiveWeight != null && this.threadReadLiveWeight.isAlive()) {
                return;
            }
            if (this.readLiveWeight == null) {
                this.readLiveWeight = new LiveWeightThread(this.iLiveWeightFrequency, scaleIndex, this, this.eventCallBacks);
            }
            if (this.threadReadLiveWeight == null) {
                this.threadReadLiveWeight = new Thread(this.readLiveWeight);
            }
            if (this.statusNotify == 2) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Starting live weight thread");
                this.threadReadLiveWeight.start();
            }
            this.scaleEventQueue.setbDeviceEnabled(bl);
            this.scaleStatusEvents.deviceEnabled = this.deviceEnabled;
            this.scaleStatusEvents.AddTail(this.eventCallBacks.getEventSource(), 0);
            this.scaleDirectIOEvents.deviceEnabled = this.deviceEnabled;
        } else {
            if (this.statusNotify == 2 && this.readLiveWeight != null && !this.readLiveWeight.getThreadTerminationRequested()) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Terminating live weight thread");
                this.readLiveWeight.terminateTheThread();
                try {
                    this.threadReadLiveWeight.join();
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
                this.readLiveWeight = null;
                this.threadReadLiveWeight = null;
            }
            this.scaleStatusEvents.deviceEnabled = this.deviceEnabled;
            this.scaleEventQueue.setbDeviceEnabled(bl);
            powerState = 2004;
            this.scaleDirectIOEvents.deviceEnabled = this.deviceEnabled;
        }
    }

    public String getCheckHealthText() throws JposException {
        if (!this.isOpen) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        if (!this.checkHealthText.isEmpty()) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("CheckHealth: " + this.checkHealthText));
        }
        return this.checkHealthText;
    }

    public synchronized void checkHealth(int n) throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"checkHealth");
        if (!this.isOpen) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
            throw new JposException(101, "Device is closed");
        }
        if (!this.claimed) {
            this.checkHealthText = "Device Not claimed";
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)102, (String)"Device is not claimed");
            throw new JposException(103, "Device is not claimed");
        }
        if (!this.deviceEnabled) {
            this.checkHealthText = "Device Not Enabled";
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)105, (String)"Device is not enabled");
            throw new JposException(105, "Device is disabled.");
        }
        if (!this.findScale()) {
            this.checkHealthText = "No Hardware";
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)107, (String)"No Device Detected");
            throw new JposException(107, "No Device Detected.");
        }
        if (n == 1) {
            this.checkHealthText = "Internal HCheck: Successful";
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"CheckHealth: Internal HCheck: Successful");
        } else if (n == 2) {
            int[] nArray = new int[1];
            this.executeBeepCommnad(12, nArray);
            if (nArray[0] == 0 && this.isExternalHealthCheckSuccess()) {
                this.checkHealthText = "External HCheck: Successful";
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"CheckHealth: External HCheck: Successful");
            } else {
                this.checkHealthText = "External HCheck: Failed";
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)0, (String)"CheckHealth: External HCheck: failed");
            }
        } else {
            this.checkHealthText = "Interactive HCheck: NOT Supported";
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)106, (String)"CheckHealth: Health check level not supported");
            throw new JposException(106, "Health check level not supported");
        }
    }

    private void executeBeepCommnad(int n, int[] nArray) {
        GetScannerArgStruct getScannerArgStruct = new GetScannerArgStruct();
        JCoreScale.jcoreScanner.GetScanners(getScannerArgStruct);
        nArray[0] = (int)getScannerArgStruct.status;
        for (int i = 0; i < getScannerArgStruct.scannerCount; ++i) {
            String string = "<inArgs><scannerID>" + getScannerArgStruct.scannerIDs[i] + "</scannerID><cmdArgs><arg-xml><attrib_list><attribute><id>6000</id><datatype>X</datatype><value>" + n + "</value></attribute></attrib_list></arg-xml></cmdArgs></inArgs>";
            ArgStruct argStruct = new ArgStruct();
            argStruct.status = 0L;
            argStruct.inXml = string;
            argStruct.opcode = 5004;
            JCoreScale.jcoreScanner.ExecCommand(argStruct);
        }
    }

    private boolean isExternalHealthCheckSuccess() {
        GetScannerArgStruct getScannerArgStruct = new GetScannerArgStruct();
        JCoreScale.jcoreScanner.GetScanners(getScannerArgStruct);
        int n = 5001;
        int[] nArray = new int[]{-1};
        for (int i = 0; i < getScannerArgStruct.scannerCount; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<inArgs> <scannerID>" + getScannerArgStruct.scannerIDs[i] + "</scannerID> <cmdArgs>  <arg-xml>   <attrib_list>8</attrib_list>  </arg-xml> </cmdArgs></inArgs>");
            try {
                this.directIO(n, nArray, stringBuffer);
            }
            catch (JposException jposException) {
                return false;
            }
            if (nArray[0] == 0) continue;
            return false;
        }
        return nArray[0] == 0;
    }

    public synchronized void directIO(int n, int[] nArray, Object object) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"directIO");
        if (!this.isOpen) {
            throw new JposException(101, "Device not Opened");
        }
        if (n == 604) {
            if (!this.claimed) {
                throw new JposException(103, "Device not Claimed");
            }
            if (!this.deviceEnabled) {
                throw new JposException(105, "Device not Enabled");
            }
            int[] nArray2 = new int[1];
            if (nArray.length <= 0) {
                throw new JposException(111, "Invalid arguments");
            }
            if (this.NcrScaleReadWeightTimeout < -1) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)106, (String)"readWeight Invalid timeout");
                JposException jposException = new JposException(106, "Invalid timeout");
                throw jposException;
            }
            try {
                ScaleWeight.readWeight(scaleIndex, nArray2, this.NcrScaleReadWeightTimeout, this.zeroValid, 1);
                nArray[0] = nArray2[0];
                object = nArray2[0];
            }
            catch (JposException jposException) {
                nArray[0] = jposException.getErrorCode();
                throw jposException;
            }
        } else if (n == 601) {
            if (this.NcrScaleStatusTimeout < -1) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)106, (String)"readWeight Invalid timeout");
                JposException jposException = new JposException(106, "Invalid timeout");
                throw jposException;
            }
            ScaleWeight.readWeightForNCRStatus(scaleIndex, this.NcrScaleStatusTimeout);
            byte[] byArray = new byte[]{4, 4, 4, 0};
            if (ScaleWeight.getUnit() == 2) {
                byArray[2] = (byte)(byArray[2] | 1);
            }
            if (ScaleWeight.readWeightStatus == 3) {
                byArray[3] = (byte)(byArray[3] | 2);
            }
            if (ScaleWeight.readWeightStatus == 2) {
                byArray[3] = (byte)(byArray[3] | 4);
            }
            if (ScaleWeight.readWeightStatus == 5) {
                byArray[3] = (byte)(byArray[3] | 8);
            }
            if (ScaleWeight.readWeightStatus == 4 || ScaleWeight.readWeightStatus == 6 || ScaleWeight.readWeightStatus == 1 || ScaleWeight.readWeightStatus == 0) {
                byArray[3] = (byte)(byArray[3] | 0x16);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02X ", by));
            }
            if (object instanceof StringBuffer) {
                Object object2 = (StringBuffer)object;
                ((StringBuffer)object2).append((CharSequence)stringBuilder);
                object = object2;
            } else {
                object = stringBuilder.toString();
            }
            nArray[0] = 0;
        } else if (n == 605) {
            if (this.NcrScaleDIODirectTimeout < -1) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)106, (String)"readWeight Invalid timeout");
                JposException jposException = new JposException(106, "Invalid timeout");
                throw jposException;
            }
            if (object instanceof StringBuffer) {
                int n2 = this.getElementValueFromXml(object.toString(), "/inArgs");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(this.removeElementFromXml(object.toString(), "/inArgs/opcode"));
                ((StringBuffer)object).delete(0, ((StringBuffer)object).length()).append(stringBuffer);
                SvcDirectIO.directIO((int)n2, (int[])nArray, (int)this.NcrScaleDIODirectTimeout, (Object)object);
                if (n2 == 5000 || n2 == 5001 || n2 == 5002) {
                    nArray[0] = 1;
                } else if (n2 == 5004 || n2 == 5005) {
                    nArray[0] = 0;
                }
            } else {
                DirectIOData directIOData = (DirectIOData)object;
                int n3 = this.getElementValueFromXml(directIOData.inXML, "/inArgs");
                directIOData.inXML = this.removeElementFromXml(directIOData.inXML, "/inArgs/opcode");
                object = directIOData;
                SvcDirectIO.directIO((int)n3, (int[])nArray, (int)this.NcrScaleDIODirectTimeout, (Object)object);
                if (n3 == 5000 || n3 == 5001 || n3 == 5002) {
                    nArray[0] = 1;
                } else if (n3 == 5004 || n3 == 5005) {
                    nArray[0] = 0;
                }
            }
        } else {
            SvcDirectIO.directIO((int)n, (int[])nArray, (int)this.NcrScaleDIODirectTimeout, (Object)object);
        }
        JCoreLogger.Log((char)'#', (String)string, (boolean)false, (Object[])new Object[]{"Calling Direct IO : " + this.directIOToString(n), object});
    }

    private String directIOToString(int n) {
        switch (n) {
            case 1: {
                return "GET_SCANNERS";
            }
            case 5000: {
                return "RSM_ATTR_GETALL";
            }
            case 5001: {
                return "RSM_ATTR_GET";
            }
            case 5002: {
                return "RSM_ATTR_GETNEXT";
            }
            case 5004: {
                return "RSM_ATTR_SET";
            }
            case 5005: {
                return "RSM_ATTR_STORE";
            }
            case 605: {
                return "NCRDIO_SCAL_DIRECT";
            }
            case 604: {
                return "NCR_DIO_SCAL_LIVE_WEIGHT";
            }
            case 601: {
                return "NCRDIO_SCAL_STATUS";
            }
        }
        return "UNKNOWN_DIO";
    }

    private int getElementValueFromXml(String string, String string2) throws JposException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                return Integer.parseInt(element.getElementsByTagName("opcode").item(0).getTextContent().trim());
            }
            throw new JposException(106, "Opcode not found in inXml");
        }
        catch (Exception exception) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to pass the XML");
            throw new JposException(106, "Failed to pass the XML");
        }
    }

    private String removeElementFromXml(String string, String string2) throws JposException {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string3 = "/inArgs/opcode";
            NodeList nodeList = (NodeList)xPath.compile(string2).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = nodeList.item(i);
                if (!object.getNodeName().equals("opcode")) continue;
                object.getParentNode().removeChild((Node)object);
                break;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (Exception exception) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to pass the XML");
            return "";
        }
    }

    public synchronized void setFreezeEvents(boolean bl) throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("setFreezeEvents fFreeze : " + bl));
        if (!this.isOpen) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
            throw new JposException(101, "Device not open");
        }
        if (bl) {
            this.scaleEventQueue.requestFreeze();
        } else {
            this.scaleEventQueue.requestUnFreeze();
        }
    }

    public boolean getFreezeEvents() throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("getFreezeEvents : " + this.scaleEventQueue.bFreezeEvents));
        if (!this.isOpen) {
            com.zebra.log.scanner.JCoreLogger.Log((boolean)true, (int)com.zebra.log.scanner.JCoreLogger.JCL_ERROR, (int)101, (String)"Service is not open");
        }
        return this.scaleEventQueue.bFreezeEvents;
    }

    private boolean findScale() throws JposException {
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][findScale] calling to this.getScannerArgStruct.scannerCount :" + this.getScannerArgStruct.scannerCount));
        if (this.getScannerArgStruct.scannerCount > 0) {
            for (int i = 0; i < this.getScannerArgStruct.scannerCount; ++i) {
                short s = this.getScannerArgStruct.scannerIDs[i];
                if (!this.isScalePresent(s) || !this.isScaleEnabled(s)) continue;
                this.setScaleDetails(s);
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][findScale] scale is present and enabled. returning true");
                return true;
            }
        }
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][findScale] returning false");
        return false;
    }

    private boolean isScalePresent(int n) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)true, (Object[])new Object[]{n});
        this.argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<inArgs><scannerID>" + n + "</scannerID><cmdArgs><arg-xml><attrib_list>" + 965 + "</attrib_list></arg-xml></cmdArgs></inArgs>");
        this.argStruct.inXml = stringBuilder.toString();
        this.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][isScalePresent] RSM_ATTR_GET executed. Response = " + this.argStruct.outXml));
        try {
            XmlProcessor xmlProcessor = new XmlProcessor();
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{Integer.parseInt(xmlProcessor.getAttributeValue(this.argStruct.outXml))});
            if (Integer.parseInt(xmlProcessor.getAttributeValue(this.argStruct.outXml)) == 1) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][isScalePresent] Scale is present. Response = true");
                return true;
            }
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][isScalePresent] Scale is not present. Response = false");
            return false;
        }
        catch (Exception exception) {
            JposException jposException = new JposException(106, "[debug][isScalePresent] XML parsing error. Response = false");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            return false;
        }
    }

    private boolean isScaleEnabled(int n) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)true, (Object[])new Object[]{n});
        this.argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<inArgs><scannerID>" + n + "</scannerID><cmdArgs><arg-xml><attrib_list>" + 1197 + "</attrib_list></arg-xml></cmdArgs></inArgs>");
        this.argStruct.inXml = stringBuilder.toString();
        this.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][isScaleEnabled] RSM_ATTR_GET executed. Response = " + this.argStruct.outXml));
        try {
            XmlProcessor xmlProcessor = new XmlProcessor();
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{Integer.parseInt(xmlProcessor.getAttributeValue(this.argStruct.outXml))});
            if (Integer.parseInt(xmlProcessor.getAttributeValue(this.argStruct.outXml)) == 1) {
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][isScaleEnabled] Scale is enabled. Response = true");
                return true;
            }
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][isScaleEnabled] Scale is not enabled. Response = false");
            return false;
        }
        catch (Exception exception) {
            JposException jposException = new JposException(106, "[debug][isScaleEnabled] XML parsing error. Response = false");
            JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
            return false;
        }
    }

    private void setScaleDetails(int n) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)true, (Object[])new Object[]{n});
        this.argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<inArgs><scannerID>" + n + "</scannerID><cmdArgs><arg-xml><attrib_list>" + 6017 + "</attrib_list></arg-xml></cmdArgs></inArgs>");
        this.argStruct.inXml = stringBuilder.toString();
        this.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(this.argStruct);
        JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][setScaleInfo] RSM_ATTR_GET executed. Response = " + this.argStruct.outXml));
        try {
            if (null != this.argStruct.outXml && !"".equals(this.argStruct.outXml)) {
                scaleIndex = n;
                this.weightUnit = this.getWeightUnit(this.argStruct.outXml);
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("[debug][setScaleInfo] returning true. Weight Unit = " + this.weightUnit + " Scale ID: " + scaleIndex));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"[debug][setScaleInfo] Exception while parsing xml");
            throw new JposException(106, "XML parsing error");
        }
    }

    private boolean isScaleAvailable(String string) {
        try {
            String string2 = this.argStruct.outXml.substring(this.argStruct.outXml.indexOf("value") + 6);
            string2 = string2.substring(0, string2.indexOf("value") - 2);
            String[] stringArray = string2.split(" ");
            return stringArray.length > 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int getWeightUnit(String string) {
        try {
            String string2 = this.argStruct.outXml.substring(this.argStruct.outXml.indexOf("value") + 6);
            string2 = string2.substring(0, string2.indexOf("value") - 2);
            String[] stringArray = string2.split(" ");
            if (stringArray.length > 1) {
                return Integer.parseInt(stringArray[1].replace("0x", ""));
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void searchForScaleAttributes(StringBuffer stringBuffer, ScaleRSMValue scaleRSMValue, int n) throws JposException {
        HashMap hashMap = new HashMap();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(stringBuffer.toString()));
            Document document = documentBuilder.parse(inputSource);
            document.getDocumentElement().normalize();
            XPath xPath = XPathFactory.newInstance().newXPath();
            String string = "/outArgs/arg-xml/response/attrib_list/attribute";
            NodeList nodeList = (NodeList)xPath.compile(string).evaluate(document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(string2 = (element = (Element)node).getElementsByTagName("id").item(0).getTextContent()).trim().equals(String.valueOf(n))) continue;
                scaleRSMValue.rawValue = element.getElementsByTagName("value").item(0).getTextContent().trim();
                scaleRSMValue.chType = element.getElementsByTagName("datatype").item(0).getTextContent().trim().charAt(0);
                break;
            }
            switch (scaleRSMValue.chType) {
                case 'B': {
                    scaleRSMValue.byteValue = Byte.parseByte(scaleRSMValue.rawValue);
                    break;
                }
                case 'C': {
                    scaleRSMValue.charValue = scaleRSMValue.rawValue.charAt(0);
                    break;
                }
                case 'F': {
                    scaleRSMValue.booleanValue = scaleRSMValue.rawValue.equals("True");
                    break;
                }
                case 'I': {
                    scaleRSMValue.shortValue = Short.parseShort(scaleRSMValue.rawValue);
                    break;
                }
                case 'D': {
                    scaleRSMValue.intValue = Integer.parseInt(scaleRSMValue.rawValue);
                    break;
                }
                case 'L': {
                    scaleRSMValue.intValue = Integer.parseInt(scaleRSMValue.rawValue);
                    break;
                }
                case 'A': {
                    break;
                }
                case 'S': {
                    scaleRSMValue.strValue = scaleRSMValue.rawValue;
                    break;
                }
            }
        }
        catch (Exception exception) {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_ERROR, (int)111, (String)"Failed to pass the XML");
        }
    }

    public ScaleWeight ReadWeight(int n) {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n});
        ArgStruct argStruct = new ArgStruct();
        argStruct.clearArgStruct();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID);
        stringBuilder.append(n);
        stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST);
        stringBuilder.append(ArgStruct.RSM_SCALE_READ_WEIGHT);
        stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST_E);
        stringBuilder.append(JniXmlElement.ELEMENT_ARGXML_E);
        stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
        stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
        argStruct.inXml = stringBuilder.toString();
        argStruct.opcode = ArgStruct.RSM_ATTR_GET;
        JCoreScale.jcoreScanner.ExecCommand(argStruct);
        if (argStruct == null || argStruct.outXml == null || argStruct.outXml.isEmpty()) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"Exec:ReadWeight.Returned an error"});
            return null;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"Exec:ReadWeight success status: " + argStruct.status});
        XmlProcessor xmlProcessor = new XmlProcessor();
        String string2 = xmlProcessor.getAttributeValue(argStruct.outXml);
        if (string2 == null) {
            JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"No weight read"});
            return null;
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{ScaleWeight.createFromAttributeValue(string2)});
        return ScaleWeight.createFromAttributeValue(string2);
    }

    public void setScaleLiveWeight(int n) {
        this.scaleLiveWeight = n;
    }

    static {
        isAsyncTimeoutExceeded = false;
        isReadWeightInProgress = false;
        isZeroScale = false;
        scale = null;
        powerState = 2000;
        scaleIndex = -1;
    }

    public class ScaleEventQueue
    extends Thread {
        ScaleEventSink _eventSink;
        ReceiveAsyncErrorResponse _receiveAsyncErrorResponse;
        boolean bFreezeEvents = false;
        volatile boolean bTerminateEventQueue = false;
        Thread threadObject = null;
        boolean bDataEventEnabled = false;
        boolean bStatusEventEnabled = false;
        boolean bDeviceEnabled = false;
        int iNotificationCount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setbDeviceEnabled(boolean bl) {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                this.bDeviceEnabled = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isbStatusEventEnabled() {
            boolean bl = false;
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                bl = this.bStatusEventEnabled;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setbStatusEventEnabled(boolean bl) {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                this.bStatusEventEnabled = bl;
                ++this.iNotificationCount;
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    System.out.println("Exception in notifying status event enable for scale queue");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestFreeze() throws JposException {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                this.bFreezeEvents = true;
                ++this.iNotificationCount;
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)111, (String)"setFreezeEvents failed");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getDataEventEnabled() {
            boolean bl = false;
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                bl = this.bDataEventEnabled;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDataEvent(boolean bl) {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                this.bDataEventEnabled = bl;
                ++this.iNotificationCount;
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestUnFreeze() throws JposException {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                this.bFreezeEvents = false;
                ++this.iNotificationCount;
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)111, (String)"setFreezeEvents failed");
                }
            }
        }

        void startEventQueue() {
            if (this.threadObject == null) {
                this.threadObject = new Thread(this);
                this.threadObject.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void requestTerminate() {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                this.bTerminateEventQueue = true;
                ++this.iNotificationCount;
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        private ScaleEventQueue(ScaleEventSink scaleEventSink, ReceiveAsyncErrorResponse receiveAsyncErrorResponse) {
            _queue = new LinkedList();
            this._eventSink = scaleEventSink;
            this._receiveAsyncErrorResponse = receiveAsyncErrorResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEventQueueEmpty() {
            boolean bl = false;
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                bl = _queue.isEmpty();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enqueue(ScaleEventQueueEntry scaleEventQueueEntry) {
            ScaleEventQueue scaleEventQueue = this;
            synchronized (scaleEventQueue) {
                if (scaleEventQueueEntry.iEventType == 2) {
                    ErrorEvent errorEvent = (ErrorEvent)scaleEventQueueEntry.jpe;
                    if (errorEvent.getErrorLocus() == 3) {
                        ScaleEventQueueEntry scaleEventQueueEntry2 = _queue.getFirst();
                        if (scaleEventQueueEntry2.iEventType == 2) {
                            int n = 1;
                            boolean bl = true;
                            while (bl) {
                                ScaleEventQueueEntry scaleEventQueueEntry3 = _queue.get(n);
                                if (scaleEventQueueEntry3.iEventType == 2) {
                                    ++n;
                                    continue;
                                }
                                bl = false;
                            }
                            _queue.add(n, scaleEventQueueEntry);
                        } else {
                            _queue.addFirst(scaleEventQueueEntry);
                        }
                    } else {
                        _queue.addLast(scaleEventQueueEntry);
                    }
                } else if (scaleEventQueueEntry.iEventType == 3) {
                    _queue.addFirst(scaleEventQueueEntry);
                } else {
                    _queue.addLast(scaleEventQueueEntry);
                }
                if (ScaleServiceImpl.this.autoDisable && scaleEventQueueEntry.iEventType != 3) {
                    try {
                        ScaleServiceImpl.this.setDeviceEnabled(false);
                    }
                    catch (JposException jposException) {
                        System.out.println("Failed to enable the device");
                    }
                }
                ++this.iNotificationCount;
                try {
                    this.notify();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(ScaleServiceImpl.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
                ScaleEventQueueEntry scaleEventQueueEntry = null;
                ScaleEventQueue scaleEventQueue = this;
                synchronized (scaleEventQueue) {
                    bl5 = this.bFreezeEvents;
                    bl4 = this.bTerminateEventQueue;
                    bl3 = this.bDataEventEnabled;
                    bl2 = this.bStatusEventEnabled;
                    boolean bl6 = this.bDeviceEnabled;
                }
                if (bl4) break;
                if (bl5 || !(bl = true)) continue;
                ScaleEventQueue scaleEventQueue2 = this;
                synchronized (scaleEventQueue2) {
                    if (_queue.isEmpty()) {
                        bl = false;
                    } else {
                        scaleEventQueueEntry = _queue.getFirst();
                    }
                }
                if (bl && bl2 && scaleEventQueueEntry.iEventType == 3) {
                    this._eventSink.scaleEventHandler(scaleEventQueueEntry);
                    if (!_queue.isEmpty()) {
                        _queue.pop();
                    }
                    scaleEventQueueEntry = null;
                    continue;
                }
                if (bl && bl3 && scaleEventQueueEntry.iEventType == 0) {
                    this._eventSink.scaleEventHandler(scaleEventQueueEntry);
                    if (!_queue.isEmpty()) {
                        _queue.pop();
                    }
                    this.bDataEventEnabled = false;
                    continue;
                }
                if (!bl || !bl3 || scaleEventQueueEntry.iEventType != 2) continue;
                this._eventSink.scaleEventHandler(scaleEventQueueEntry);
                if (_queue.isEmpty()) continue;
                _queue.pop();
            }
        }
    }

    public class ScaleRSMValue {
        int iAttrId;
        char chType;
        String rawValue;
        String strValue;
        byte byteValue;
        char charValue;
        boolean booleanValue;
        int intValue;
        short shortValue;
        byte[] byteArrayValue;

        public void clean() {
            this.iAttrId = 0;
            this.chType = (char)65535;
            this.rawValue = null;
            this.byteArrayValue = null;
        }
    }
}

