/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.service.scale.ScaleServiceImpl;
import com.zebra.jpos.service.scale.ScaleStatusEventQueueEntry;
import com.zebra.jpos.service.scale.ScaleStatusEventSink;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;

public class ScaleStatusEventQueue
extends Thread {
    protected boolean stopThread = true;
    private ScaleStatusEventSink statusEventSink;
    protected boolean powNotificationEnabled;
    protected boolean deviceEnabled;
    protected boolean deviceClaimed;
    private ScaleStatusEventQueueEntry eventSeqHead;
    private ScaleStatusEventQueueEntry eventSeqTail;
    protected int numEvents;
    protected int pnpStatusEvents;

    protected ScaleStatusEventQueue(ScaleStatusEventSink scaleStatusEventSink) {
        this.statusEventSink = scaleStatusEventSink;
        this.powNotificationEnabled = false;
        this.deviceEnabled = false;
        this.eventSeqHead = null;
        this.eventSeqTail = null;
        this.numEvents = 0;
        this.pnpStatusEvents = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stopThread) {
                ScaleStatusEventQueue scaleStatusEventQueue = this;
                synchronized (scaleStatusEventQueue) {
                    this.wait(100L);
                }
                ScaleStatusEventQueueEntry scaleStatusEventQueueEntry = this.eventSeqHead;
                if (!this.powNotificationEnabled || scaleStatusEventQueueEntry == null) continue;
                this.RemoveHead();
                this.statusEventSink.PowerNotificationEventHandler(scaleStatusEventQueueEntry);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void AddTail(Object object, int n) {
        ScaleStatusEventQueue scaleStatusEventQueue;
        if (!this.powNotificationEnabled || !this.deviceClaimed) {
            return;
        }
        ScaleStatusEventQueueEntry scaleStatusEventQueueEntry = null;
        if (n == 0) {
            if (this.deviceEnabled && ScaleServiceImpl.powerState != 2001) {
                ScaleServiceImpl.powerState = 2001;
                scaleStatusEventQueue = new StatusUpdateEvent(object, 2001);
                scaleStatusEventQueueEntry = new ScaleStatusEventQueueEntry((JposEvent)scaleStatusEventQueue, 3, 2001);
            }
        } else if (n == 1 && this.deviceEnabled && ScaleServiceImpl.powerState != 2004) {
            ScaleServiceImpl.powerState = 2004;
            scaleStatusEventQueue = new StatusUpdateEvent(object, 2004);
            scaleStatusEventQueueEntry = new ScaleStatusEventQueueEntry((JposEvent)scaleStatusEventQueue, 3, 2004);
        }
        scaleStatusEventQueue = this;
        synchronized (scaleStatusEventQueue) {
            if (scaleStatusEventQueueEntry != null) {
                scaleStatusEventQueueEntry.entrySeqNext = null;
                if (this.eventSeqTail == null) {
                    this.eventSeqHead = scaleStatusEventQueueEntry;
                    scaleStatusEventQueueEntry.entrySeqPrevious = null;
                } else {
                    scaleStatusEventQueueEntry.entrySeqPrevious = this.eventSeqTail;
                    this.eventSeqTail.entrySeqNext = scaleStatusEventQueueEntry;
                }
                this.eventSeqTail = scaleStatusEventQueueEntry;
                ++this.numEvents;
                if (scaleStatusEventQueueEntry.eventType == 3) {
                    ++this.pnpStatusEvents;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScaleStatusEventQueueEntry RemoveHead() {
        ScaleStatusEventQueueEntry scaleStatusEventQueueEntry;
        ScaleStatusEventQueue scaleStatusEventQueue = this;
        synchronized (scaleStatusEventQueue) {
            scaleStatusEventQueueEntry = this.eventSeqHead;
            if (scaleStatusEventQueueEntry != null) {
                this.eventSeqHead = scaleStatusEventQueueEntry.entrySeqNext;
                scaleStatusEventQueueEntry.entrySeqNext = null;
                if (this.eventSeqHead == null) {
                    this.eventSeqTail = null;
                } else {
                    this.eventSeqHead.entrySeqPrevious = null;
                }
                --this.numEvents;
                if (scaleStatusEventQueueEntry.eventType == 3) {
                    --this.pnpStatusEvents;
                }
            }
        }
        return scaleStatusEventQueueEntry;
    }
}

