/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import com.zebra.jpos.jniscale.ArgStruct;
import com.zebra.jpos.jniscale.ICSEvents;
import com.zebra.jpos.jniscale.JCoreScale;
import com.zebra.jpos.jniscale.JniXmlElement;
import com.zebra.jpos.service.scale.ScaleData;
import com.zebra.jpos.service.scale.ScaleDirectIOEventQueue;
import com.zebra.jpos.service.scale.ScaleService12Impl;
import com.zebra.jpos.service.scale.ScaleServiceImpl;
import com.zebra.jpos.service.scale.ScaleStatusEventQueue;
import com.zebra.log.scale.JCoreLogger;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jpos.JposException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ScaleWeight
implements ICSEvents {
    public static final int SCALE_NOT_ENABLE = 0;
    public static final int SCALE_NOT_READY = 1;
    public static final int STABLE_WEIGHT_OVER_LIMIT = 2;
    public static final int STABLE_WEIGHT_UNDER_ZERO = 3;
    public static final int NON_STABLE_WEIGHT = 4;
    public static final int STABLE_ZERO_WEIGHT = 5;
    public static final int STABLE_NON_ZERO_WEIGHT = 6;
    static final int STATUS_ATTACH = 0;
    static final int STATUS_DETACH = 1;
    public static final int NCR_LIVE_READ_WEIGHT_TYPE = 1;
    public static final int UPOS_READ_WEIGHT_TYPE = 2;
    static final int NON_EXTENDED_ERROR_CODE_VALUE = 0;
    public static final int WEIGHING_UNIT_KG = 0;
    public static final int WEIGHING_UNIT_POUND = 1;
    private static final int NCR_ESCAL_UNSTABLE = 202;
    private static final int NCR_ESCAL_UNDERZERO = 203;
    private static final int NCR_ESCAL_ZEROWEIGHT = 204;
    private static final int JPOS_ESCAL_OVERWEIGHT = 205;
    private static final int NCR_ESCAL_NOTREADY = 206;
    private static final String HEX_REPRESENTATION = "0x";
    protected static boolean deviceAttached = false;
    public static byte readWeightStatus = 0;
    private int status;
    private int weight;
    private static int unit;
    private static ArgStruct argStruct;
    private ScaleStatusEventQueue scaleStatusEvents;
    private ScaleDirectIOEventQueue scaleDirectIOEvents;
    private Object eventSource;
    int connectStatus = -1;
    List<ScaleData> pnpScaleList = new ArrayList<ScaleData>();
    private String RMDEventScaleId = null;
    private static final int SCALE_UF_SESS_START = 11;
    private static final int SCALE_UF_DL_START = 12;
    private static final int SCALE_UF_DL_PROGRESS = 13;
    private static final int SCALE_UF_DL_END = 14;
    private static final int SCALE_UF_SESS_END = 15;
    private static final int SCALE_UF_STATUS = 16;
    private static final int CONFIG_LOAD_START = 17;
    private static final int CONFIG_LOAD_PROGRESS = 18;
    private static final int CONFIG_LOAD_END = 19;

    public static int getUnit() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)true, (Object[])new Object[]{"unit", unit});
        return unit;
    }

    public int getWeight() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)true, (Object[])new Object[]{"weight", this.weight});
        return this.weight;
    }

    public int getStatus() {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[0]);
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[]{"status", this.status});
        return this.status;
    }

    public ScaleWeight(ScaleStatusEventQueue scaleStatusEventQueue, Object object, ScaleDirectIOEventQueue scaleDirectIOEventQueue) {
        this.scaleStatusEvents = scaleStatusEventQueue;
        this.eventSource = object;
        this.scaleDirectIOEvents = scaleDirectIOEventQueue;
    }

    private ScaleWeight(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length != 6) {
            this.status = 15;
        } else {
            if (!stringArray[0].startsWith(HEX_REPRESENTATION)) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = HEX_REPRESENTATION + stringArray[i];
                }
            }
            this.status = this.getWeightStatus(Byte.decode(stringArray[0]));
            this.weight = this.getWeightValue(stringArray);
            unit = ScaleWeight.getUnit(Byte.decode(stringArray[1]));
        }
    }

    static ScaleWeight createFromAttributeValue(String string) {
        return new ScaleWeight(string);
    }

    public void initScaleEvents() {
        JCoreScale.jcoreScanner.csevents = this;
    }

    public void onDecodeDataEvent(int n, String string) {
        try {
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"Scale onDecodeDataEvent invoked");
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    public void onPnpEvent(int n, String string) {
        this.pnpScaleList.clear();
        try {
            this.extractScaleIdsFromPnpEventXml(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < this.pnpScaleList.size(); ++i) {
            if (this.pnpScaleList.get((int)i).scaleId != ScaleServiceImpl.scaleIndex) continue;
            if (n == 0) {
                deviceAttached = true;
                this.scaleStatusEvents.AddTail(this.eventSource, n);
                break;
            }
            if (n != 1) break;
            deviceAttached = false;
            this.scaleStatusEvents.AddTail(this.eventSource, n);
            break;
        }
    }

    public void onScaleRMDEvent(int n, String string) {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        this.RMDEventScaleId = "";
        try {
            this.extractScaleIdsFromRMDEventXml(string);
        }
        catch (Exception exception) {
            JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{exception});
            return;
        }
        if (ScaleServiceImpl.scaleIndex == Integer.parseInt(this.RMDEventScaleId)) {
            JCoreLogger.Log((char)'+', (String)string2, (boolean)true, (Object[])new Object[]{n, string});
            if (n < 11 || n > 16) {
                if (n >= 17 && n <= 19) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("{ \"Config Load Event\": [");
                    stringBuilder.append(string);
                    stringBuilder.append("]}");
                    this.scaleDirectIOEvents.AddEventToTail(this.eventSource, n, stringBuilder.toString());
                } else {
                    JCoreLogger.Log((char)'-', (String)string2, (boolean)false, (Object[])new Object[]{"Not a valid RMD event"});
                }
            }
        }
    }

    private int getWeightStatus(Byte by) {
        switch (by) {
            case 0: {
                return 15;
            }
            case 1: {
                return 15;
            }
            case 2: {
                return 14;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 13;
            }
            case 6: {
                return 11;
            }
        }
        return 15;
    }

    private int getWeightValue(String[] stringArray) {
        int n = 0;
        n = (int)Long.decode(stringArray[2]).longValue() * 0x1000000;
        n += (int)Long.decode(stringArray[3]).longValue() * 65536;
        n += (int)Long.decode(stringArray[4]).longValue() * 256;
        return n += (int)Long.decode(stringArray[5]).longValue();
    }

    private static int getUnit(Byte by) {
        switch (by) {
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
        }
        return 0;
    }

    public static void readWeightForNCRStatus(int n, int n2) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, n2});
        boolean bl = true;
        Date date = new Date();
        long l = date.getTime();
        if (argStruct == null) {
            argStruct = new ArgStruct();
        }
        while (bl) {
            String[] stringArray;
            argStruct.clearArgStruct();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
            stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID);
            stringBuilder.append(n);
            stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID_E);
            stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGXML);
            stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST);
            stringBuilder.append(ArgStruct.RSM_SCALE_READ_WEIGHT);
            stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST_E);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGXML_E);
            stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
            stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
            ScaleWeight.argStruct.inXml = stringBuilder.toString();
            ScaleWeight.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
            JCoreScale.jcoreScanner.ExecCommand(argStruct);
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("readWeightStatus ExecCommand completed outXml = " + ScaleWeight.argStruct.outXml));
            try {
                Object object;
                block11: {
                    if (!"".equals(ScaleWeight.argStruct.outXml)) {
                        try {
                            object = ScaleWeight.argStruct.outXml.substring(ScaleWeight.argStruct.outXml.indexOf("value") + 6);
                            object = ((String)object).substring(0, ((String)object).indexOf("value") - 2);
                            stringArray = ((String)object).split(" ");
                            if (!((String)object).startsWith(HEX_REPRESENTATION)) {
                                for (int i = 0; i < stringArray.length; ++i) {
                                    stringArray[i] = HEX_REPRESENTATION + stringArray[i];
                                }
                            }
                            unit = ScaleWeight.getUnit(Byte.decode(stringArray[1]));
                            readWeightStatus = Byte.decode(stringArray[0]);
                            bl = false;
                            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeightStatus Valid status recieved");
                        }
                        catch (Exception exception) {
                            if (n2 == -1 || n2 == 0) {
                                bl = false;
                                throw exception;
                            }
                            if (System.currentTimeMillis() - l <= (long)n2) break block11;
                            bl = false;
                            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeightStatus Timeout exceeded");
                            throw exception;
                        }
                    }
                }
                if (System.currentTimeMillis() - l <= (long)n2 || !bl) continue;
                bl = false;
                object = new JposException(112, "Timeout exceeded");
                JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeightStatus Timeout exceeded");
                throw object;
            }
            catch (JposException jposException) {
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
                throw jposException;
            }
            catch (Exception exception) {
                stringArray = new JposException(106, "XML parsing error");
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{stringArray});
                throw stringArray;
            }
        }
    }

    public static void readWeight(int n, int[] nArray, int n2, boolean bl, int n3) throws JposException {
        String string = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string, (boolean)false, (Object[])new Object[]{n, Arrays.toString(nArray), n2, bl, n3});
        boolean bl2 = true;
        Date date = new Date();
        long l = date.getTime();
        if (argStruct == null) {
            argStruct = new ArgStruct();
        }
        while (bl2) {
            argStruct.clearArgStruct();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(JniXmlElement.ELEMENT_INARGS);
            stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID);
            stringBuilder.append(n);
            stringBuilder.append(JniXmlElement.ELEMENT_SCANNER_ID_E);
            stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGXML);
            stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST);
            stringBuilder.append(ArgStruct.RSM_SCALE_READ_WEIGHT);
            stringBuilder.append(JniXmlElement.ELEMENT_ATTR_LIST_E);
            stringBuilder.append(JniXmlElement.ELEMENT_ARGXML_E);
            stringBuilder.append(JniXmlElement.ELEMENT_CMDARGS_E);
            stringBuilder.append(JniXmlElement.ELEMENT_INARGS_E);
            ScaleWeight.argStruct.inXml = stringBuilder.toString();
            ScaleWeight.argStruct.opcode = ArgStruct.RSM_ATTR_GET;
            JCoreScale.jcoreScanner.ExecCommand(argStruct);
            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)("readWeight ExecCommand completed outXml = " + ScaleWeight.argStruct.outXml));
            try {
                block12: {
                    if (!"".equals(ScaleWeight.argStruct.outXml)) {
                        try {
                            ScaleWeight.GetWeightNoDom(ScaleWeight.argStruct.outXml, nArray, bl, n2, n3);
                            bl2 = false;
                            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Valid weight value received");
                        }
                        catch (Exception exception) {
                            if (n2 == -1 || n2 == 0) {
                                bl2 = false;
                                throw exception;
                            }
                            if (System.currentTimeMillis() - l <= (long)n2) break block12;
                            bl2 = false;
                            JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Timeout exceeded");
                            throw exception;
                        }
                    }
                }
                if (System.currentTimeMillis() - l > (long)n2 && bl2) {
                    bl2 = false;
                    JposException jposException = new JposException(112, "Timeout exceeded");
                    JCoreLogger.Log((boolean)true, (int)JCoreLogger.JCL_NOTICE, (int)0, (String)"readWeight Timeout exceeded");
                    throw jposException;
                }
            }
            catch (JposException jposException) {
                throw jposException;
            }
            catch (Exception exception) {
                JposException jposException = new JposException(106, "XML parsing error");
                JCoreLogger.Log((char)'*', (String)string, (boolean)false, (Object[])new Object[]{jposException});
                throw jposException;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(ScaleService12Impl.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
        JCoreLogger.Log((char)'-', (String)string, (boolean)false, (Object[])new Object[0]);
    }

    public static void GetWeightNoDom(String string, int[] nArray, boolean bl, int n, int n2) throws JposException {
        String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
        JCoreLogger.Log((char)'+', (String)string2, (boolean)false, (Object[])new Object[]{string, Arrays.toString(nArray), bl, n, n2});
        nArray[0] = 0;
        String string3 = string.substring(string.indexOf("value") + 6);
        string3 = string3.substring(0, string3.indexOf("value") - 2);
        String[] stringArray = string3.split(" ");
        if (!string3.startsWith(HEX_REPRESENTATION)) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = HEX_REPRESENTATION + stringArray[i];
            }
        }
        nArray[0] = (int)Long.decode(stringArray[2]).longValue() * 0x1000000;
        nArray[0] = nArray[0] + (int)Long.decode(stringArray[3]).longValue() * 65536;
        nArray[0] = nArray[0] + (int)Long.decode(stringArray[4]).longValue() * 256;
        nArray[0] = nArray[0] + (int)Long.decode(stringArray[5]).longValue();
        unit = ScaleWeight.getUnit(Byte.decode(stringArray[1]));
        readWeightStatus = Byte.decode(stringArray[0]);
        if (n2 == 1) {
            ScaleWeight.generateNcrReadWeightException(nArray[0], bl, n);
        } else {
            ScaleWeight.generateUposReadWeightException(nArray[0], bl, n);
        }
        JCoreLogger.Log((char)'-', (String)string2, (boolean)true, (Object[])new Object[]{"weight", Arrays.toString(nArray), "unit", unit});
    }

    private static void generateNcrReadWeightException(int n, boolean bl, int n2) throws JposException {
        if (readWeightStatus == 2) {
            throw new JposException(ScaleServiceImpl.errorCode, 201, "Stable weight is over limit");
        }
        if (readWeightStatus == 3) {
            throw new JposException(ScaleServiceImpl.errorCode, 203, "Stable weight is under zero");
        }
        if (readWeightStatus == 4 || readWeightStatus == 1) {
            if (n2 == 0) {
                throw new JposException(ScaleServiceImpl.errorCode, 202, "Non-stable weight.");
            }
            throw new JposException(112, "Timed out with Non-stable weight.");
        }
        if (readWeightStatus == 5 && n == 0 && !bl && !ScaleServiceImpl.isZeroScale) {
            if (n2 == 0) {
                throw new JposException(ScaleServiceImpl.errorCode, 204, "Zero stable weight");
            }
            throw new JposException(112, "Timed out with zero stable weight");
        }
    }

    private static void generateUposReadWeightException(int n, boolean bl, int n2) throws JposException {
        if (readWeightStatus == 2) {
            throw new JposException(ScaleServiceImpl.errorCode, ScaleServiceImpl.extErrorOverWeight, "Stable weight is over limit");
        }
        if (readWeightStatus == 3) {
            throw new JposException(ScaleServiceImpl.errorCode, ScaleServiceImpl.extErrorUnderZero, "Stable weight is under zero");
        }
        if (readWeightStatus == 4 || readWeightStatus == 1) {
            if (n2 == 0) {
                throw new JposException(ScaleServiceImpl.errorCode, ScaleServiceImpl.extErrorNonStableWeight, "Non-stable weight.");
            }
            throw new JposException(112, "Timed out with Non-stable weight.");
        }
        if (readWeightStatus == 5 && n == 0 && !bl && !ScaleServiceImpl.isZeroScale) {
            if (n2 == 0) {
                throw new JposException(ScaleServiceImpl.errorCode, ScaleServiceImpl.extErrorStableZeroWeight, "Zero stable weight");
            }
            throw new JposException(112, "Timed out with zero stable weight");
        }
    }

    private void extractScaleIdsFromPnpEventXml(String string) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Document document = documentBuilder.parse(byteArrayInputStream);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("scanner");
            NodeList nodeList2 = document.getElementsByTagName("status");
            Element element = (Element)nodeList2.item(0);
            NodeList nodeList3 = element.getChildNodes();
            String string2 = nodeList3.item(0).getNodeValue().trim();
            this.connectStatus = Integer.parseInt(string2);
            int n = nodeList.getLength();
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Object var16_17 = null;
            String string7 = "1";
            for (int i = 0; i < n; ++i) {
                Element element2;
                NodeList nodeList4;
                Element element3;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element4 = (Element)node;
                NodeList nodeList5 = element4.getElementsByTagName("pnp");
                if (nodeList5.getLength() == 0) {
                    string5 = "";
                } else {
                    element3 = (Element)nodeList5.item(0);
                    nodeList4 = element3.getChildNodes();
                    string5 = nodeList4.item(0).getNodeValue().trim();
                }
                if (!string5.isEmpty() && !string5.equals(string7)) continue;
                NodeList nodeList6 = element4.getElementsByTagName("scannerID");
                element3 = (Element)nodeList6.item(0);
                nodeList4 = element3.getChildNodes();
                string4 = nodeList4.item(0).getNodeValue().trim();
                string3 = element4.getAttribute("type");
                NodeList nodeList7 = element4.getElementsByTagName("port");
                if (nodeList7 != null && (element2 = (Element)nodeList7.item(0)) != null) {
                    NodeList nodeList8 = element2.getChildNodes();
                    string6 = nodeList8.item(0).getFirstChild().getNodeValue().trim();
                }
                this.pnpScaleList.add(new ScaleData(Integer.parseInt(string4), string3, string6));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void extractScaleIdsFromRMDEventXml(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Document document = documentBuilder.parse(byteArrayInputStream);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("outArgs");
        int n = nodeList.getLength();
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("scannerID");
                Element element2 = (Element)nodeList2.item(0);
                string2 = element2.getTextContent().trim();
            }
            if (string2 == null) continue;
            this.RMDEventScaleId = string2;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("status:");
        stringBuilder.append(this.status);
        stringBuilder.append("\n");
        stringBuilder.append("weight:");
        stringBuilder.append(this.weight);
        stringBuilder.append("\n");
        stringBuilder.append("unit:");
        stringBuilder.append(unit);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    static {
        argStruct = null;
    }
}

