/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.service.scale;

import java.io.File;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlProcessor {
    private static final String XML_TAG_ATTRIBUTE = "attribute";
    private static final String XML_TAG_ATTRIBUTE_VALUE = "value";
    private static final String XML_TAG_ATTRIBUTE_ID = "id";
    private static final int VALUE_ZERO = 0;

    public static Document parseStringToXmlDocument(String string) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            System.out.println("Failed to parse the XML String into Document object");
            exception.printStackTrace();
        }
        return document;
    }

    public static Document parseXmlFileToXmlDocument(String string) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string));
        }
        catch (Exception exception) {
            System.out.println("Failed to parse the XML file into Document object");
            exception.printStackTrace();
        }
        return document;
    }

    public String getAttributeValue(String string) {
        String string2 = null;
        if (!string.isEmpty()) {
            Document document = XmlProcessor.parseStringToXmlDocument(string);
            try {
                Node node = document.getElementsByTagName(XML_TAG_ATTRIBUTE).item(0);
                if (null != node && 1 == node.getNodeType()) {
                    Element element = (Element)node;
                    string2 = element.getElementsByTagName(XML_TAG_ATTRIBUTE_VALUE).item(0).getFirstChild().getNodeValue();
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to process OUT XML for GetAttribute value command");
                exception.printStackTrace();
            }
        }
        return string2;
    }

    public static String getAttributeValue(String string, int n) {
        String string2 = null;
        if (!string.isEmpty()) {
            Document document = XmlProcessor.parseStringToXmlDocument(string);
            try {
                NodeList nodeList = document.getElementsByTagName(XML_TAG_ATTRIBUTE);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element;
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1 || Integer.parseInt((element = (Element)node).getElementsByTagName(XML_TAG_ATTRIBUTE_ID).item(0).getFirstChild().getNodeValue()) != n) continue;
                    string2 = element.getElementsByTagName(XML_TAG_ATTRIBUTE_VALUE).item(0).getFirstChild().getNodeValue();
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("Exception occured in getAttributeValue");
                exception.printStackTrace();
            }
        }
        return string2;
    }
}

