/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import se.prediktera.breeze.AbstractRuntimeApplication;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.BreezeMultiSimulator;
import se.prediktera.breeze.backend.LicenseManager;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.register.RegInfo;

public abstract class AbstractBreeze
extends AbstractRuntimeApplication {
    public AbstractBreeze(BreezeFrame breezeFrame, Breeze.BreezeErrorHandlingSetup breezeErrorHandlingSetup, DefaultBreezeRuntime defaultBreezeRuntime, LicenseManager licenseManager, WorkspaceManager workspaceManager, boolean bl) {
        super(breezeFrame, breezeErrorHandlingSetup, defaultBreezeRuntime);
        breezeErrorHandlingSetup.onGuiDisplay(breezeFrame);
        try {
            BreezeProperties.getInstance().setRuntimeDefaults();
            if (this.showMainPageDirectly(licenseManager, workspaceManager)) {
                this.initAndLogin(breezeFrame, workspaceManager);
                breezeFrame.showFullScreen(bl);
            } else {
                breezeFrame.showFullScreen(bl);
                if (licenseManager.checkLicense(this.getProduct())) {
                    if (workspaceManager.hasWorkspace()) {
                        this.initAndLogin(breezeFrame, workspaceManager);
                    } else {
                        this.showSetWorkspace(breezeFrame, workspaceManager);
                    }
                } else {
                    breezeFrame.showLicenseError();
                }
            }
        }
        catch (Exception exception) {
            ErrorHandler.logAndReportException((Throwable)exception);
            breezeFrame.showFullScreen(bl);
            breezeFrame.showStartupError(exception);
        }
    }

    private void initAndLogin(BreezeFrame breezeFrame, WorkspaceManager workspaceManager) {
        workspaceManager.getWorkspace().storeWorkspacePath();
        breezeFrame.login();
    }

    public static GraphicsDevice getGraphicsDevice() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
    }

    protected boolean showMainPageDirectly(LicenseManager licenseManager, WorkspaceManager workspaceManager) {
        return licenseManager.checkLicense(this.getProduct()) && workspaceManager.hasWorkspace() && !BreezeUserManager.getInstance().isEnabled();
    }

    protected void showSetWorkspace(final BreezeFrame breezeFrame, final WorkspaceManager workspaceManager) {
        breezeFrame.showSetWorkspaceDialog(new BreezeFrame.WorkspaceDialogCallback(){
            final /* synthetic */ AbstractBreeze this$0;
            {
                this.this$0 = abstractBreeze;
            }

            @Override
            public void workspacePathChosen(String string) {
                try {
                    workspaceManager.switchToNewWorkspace(string);
                    breezeFrame.login();
                }
                catch (WorkspaceManager.WorkspacePermissionException workspacePermissionException) {
                    breezeFrame.showFolderPermissionErrorDialog(() -> this.this$0.showSetWorkspace(breezeFrame, workspaceManager), workspacePermissionException.getFolder(), false);
                }
                catch (Exception exception) {
                    BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.ERROR_OPTION, "Failed to set workspace", "Failed to set workspace to: '" + string + "'.", null, breezeActionEvent -> this.this$0.showSetWorkspace(breezeFrame, workspaceManager));
                }
            }

            @Override
            public void cancelled() {
                this.this$0.shallContinue.set(false);
            }
        });
    }

    protected static void readGeneralCommandLineArgs(Breeze.CommandLineBreezeArgs commandLineBreezeArgs) {
        if (commandLineBreezeArgs.getMultiSimulatorPath() != null) {
            new BreezeMultiSimulator(commandLineBreezeArgs);
        }
        if (commandLineBreezeArgs.isNoAddons()) {
            RegInfo.disableFeature((RegInfo.LicenseFeature)RegInfo.LicenseFeature.Geo);
        } else if (commandLineBreezeArgs.isRecorder() && RegInfo.isApplicationFeature()) {
            RegInfo.disableFeature((RegInfo.LicenseFeature)RegInfo.LicenseFeature.Geo);
            RegInfo.disableFeature((RegInfo.LicenseFeature)RegInfo.LicenseFeature.Application);
            if (!RegInfo.isRecordFeature()) {
                RegInfo.addFeature((RegInfo.LicenseFeature)RegInfo.LicenseFeature.Record);
            }
        }
        if (commandLineBreezeArgs.workspacePath() != null) {
            WorkspaceManager.getInstance().overrideWorkspacePath(new File(commandLineBreezeArgs.workspacePath()));
        }
    }
}

