/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.BreezeProcess;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public abstract class AbstractRuntimeApplication {
    protected AtomicBoolean shallContinue = new AtomicBoolean(true);
    protected AtomicBoolean isClosed = new AtomicBoolean(false);
    protected AtomicBoolean waitingForBreeze = new AtomicBoolean(false);
    protected final BreezeFrame breezeFrame;
    private final Breeze.BreezeErrorHandlingSetup errorHandlingSetup;
    private final DefaultBreezeRuntime breezeRuntimeManager;

    public AbstractRuntimeApplication(BreezeFrame breezeFrame, Breeze.BreezeErrorHandlingSetup breezeErrorHandlingSetup, DefaultBreezeRuntime defaultBreezeRuntime) {
        this.breezeFrame = breezeFrame;
        this.errorHandlingSetup = breezeErrorHandlingSetup;
        this.breezeRuntimeManager = defaultBreezeRuntime;
        TcpManager.getInstance().setBreezeRuntimeManager(defaultBreezeRuntime);
        breezeFrame.addOnCloseCallback(this::shutdown);
        breezeFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AbstractRuntimeApplication.this.stop();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                AbstractRuntimeApplication.this.stop();
            }
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stop();
            this.waitUntilClosed();
        }));
    }

    public void stop() {
        this.shallContinue.set(false);
        if (!this.waitingForBreeze.get()) {
            this.isClosed.set(true);
        }
    }

    private void waitUntilDone() {
        this.waitingForBreeze.set(true);
        ThreadUtil.awaitAndReturn(() -> !this.shallContinue.get(), new Time.MilliSeconds(100L), Time.Forever);
    }

    private void waitUntilClosed() {
        ThreadUtil.awaitAndReturn(this.isClosed::get, new Time.MilliSeconds(10L), new Time.Seconds(10.0));
    }

    private void close() {
        this.isClosed.set(true);
    }

    protected abstract UpdateHelper.Product getProduct();

    public void waitUntilDoneAndClose() {
        this.waitUntilDone();
        this.breezeFrame.exit();
        TcpManager.clearInstance();
        this.close();
    }

    public void checkBreezeRunning() {
        if (BreezeProcess.isBreezeRunning()) {
            Long l = BreezeProcess.getPid().orElse(0L);
            BreezeOptionDialog.showDialog(this.breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.WARNING_OPTION, "Breeze already running", String.format("Breeze is already running (with process id: %d).\n\nClick OK to close this Breeze window", l), null, breezeActionEvent -> BreezeProgressDialog.startProgress(this.breezeFrame, new ProgressAction(this){

                @Override
                public void runAction() {
                    System.exit(1);
                }
            }, "Closing"));
        } else if (BreezeProperties.getInstance().isBreezeRuntimeLocal()) {
            BreezeProcess.setBreezeRunning();
            this.breezeRuntimeManager.startRuntime(BreezeProgressManager.createEmpty());
            if (StringHelper.equals((String)this.breezeRuntimeManager.getSource(), (String)"Breeze") && !this.breezeRuntimeManager.hasCreatedOwnBreezeRuntimeProcess()) {
                BreezeOptionDialog.showDialog(this.breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Breeze Runtime already running", "A already running instance of Breeze Runtime has been detected.\nThis instance is not managed by the current session, this can cause unexpected behavior.\n\nClick OK to restart Breeze Runtime", null, breezeActionEvent -> BreezeProgressDialog.startProgress(this.breezeFrame, new ProgressAction(){

                    @Override
                    public void runAction() {
                        this.setInfoText("Restarting Breeze Runtime");
                        this.setIndeterminate();
                        AbstractRuntimeApplication.this.breezeRuntimeManager.forceCloseAny();
                        AbstractRuntimeApplication.this.breezeRuntimeManager.startRuntime(this.getProgressManager());
                    }
                }, "Restarting"));
            }
        }
    }

    public void shutdown(BreezeProgressManager breezeProgressManager) {
        this.errorHandlingSetup.beforeShutdown();
        UpdateHelper.Product product = this.getProduct();
        if (product.equals((Object)UpdateHelper.Product.Breeze) || this.breezeRuntimeManager.hasCreatedOwnBreezeRuntimeProcess()) {
            breezeProgressManager.setInfoText("Disconnecting hardware");
            try {
                HardwareRegistry.disconnectAndClearInstance(breezeProgressManager);
            }
            catch (Exception exception) {
                Logg.error((String)"Error disconnecting camera(s)", (Throwable)exception);
            }
            breezeProgressManager.setInfoText("Terminating Breeze Runtime");
            try {
                this.breezeRuntimeManager.closeServer();
            }
            catch (Exception exception) {
                Logg.error((String)"Error closing down Breeze Runtime", (Throwable)exception);
            }
        }
    }
}

