/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.Container;
import java.awt.Window;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.prediktera.breeze.AbstractBreeze;
import se.prediktera.breeze.CommandLineArgs;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.LicenseManager;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.performance.TasklistProcess;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.GeneralErrorDialog;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.main.MainPanel;
import se.prediktera.breeze.frontend.main.MainProjectPanel;
import se.prediktera.breeze.frontend.main.play.PlayWorkflowPanel;
import se.prediktera.breeze.frontend.main.play.group.PlayGroupPanel;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.breeze.util.appcenter.AppCenterUploader;
import se.prediktera.breeze.util.automation.GuiComponentFinder;
import se.prediktera.breeze.util.automation.GuiNavigationHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.ErrorUploader;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Evince;

public class Breeze
extends AbstractBreeze {
    public static void main(String[] stringArray) {
        try {
            Breeze.startBreeze(new CommandLineBreezeArgs(stringArray));
            System.exit(0);
        }
        catch (WorkspaceManager.WorkspacePermissionException workspacePermissionException) {
            Logg.error((String)"Workspace cannot be accessed", (Throwable)workspacePermissionException);
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot start Breeze", (Throwable)exception);
            JOptionPane.showMessageDialog(null, "Cause: " + exception.getMessage(), "Cannot start Breeze", 0);
        }
    }

    public static void startBreeze(CommandLineBreezeArgs commandLineBreezeArgs) {
        UpdateHelper.UpdateVersion updateVersion = InitClass.getBreezeVersion();
        Logg.info((String)"Starting Breeze {}", (Object[])new Object[]{updateVersion.format(false)});
        Logg.trace((String)"Current jar folder {}", (Object[])new Object[]{FileHelper.getJarPath()});
        Evince.initForBreeze((boolean)false, (UpdateHelper.Product)UpdateHelper.Product.Breeze, (UpdateHelper.UpdateVersion)updateVersion);
        Breeze.readGeneralCommandLineArgs(commandLineBreezeArgs);
        LicenseManager licenseManager = new LicenseManager();
        DefaultBreezeRuntime defaultBreezeRuntime = new DefaultBreezeRuntime();
        BreezeFrame breezeFrame = new BreezeFrame(WorkspaceManager.getInstance(), defaultBreezeRuntime, Breeze.getGraphicsDevice(), Breeze::createMainPanel, UpdateHelper.Product.Breeze, commandLineBreezeArgs.showCursor(), commandLineBreezeArgs.isTouchScreen(), commandLineBreezeArgs.isDevelopment());
        Breeze breeze = new Breeze(breezeFrame, new BreezeErrorHandlingSetup(), defaultBreezeRuntime, licenseManager, WorkspaceManager.getInstance(), commandLineBreezeArgs.isFullscreen());
        breeze.checkBreezeRunning();
        if (commandLineBreezeArgs.getWorkflow() != null) {
            Workflow workflow = (Workflow)BreezeMasterCache.getInstance().getWorkflowList().byIdOrName(commandLineBreezeArgs.getWorkflow());
            if (workflow == null) {
                throw new RuntimeException("Cannot find workflow with name: " + commandLineBreezeArgs.getWorkflow());
            }
            MainPanel mainPanel = GuiComponentFinder.awaitComponent(breezeFrame, MainPanel.class);
            mainPanel.openPanel(BreezeType.Workflow, workflow, null);
            PlayWorkflowPanel playWorkflowPanel = GuiComponentFinder.awaitComponent(breezeFrame, PlayWorkflowPanel.class);
            GuiNavigationHelper.awaitAndClickButton(playWorkflowPanel, "openEntry");
            PlayGroupPanel playGroupPanel = GuiComponentFinder.awaitComponent(breezeFrame, PlayGroupPanel.class);
            Group group = Breeze.getGroupByName(playGroupPanel.getSelectedEntries(), commandLineBreezeArgs.getGroupName());
            if (group != null) {
                playGroupPanel.selectEntry(group);
            } else {
                GuiNavigationHelper.awaitAndClickButton(playGroupPanel, "addEntry");
                GuiNavigationHelper.awaitAndSetTextFieldValue((Container)breezeFrame, "input", commandLineBreezeArgs.getGroupName());
                GuiNavigationHelper.awaitAndClickDialogOk(breezeFrame);
            }
            GuiNavigationHelper.awaitAndClickButton(playGroupPanel, "next");
            BreezeRecorder breezeRecorder = GuiComponentFinder.awaitComponent(breezeFrame, BreezeRecorder.class);
            GuiNavigationHelper.awaitAndCheckBox(breezeRecorder, "saverawdata", commandLineBreezeArgs.isSaveRaw());
            BreezeButton breezeButton = GuiComponentFinder.awaitButton(breezeRecorder, "next");
            GuiNavigationHelper.awaitEnabledButtonAndClick(breezeButton);
            GuiNavigationHelper.awaitEnabledButtonAndClick(breezeButton);
        }
        breeze.waitUntilDoneAndClose();
    }

    private static Group getGroupByName(List<Object> list, String string) {
        if (string != null) {
            for (Object object : list) {
                Group group = (Group)object;
                if (!group.getName().equalsIgnoreCase(string)) continue;
                return group;
            }
            return null;
        }
        if (!list.isEmpty()) {
            return (Group)list.getFirst();
        }
        return null;
    }

    public Breeze(BreezeFrame breezeFrame, BreezeErrorHandlingSetup breezeErrorHandlingSetup, DefaultBreezeRuntime defaultBreezeRuntime, LicenseManager licenseManager, WorkspaceManager workspaceManager, boolean bl) {
        super(breezeFrame, breezeErrorHandlingSetup, defaultBreezeRuntime, licenseManager, workspaceManager, bl);
        breezeFrame.setRequestExit(this::stop);
    }

    @Override
    protected UpdateHelper.Product getProduct() {
        return UpdateHelper.Product.Breeze;
    }

    public static JPanel createMainPanel(BreezeFrame breezeFrame) {
        if (BreezeFrame.isProjectMainFeature()) {
            return new MainProjectPanel(breezeFrame);
        }
        return new MainPanel(breezeFrame);
    }

    public static void setFrameIcons(Window window) {
        UpdateHelper.Product.Breeze.setFrameIcons(window);
    }

    public static boolean isRunning() {
        if (UpdateHelper.getPlatform().equals((Object)UpdateHelper.Platform.Windows)) {
            return TasklistProcess.getFirstTaskListProcessLine("Breeze.exe") != null;
        }
        return false;
    }

    public static void initForTest() {
        Evince.initForBreeze((boolean)true, (UpdateHelper.Product)UpdateHelper.Product.Breeze, null);
    }

    public static class CommandLineBreezeArgs
    extends CommandLineArgs {
        public CommandLineBreezeArgs(String[] stringArray) {
            super(stringArray);
        }

        public boolean isNoAddons() {
            return this.parser.getFlag("noAddons", false, new String[0]);
        }

        public boolean isRecorder() {
            return this.parser.getFlag("recorder", false, new String[0]);
        }

        public String getWorkflow() {
            return this.parser.getString("workflow", null, new String[0]);
        }

        public String getGroupName() {
            return this.parser.getString("groupName", null, new String[0]);
        }

        public boolean isSaveRaw() {
            return this.parser.getFlag("saveRaw", true, new String[0]);
        }

        public boolean isSavePrediction() {
            return this.parser.getFlag("savePrediction", true, new String[0]);
        }

        public String getMultiSimulatorPath() {
            return this.parser.getString("multiSimulator", null, new String[0]);
        }

        public boolean hasShutter() {
            return this.parser.getFlag("shutter", true, new String[0]);
        }

        public boolean hasWhiteReference() {
            return this.parser.getFlag("whiteReference", true, new String[0]);
        }

        public int getNumberOfCameras() {
            return this.parser.getInt("numberOfCameras", 2, new String[0]);
        }

        public String getMotortype() {
            return this.parser.getString("motorType", "translation", new String[0]);
        }

        public boolean showTray() {
            return this.parser.getFlag("showTray", false, new String[0]);
        }
    }

    public static class BreezeErrorHandlingSetup {
        public BreezeErrorHandlingSetup() {
            ErrorHandler.setProductType((ErrorHandler.ProductType)ErrorHandler.ProductType.BREEZE);
            ErrorHandler.registerUncaughtExceptionHandlingForAllThreadsAndEventQueue();
        }

        public void onGuiDisplay(BreezeFrame breezeFrame) {
            ErrorHandler.setOnUncaughtExceptionCallback((ErrorHandler.OnExceptionCallback)new GeneralErrorDialog(breezeFrame).onExceptionCallback());
        }

        public void beforeShutdown() {
            ErrorHandler.clearUncaughtExceptionCallback();
        }
    }

    @Deprecated
    public static class BreezeErrorHandlingSetupWithReportingAndScreenshot
    extends BreezeErrorHandlingSetup {
        public BreezeErrorHandlingSetupWithReportingAndScreenshot(LicenseManager licenseManager) {
            int n = licenseManager.getLicenseUserId();
            String string = licenseManager.getLicenseUserEmail();
            String string2 = licenseManager.getLicenseUac();
            ErrorHandler.setErrorUploader((ErrorUploader)new AppCenterUploader(n, string, string2));
        }

        @Override
        public void onGuiDisplay(BreezeFrame breezeFrame) {
            ErrorHandler.setScreenshotCallback(breezeFrame::takeScreenShot);
            super.onGuiDisplay(breezeFrame);
        }
    }
}

