/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.io.File;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.prediktera.breeze.AbstractBreeze;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.LicenseManager;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.client.ClientMainPanel;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Evince;

public class BreezeClient
extends AbstractBreeze {
    private static final Logger logger = LoggerFactory.getLogger(Breeze.class);

    public static void main(String[] stringArray) {
        try {
            BreezeClient.startBreezeClient(new CommandLineClientArgs(stringArray));
            System.exit(0);
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot start Breeze", (Throwable)exception);
            JOptionPane.showMessageDialog(null, "Cause: " + exception.getMessage(), "Cannot start Breeze Runtime Client", 0);
        }
    }

    private static void startBreezeClient(CommandLineClientArgs commandLineClientArgs) {
        UpdateHelper.UpdateVersion updateVersion = InitClass.getBreezeVersion();
        logger.info("Starting Breeze Runtime Client " + updateVersion.format(true));
        Evince.initForBreeze((boolean)false, (UpdateHelper.Product)UpdateHelper.Product.BreezeRuntimeClient, (UpdateHelper.UpdateVersion)updateVersion);
        LicenseManager licenseManager = new LicenseManager();
        BreezeClient.readGeneralCommandLineArgs(commandLineClientArgs);
        if (commandLineClientArgs.workspacePath() != null) {
            WorkspaceManager.getInstance().overrideWorkspacePath(new File(commandLineClientArgs.workspacePath()));
        }
        DefaultBreezeRuntime defaultBreezeRuntime = new DefaultBreezeRuntime();
        BreezeFrame.CreatePanelCallback createPanelCallback = breezeFrame -> new ClientMainPanel(breezeFrame, commandLineClientArgs);
        BreezeFrame breezeFrame2 = new BreezeFrame(WorkspaceManager.getInstance(), defaultBreezeRuntime, BreezeClient.getGraphicsDevice(), createPanelCallback, UpdateHelper.Product.BreezeRuntimeClient, commandLineClientArgs.showCursor(), commandLineClientArgs.isTouchScreen(), commandLineClientArgs.isDevelopment());
        defaultBreezeRuntime.setEventServerHost(commandLineClientArgs.getEventServerHost());
        BreezeClient breezeClient = new BreezeClient(breezeFrame2, new Breeze.BreezeErrorHandlingSetup(), defaultBreezeRuntime, licenseManager, WorkspaceManager.getInstance(), commandLineClientArgs.isFullscreen());
        breezeClient.waitUntilDoneAndClose();
    }

    public BreezeClient(BreezeFrame breezeFrame, Breeze.BreezeErrorHandlingSetup breezeErrorHandlingSetup, DefaultBreezeRuntime defaultBreezeRuntime, LicenseManager licenseManager, WorkspaceManager workspaceManager, boolean bl) {
        super(breezeFrame, breezeErrorHandlingSetup, defaultBreezeRuntime, licenseManager, workspaceManager, bl);
        breezeFrame.setRequestExit(this::stop);
    }

    @Override
    protected UpdateHelper.Product getProduct() {
        return UpdateHelper.Product.BreezeRuntimeClient;
    }

    public static class CommandLineClientArgs
    extends Breeze.CommandLineBreezeArgs {
        public CommandLineClientArgs(String[] stringArray) {
            super(stringArray);
        }

        public static CommandLineClientArgs defaults() {
            return new CommandLineClientArgs(new String[0]);
        }

        public String getEventServerHost() {
            String string = null;
            for (String string2 : this.parser.getRawArgs()) {
                if (!string2.startsWith("/e")) continue;
                string = "localhost";
                if (string2.length() <= 2) continue;
                String string3 = string2.substring(3);
                String[] stringArray = string3.split(":");
                string = stringArray[0];
            }
            return string;
        }

        public String getEventServerPort() {
            String string = null;
            for (String string2 : this.parser.getRawArgs()) {
                String string3;
                String[] stringArray;
                if (!string2.startsWith("/e") || string2.length() <= 2 || (stringArray = (string3 = string2.substring(3)).split(":")).length != 2) continue;
                string = stringArray[1];
            }
            return string;
        }

        public boolean isIncludeObjectShape() {
            return this.parser.getFlag("objectShape", true, new String[0]);
        }
    }
}

