/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.io.File;
import java.util.ArrayList;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.FieldOfView;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.common.util.type.MeasurementLength;
import se.prediktera.breeze.common.util.type.Speed;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.runtime.BreezeRuntimeHelper;
import se.prediktera.breeze.hardware.samplemover.tray.CameraIndexSampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMoverSettings;
import se.prediktera.breeze.hardware.samplemover.tray.TrayDialog;

public class BreezeMultiSimulator {
    public BreezeMultiSimulator(Breeze.CommandLineBreezeArgs commandLineBreezeArgs) {
        MultiSimulatorCommandLineArgs multiSimulatorCommandLineArgs = new MultiSimulatorCommandLineArgs(commandLineBreezeArgs.getArgs());
        WorkspaceManager.getInstance().SKIP_STORING_EVINCE_INI_FOR_UNIT_TEST = false;
        WorkspaceManager workspaceManager = WorkspaceManager.setupTestWorkspace(multiSimulatorCommandLineArgs.isDeleteWorkspace(), true);
        SettingsManager.getInstance().setCurrentWorkspace(workspaceManager.getCurrentOrDefaultWorkspaceFile());
        BreezeProperties.getInstance().setNumberOfCameras(commandLineBreezeArgs.getNumberOfCameras());
        if (multiSimulatorCommandLineArgs.isDeleteWorkspace()) {
            BreezeProperties.getInstance().setBreezeRuntimeExeFile(BreezeRuntimeHelper.getBreezeRuntimePathForTest());
            BreezeProperties.getInstance().setShowTerminalWindow(true);
            BreezeProperties.getInstance().setShowWelcomeMessage(false);
            BreezeProperties.getInstance().setWhiteReferenceFrames(new FrameCount(200));
            BreezeProperties.getInstance().setShowNotificationOnMeasurements(true);
            BreezeProperties.getInstance().setVisualisationDirection("horizontal");
        }
        HardwareRegistry.getInstance().switchToCamera(new CameraIndexSampleMover(0));
        CameraIndexSampleMover cameraIndexSampleMover = BreezeMultiSimulator.createImageSetup(commandLineBreezeArgs);
        HardwareRegistry.getInstance().getAvailableCameras(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(cameraIndexSampleMover.toString());
        HardwareRegistry.getInstance().setAvailableCamera(arrayList);
        if (commandLineBreezeArgs.showTray()) {
            TrayDialog.showDialog((CameraIndexSampleMover.CameraIndexSampleMoverDriver)HardwareRegistry.getInstance().getSampleMover());
        }
    }

    public static CameraIndexSampleMover createImageSetup(Breeze.CommandLineBreezeArgs commandLineBreezeArgs) {
        HardwareRegistry hardwareRegistry = HardwareRegistry.getInstance();
        boolean bl = commandLineBreezeArgs.hasWhiteReference();
        boolean bl2 = commandLineBreezeArgs.hasShutter();
        File file = new File(commandLineBreezeArgs.getMultiSimulatorPath());
        RawFileImpl rawFileImpl = new RawFileImpl(new File(file, "whiteFocusDataVNIR.raw"));
        RawHeader rawHeader = rawFileImpl.header();
        MeasurementLength measurementLength = new MeasurementLength(rawHeader.frameCount().value - 100, MeasurementLength.LengthUnit.mm);
        boolean bl3 = rawHeader.pixelWidth().value > 1000;
        CameraIndexSampleMover cameraIndexSampleMover = (CameraIndexSampleMover)hardwareRegistry.getFirstCamera();
        cameraIndexSampleMover.setCameraType(bl3 ? "VNIR-1800" : "VNIR");
        cameraIndexSampleMover.setFrameRate(new FrameRate(400.0f));
        cameraIndexSampleMover.setWarmUpDelay(0);
        cameraIndexSampleMover.setPreCaptureDelay(0);
        cameraIndexSampleMover.setHasWhiteReference(bl);
        cameraIndexSampleMover.setHasShutter(bl2);
        cameraIndexSampleMover.setFramesToAverage(1);
        cameraIndexSampleMover.setBinaryHeader(true);
        cameraIndexSampleMover.setTakeDarkAfterMeasurement(true);
        cameraIndexSampleMover.setFieldOfView(new FieldOfView(rawHeader.pixelWidth().value));
        cameraIndexSampleMover.setRawFile(rawFileImpl.file());
        cameraIndexSampleMover.setDarkRefFile(new File(file, "darkrefVNIR.raw"));
        cameraIndexSampleMover.setMeasureLength(measurementLength);
        cameraIndexSampleMover.setReadoutTime(2);
        if (bl3) {
            cameraIndexSampleMover.setMaxFrameRate(new FrameRate(400.0f));
        }
        HardwareRegistry.getInstance().getCameraList(0).add(cameraIndexSampleMover);
        File file2 = new File(file, "reference_target.txt");
        if (file2.exists()) {
            cameraIndexSampleMover.setWhiteReferenceTargetFile(file2);
        }
        RawFileImpl rawFileImpl2 = new RawFileImpl(new File(file, "whiteFocusDataSWIR.raw"));
        RawHeader rawHeader2 = rawFileImpl2.header();
        MeasurementLength measurementLength2 = new MeasurementLength(rawHeader2.frameCount().value - 100, MeasurementLength.LengthUnit.mm);
        if (BreezeProperties.getInstance().getNumberOfCameras() > 1) {
            hardwareRegistry.switchToCamera(new CameraIndexSampleMover(1), 1);
            CameraIndexSampleMover cameraIndexSampleMover2 = (CameraIndexSampleMover)hardwareRegistry.getSecondCamera();
            cameraIndexSampleMover2.setCameraType(bl3 ? "SWIR-384" : "SWIR");
            cameraIndexSampleMover2.setId(1);
            BreezeProperties.getInstance().setMultiCameraSetting(Camera.MultiCameraMode.SeparateFiles.toSetting());
            BreezeProperties.getInstance().setMultiCameraRealignAlgorithm(Camera.TransformAlgorithm.None);
            cameraIndexSampleMover2.setOffset(30);
            ((CameraIndexSampleMover.CameraIndexSampleMoverSettings)cameraIndexSampleMover2.getSettings()).setOffset(30.0f);
            cameraIndexSampleMover2.setWarmUpDelay(0);
            cameraIndexSampleMover2.setPreCaptureDelay(0);
            cameraIndexSampleMover2.setHasWhiteReference(bl);
            cameraIndexSampleMover2.setHasShutter(bl2);
            cameraIndexSampleMover2.setFramesToAverage(1);
            cameraIndexSampleMover2.setBinaryHeader(true);
            cameraIndexSampleMover2.setTakeDarkAfterMeasurement(true);
            cameraIndexSampleMover2.setFieldOfView(new FieldOfView(rawHeader.pixelWidth().value));
            cameraIndexSampleMover2.setRawFile(rawFileImpl2.file());
            cameraIndexSampleMover2.setDarkRefFile(new File(file, "darkrefSWIR.raw"));
            cameraIndexSampleMover2.setMeasureLength(measurementLength2);
            cameraIndexSampleMover2.setFrameRate(new FrameRate(400.0f / ((float)rawHeader.pixelWidth().value / (float)rawHeader2.pixelWidth().value)));
            cameraIndexSampleMover2.setReadoutTime(200);
            if (bl3) {
                cameraIndexSampleMover2.setMaxFrameRate(new FrameRate(400.0f));
            }
            HardwareRegistry.getInstance().getCameraList(1).add(cameraIndexSampleMover2);
            if (file2.exists()) {
                cameraIndexSampleMover2.setWhiteReferenceTargetFile(file2);
            }
        }
        for (int i = 2; i < BreezeProperties.getInstance().getNumberOfCameras(); ++i) {
            hardwareRegistry.switchToCamera(new CameraIndexSampleMover(i), i);
            CameraIndexSampleMover cameraIndexSampleMover3 = (CameraIndexSampleMover)hardwareRegistry.getCamera(i);
            cameraIndexSampleMover3.setCameraType("SWIR_" + i);
            cameraIndexSampleMover3.setId(i);
            BreezeProperties.getInstance().setMultiCameraSetting(Camera.MultiCameraMode.SeparateFiles.toSetting());
            cameraIndexSampleMover3.setOffset(30);
            ((CameraIndexSampleMover.CameraIndexSampleMoverSettings)cameraIndexSampleMover3.getSettings()).setOffset(30.0f);
            cameraIndexSampleMover3.setWarmUpDelay(0);
            cameraIndexSampleMover3.setPreCaptureDelay(0);
            cameraIndexSampleMover3.setHasWhiteReference(bl);
            cameraIndexSampleMover3.setHasShutter(bl2);
            RawFileImpl rawFileImpl3 = new RawFileImpl(new File(file, "whiteFocusDataSWIR.raw"));
            RawHeader rawHeader3 = rawFileImpl3.header();
            MeasurementLength measurementLength3 = new MeasurementLength(rawHeader2.frameCount().value - 100, MeasurementLength.LengthUnit.mm);
            cameraIndexSampleMover3.setFieldOfView(new FieldOfView(rawHeader.pixelWidth().value));
            cameraIndexSampleMover3.setRawFile(rawFileImpl2.file());
            cameraIndexSampleMover3.setDarkRefFile(new File(file, "darkrefSWIR.raw"));
            cameraIndexSampleMover3.setMeasureLength(measurementLength3);
            cameraIndexSampleMover3.setFrameRate(new FrameRate(400.0f / ((float)rawHeader.pixelWidth().value / (float)rawHeader3.pixelWidth().value)));
            HardwareRegistry.getInstance().getCameraList(i).add(cameraIndexSampleMover3);
            if (!file2.exists()) continue;
            cameraIndexSampleMover3.setWhiteReferenceTargetFile(file2);
        }
        hardwareRegistry.switchToSampleMover(new CameraIndexSampleMover.CameraIndexSampleMoverDriver());
        CameraIndexSampleMover.CameraIndexSampleMoverDriver cameraIndexSampleMoverDriver = (CameraIndexSampleMover.CameraIndexSampleMoverDriver)hardwareRegistry.getSampleMover();
        cameraIndexSampleMoverDriver.setMaxSpeed(new Speed(2000.0f));
        cameraIndexSampleMoverDriver.setMaxLength(new LengthValue(100.0f + Math.max(measurementLength.value, measurementLength2.value)));
        if (commandLineBreezeArgs.getMotortype().equalsIgnoreCase("rotation")) {
            cameraIndexSampleMoverDriver.setType("rotation");
            cameraIndexSampleMoverDriver.setMinLength(new LengthValue(-cameraIndexSampleMoverDriver.maxLength().value));
        } else {
            cameraIndexSampleMoverDriver.setType("translation");
        }
        ((RemoteSampleMoverSettings)cameraIndexSampleMoverDriver.getSettings()).changeMovementSpeed(1000.0f);
        ((RemoteSampleMoverSettings)cameraIndexSampleMoverDriver.getSettings()).changeFocusLocation(65.0f);
        ((RemoteSampleMoverSettings)cameraIndexSampleMoverDriver.getSettings()).changeWhiteRefLocation(10.0f);
        ((RemoteSampleMoverSettings)cameraIndexSampleMoverDriver.getSettings()).changeWhiteRefScanLength(20.0f);
        ((RemoteSampleMoverSettings)cameraIndexSampleMoverDriver.getSettings()).changeScanStartLocation(100.0f);
        cameraIndexSampleMoverDriver.setMaxLength(new LengthValue(((RemoteSampleMoverSettings)cameraIndexSampleMoverDriver.getSettings()).scanStartLocation() + measurementLength.value + 30.0f));
        HardwareRegistry.getInstance().getSampleMoverList().add(cameraIndexSampleMoverDriver);
        return cameraIndexSampleMover;
    }

    public static class MultiSimulatorCommandLineArgs
    extends Breeze.CommandLineBreezeArgs {
        public MultiSimulatorCommandLineArgs(String[] stringArray) {
            super(stringArray);
        }

        public boolean isDeleteWorkspace() {
            return this.parser.getFlag("deleteWorkspace", true, new String[0]);
        }
    }
}

