/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JOptionPane;
import se.prediktera.breeze.BreezeRuntimeFrame;
import se.prediktera.breeze.BreezeRuntimeWithSampleMoverAndCamera;
import se.prediktera.breeze.CommandLineArgs;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.JsonServer;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.hardware.tcp.Command;
import se.prediktera.breeze.hardware.tcp.CommandReply;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.main.Evince;

public class BreezeRuntimeDemo {
    public static void main(String[] stringArray) {
        try {
            BreezeRuntimeDemo.startBreezeRuntimeDemo(new RuntimeDemoCommandLineArgs(stringArray));
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot start Breeze", (Throwable)exception);
            JOptionPane.showMessageDialog(null, "Cause: " + exception.getMessage(), "Cannot start Breeze Runtime Demo", 0);
        }
    }

    private static void startBreezeRuntimeDemo(final RuntimeDemoCommandLineArgs runtimeDemoCommandLineArgs) {
        Evince.initForBreeze((boolean)false, (UpdateHelper.Product)UpdateHelper.Product.BreezeRuntimeDemo, (UpdateHelper.UpdateVersion)InitClass.getBreezeVersion());
        ErrorHandler.registerUncaughtExceptionHandlingForAllThreadsAndEventQueue();
        new BreezeFrame(UpdateHelper.Product.BreezeRuntimeDemo);
        final BreezeRuntimeFrame breezeRuntimeFrame = new BreezeRuntimeFrame(runtimeDemoCommandLineArgs.isEventServer(), runtimeDemoCommandLineArgs.isRelease());
        breezeRuntimeFrame.setVisible(true);
        new BreezeProgressManager(breezeRuntimeFrame){

            @Override
            public Object doWork() {
                this.startBreezeRuntime(runtimeDemoCommandLineArgs);
                return null;
            }

            private void startBreezeRuntime(RuntimeDemoCommandLineArgs runtimeDemoCommandLineArgs2) {
                if (runtimeDemoCommandLineArgs2.isEventServer()) {
                    new JsonServer.EventServer(breezeRuntimeFrame::printEvent);
                } else {
                    TcpManager.getInstance().setListener(breezeRuntimeFrame::printEvent);
                }
                TcpManager.getInstance().setCommandCallback(new TcpManager.CommandCallback(){

                    @Override
                    public void onSend(Command command) {
                        breezeRuntimeFrame.printLine("Command", command.toString());
                    }

                    @Override
                    public void onReply(CommandReply commandReply) {
                        breezeRuntimeFrame.printLine("Reply", commandReply.toString());
                    }
                });
                final BreezeRuntimeWithSampleMoverAndCamera breezeRuntimeWithSampleMoverAndCamera = new BreezeRuntimeWithSampleMoverAndCamera(this, runtimeDemoCommandLineArgs2.getWorkspacePath(), runtimeDemoCommandLineArgs2.isEventServer(), true, runtimeDemoCommandLineArgs2.isRelease());
                if (runtimeDemoCommandLineArgs2.isTestEvent()) {
                    this.startTestEventThread();
                }
                breezeRuntimeFrame.addWindowListener(new WindowAdapter(this){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        breezeRuntimeWithSampleMoverAndCamera.close();
                    }
                });
                breezeRuntimeFrame.setRuntime(breezeRuntimeWithSampleMoverAndCamera, runtimeDemoCommandLineArgs2.isIncludeObjectShape());
                breezeRuntimeFrame.revalidate();
                breezeRuntimeFrame.repaint();
            }

            private void startTestEventThread() {
                Thread thread = new Thread(() -> {
                    int n = 0;
                    while (true) {
                        ThreadUtil.sleep(1000L);
                        TcpManager.getInstance().sendEvent("Message", "Message " + ++n, 0);
                    }
                });
                thread.start();
            }
        }.invokeNow();
    }

    private static class RuntimeDemoCommandLineArgs
    extends CommandLineArgs {
        public RuntimeDemoCommandLineArgs(String[] stringArray) {
            super(stringArray);
        }

        public boolean isTestEvent() {
            return this.parser.getFlag("testEvent", false, new String[0]);
        }

        public boolean isRelease() {
            boolean bl = this.parser.getFlag("release", true, new String[0]);
            if (this.parser.getFlag("debug", false, new String[0])) {
                bl = false;
            }
            return bl;
        }

        public boolean isEventServer() {
            return this.parser.getFlag("eventServer", false, new String[0]);
        }

        public boolean isIncludeObjectShape() {
            return this.parser.getFlag("objectShape", true, new String[0]);
        }

        public File getWorkspacePath() {
            String string = this.parser.getString("workspace", null, new String[0]);
            return string == null ? null : new File(string);
        }
    }
}

