/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import lombok.Generated;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.BreezeRuntimeWithSampleMoverAndCamera;
import se.prediktera.breeze.DiagnosticPanel;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.FrameRate;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.client.select.active.ActiveRuntimeWorkflowPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.capture.RuntimeEvent;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class BreezeRuntimeFrame
extends JFrame {
    private final JTextPane textPane = new JTextPane();
    private final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
    private final JPanel commandPanel = new JPanel(new BorderLayout());
    private BreezeRuntimeWithSampleMoverAndCamera breezeRuntime;
    private final DiagnosticPanel diagnosticPanel;

    public BreezeRuntimeFrame(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Breeze Runtime Demo ");
        stringBuilder.append(InitClass.getBreezeVersion().format(true));
        if (bl) {
            stringBuilder.append(" with Event Server");
        }
        stringBuilder.append(" (").append(bl2 ? "Release" : "Debug").append(")");
        this.setTitle(stringBuilder.toString());
        Breeze.setFrameIcons(this);
        this.setDefaultCloseOperation(3);
        this.commandPanel.add((Component)new JScrollPane(this.textPane), "Center");
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        Container container = this.getContentPane();
        container.setBackground(breezeTheme.getPanelBackground());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setOpaque(false);
        container.add((Component)jTabbedPane, "Center");
        jTabbedPane.setFont(new Font("Tahoma", 0, 14));
        jTabbedPane.addTab("Command and Events", this.commandPanel);
        this.diagnosticPanel = new DiagnosticPanel(null);
        jTabbedPane.addTab("Diagnostics", (Component)((Object)this.diagnosticPanel));
        this.setSize(1024, 930);
        this.setLocationRelativeTo(null);
        this.textPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem("Clear");
                    jMenuItem.addActionListener(actionEvent -> BreezeRuntimeFrame.this.textPane.setText(""));
                    jPopupMenu.add(jMenuItem);
                    jPopupMenu.show(BreezeRuntimeFrame.this.textPane, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.textPane.setBackground(Color.black);
    }

    public void setRuntime(BreezeRuntimeWithSampleMoverAndCamera breezeRuntimeWithSampleMoverAndCamera, boolean bl) {
        this.breezeRuntime = breezeRuntimeWithSampleMoverAndCamera;
        this.commandPanel.add((Component)new RuntimeToolbar(this, breezeRuntimeWithSampleMoverAndCamera, bl), "East");
        this.diagnosticPanel.setRuntimeWorkflow(breezeRuntimeWithSampleMoverAndCamera.getRuntimeWorkflow());
    }

    public void printEvent(RuntimeEvent runtimeEvent) {
        this.printLine(runtimeEvent.getType(), runtimeEvent.getMessageError());
    }

    public void printLine(String string, String string2) {
        String string3 = string2.replace("\\\"", "\"");
        String string4 = "[" + this.sdf.format(new Date()) + "] " + string + ": " + string3 + "\n";
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        AttributeSet attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, this.getColor(string));
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.FontFamily, "Lucida Console");
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.FontSize, 14);
        this.textPane.setCaretPosition(0);
        this.textPane.setCharacterAttributes(attributeSet, false);
        this.textPane.replaceSelection(string4);
        this.textPane.setCaretPosition(0);
    }

    private Color getColor(String string) {
        return switch (string) {
            case "Command" -> Color.lightGray;
            case "Reply" -> Color.pink;
            case "Event" -> Color.cyan;
            case "PredictionObject" -> Color.green;
            case "Error" -> Color.red;
            default -> Color.white;
        };
    }

    @Generated
    public BreezeRuntimeWithSampleMoverAndCamera getBreezeRuntime() {
        return this.breezeRuntime;
    }

    public static class RuntimeToolbar
    extends JScrollPane {
        private final JPanel contentPane = new JPanel(new GridBagLayout());

        public RuntimeToolbar(BreezeRuntimeFrame breezeRuntimeFrame, BreezeRuntimeWithSampleMoverAndCamera breezeRuntimeWithSampleMoverAndCamera, boolean bl) {
            this.setViewportView(this.contentPane);
            this.setHorizontalScrollBarPolicy(31);
            this.setPreferredSize(new Dimension(220, 0));
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.contentPane.setBackground(breezeTheme.getPanelBackground());
            this.contentPane.add((Component)new BreezeLabel("Prediction"), GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(0, 2, 0, 0)));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "LoadWorkflow", () -> this.loadWorkflow(breezeRuntimeWithSampleMoverAndCamera));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Take Dark reference(s)", () -> {
                for (Camera camera : breezeRuntimeWithSampleMoverAndCamera.getConnectedCameras()) {
                    TcpManager.getInstance().takeDarkReference(null, camera.getId());
                }
            });
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Take White reference(s)", () -> {
                for (Camera camera : breezeRuntimeWithSampleMoverAndCamera.getConnectedCameras()) {
                    breezeRuntimeWithSampleMoverAndCamera.takeWhiteReference(TcpManager.ReferenceAction.Take, camera.getId());
                }
            });
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Take White Internal", () -> {
                Object object = JOptionPane.showInputDialog(breezeRuntimeFrame, "Choose action", "Action", 3, null, new Object[]{TcpManager.ReferenceAction.InitialExternal, TcpManager.ReferenceAction.InitialInternal, TcpManager.ReferenceAction.Internal}, (Object)TcpManager.ReferenceAction.InitialExternal);
                if (object != null) {
                    breezeRuntimeWithSampleMoverAndCamera.takeWhiteReference((TcpManager.ReferenceAction)((Object)((Object)object)), 0);
                }
            });
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Start Predict", () -> breezeRuntimeWithSampleMoverAndCamera.startPredict(bl));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Stop Predict", breezeRuntimeWithSampleMoverAndCamera::stopPredict);
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Initialize", () -> TcpManager.getInstance().initialize(5, 2));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "GetStatus", () -> TcpManager.getInstance().getStatus());
            this.contentPane.add((Component)new BreezeLabel("Capture On Predict"), GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(0, 2, 0, 0)));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Start", () -> BreezeOptionDialog.showDialog(breezeRuntimeFrame, BreezeType.Workflow.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Record Runtime data", "", (AbstractBreezeCustomPanel)new ActiveRuntimeWorkflowPanel.CaptureInputPanel(), null, breezeActionEvent -> {
                ActiveRuntimeWorkflowPanel.CaptureInputPanel captureInputPanel = (ActiveRuntimeWorkflowPanel.CaptureInputPanel)breezeActionEvent.getBreezeCustomPanel();
                TcpManager.getInstance().startCaptureOnPredict(captureInputPanel.getFolderName(), BreezeProperties.getInstance().getMaxFrameCount(), captureInputPanel.SaveObject(), captureInputPanel.SavePredictionData(), captureInputPanel.SaveThumbnail());
            }));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Stop", () -> TcpManager.getInstance().stopCaptureOnPredict());
            this.contentPane.add((Component)new BreezeLabel("Camera"), GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(0, 2, 0, 0)));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Open Shutter", () -> TcpManager.getInstance().openShutter(0));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Close Shutter", () -> TcpManager.getInstance().closeShutter(0));
            this.addComboBox(Arrays.asList(new FrameRate(50.0f), new FrameRate(100.0f), new FrameRate(200.0f), new FrameRate(500.0f), new FrameRate(800.0f), new FrameRate(1000.0f), new FrameRate(1500.0f)), object -> breezeRuntimeWithSampleMoverAndCamera.getCamera().setFrameRate((FrameRate)object));
            this.contentPane.add((Component)new BreezeLabel("Capture"), GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(0, 2, 0, 0)));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Start", () -> {
                jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Folder", (Component)breezeRuntimeFrame);
                jopensaveDialog2.setDialogType(1);
                jopensaveDialog2.setFileSelectionMode(1);
                if (jopensaveDialog2.openshow()) {
                    TcpManager.getInstance().startCapture(0, FrameCount.Continuously, jopensaveDialog2.getSelectedFile(), false);
                }
            });
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Stop", () -> TcpManager.getInstance().stopCapture(0));
            this.contentPane.add((Component)new BreezeLabel("Sample mover"), GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(0, 2, 0, 0)));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Scan", () -> new Thread(() -> this.runScan(breezeRuntimeFrame, SampleMover.ScanMode.Measurement)).start());
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Demo", () -> new Thread(() -> this.runScan(breezeRuntimeFrame, SampleMover.ScanMode.DemoByLength)).start());
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Stop", () -> breezeRuntimeWithSampleMoverAndCamera.getSampleMover().stop());
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "White ref", () -> new Thread(() -> breezeRuntimeWithSampleMoverAndCamera.getSampleMover().enterWhiteRefState(null)).start());
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "Sample position", () -> new Thread(() -> breezeRuntimeWithSampleMoverAndCamera.getSampleMover().moveToReturnPosition(null)).start());
            this.contentPane.add((Component)new BreezeLabel("Events"), GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(0, 2, 0, 0)));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "WorkflowLoaded", () -> TcpManager.getInstance().sendEvent("Event", "WorkflowLoaded", 0));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "WorkflowListChanged", () -> TcpManager.getInstance().sendEvent("Event", "WorkflowListChanged", 0));
            this.addButton(breezeRuntimeWithSampleMoverAndCamera, "SendEvent", () -> TcpManager.getInstance().sendEvent("Test", "Test Message", 99));
            this.contentPane.add((Component)new JLabel(""), GridBagHelper.createLast(100, new Insets(0, 0, 0, 0)));
        }

        private void runScan(final BreezeRuntimeFrame breezeRuntimeFrame, SampleMover.ScanMode scanMode) {
            String string = JOptionPane.showInputDialog(breezeRuntimeFrame, "Enter scan length", "100");
            if (string == null) {
                return;
            }
            int n = RtDataFormat.toNumberInt(string);
            SampleMover.ScanEventListener scanEventListener = new SampleMover.ScanEventListener(){

                @Override
                public void onScanStarted() {
                    breezeRuntimeFrame.printLine("Event", "onScanStarted");
                }

                @Override
                public void onScanDemo() {
                    breezeRuntimeFrame.printLine("Event", "onScanDemo");
                }

                @Override
                public void onScanFinished() {
                    breezeRuntimeFrame.printLine("Event", "onScanFinished");
                }
            };
            breezeRuntimeFrame.getBreezeRuntime().getSampleMover().runScan(new LengthValue(n), scanMode, scanEventListener, breezeRuntimeFrame.getBreezeRuntime().getCamera());
        }

        private BreezeButton addButton(BreezeRuntimeWithSampleMoverAndCamera breezeRuntimeWithSampleMoverAndCamera, String string, EntryMainHelper.ClickCallBack clickCallBack) {
            BreezeButton breezeButton = new BreezeButton(string, clickCallBack);
            breezeButton.setPreferredSize(new Dimension(0, 30));
            breezeButton.setTextFont(new Font("Tahoma", 0, 16));
            this.contentPane.add((Component)breezeButton, GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(2, 5, 0, 5)));
            return breezeButton;
        }

        private BreezeComboBox addComboBox(List list, BreezeComboBox.ItemCallback itemCallback) {
            BreezeComboBox breezeComboBox = new BreezeComboBox();
            breezeComboBox.addItems(list);
            breezeComboBox.setCallback(itemCallback);
            this.contentPane.add((Component)breezeComboBox, GridBagHelper.create(this.contentPane.getComponentCount(), new Insets(1, 4, 2, 4)));
            return breezeComboBox;
        }

        private void loadWorkflow(BreezeRuntimeWithSampleMoverAndCamera breezeRuntimeWithSampleMoverAndCamera) {
            List<RuntimeWorkflow> list = TcpManager.getInstance().getWorkflows();
            RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)JOptionPane.showInputDialog(null, "Select workflow", "Load Workflow", 3, null, list.toArray(), null);
            if (runtimeWorkflow != null) {
                breezeRuntimeWithSampleMoverAndCamera.loadWorkflow(runtimeWorkflow);
            }
        }
    }
}

