/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.measure.ReferenceFile;
import se.prediktera.breeze.common.util.measure.SpectralReferenceQuality;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.main.IniManager;

public class BreezeRuntimeWithSampleMoverAndCamera {
    private final HardwareRegistry hardwareRegistry = new HardwareRegistry();
    private final DefaultBreezeRuntime breezeRuntimeManager = new DefaultBreezeRuntime();
    private final SampleMover sampleMover;
    private final Camera camera;
    private final List<Camera> connectedCameras;
    private RuntimeWorkflow runtimeWorkflow;
    private final File workspacePath;

    public BreezeRuntimeWithSampleMoverAndCamera(BreezeProgress breezeProgress, File file, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        TcpManager.getInstance().setBreezeRuntimeManager(this.breezeRuntimeManager);
        if (bl) {
            this.breezeRuntimeManager.setEventServerHost("localhost");
        }
        if (file != null) {
            this.workspacePath = file;
        } else {
            this.workspacePath = SettingsManager.getInstance().getCurrentWorkspace();
            if (this.workspacePath == null) {
                throw new IllegalArgumentException("No workspace directory");
            }
        }
        this.breezeRuntimeManager.setWorkspacePath(file);
        this.breezeRuntimeManager.setUseFileWatcher(bl2);
        if (!this.breezeRuntimeManager.isAnyBreezeRuntimeRunning()) {
            object = BreezeProperties.getInstance();
            this.breezeRuntimeManager.startBreezeRuntime(((BreezeProperties)object).getBreezeRuntimeExeFile(), ((BreezeProperties)object).getCommandPort(), ((BreezeProperties)object).showTerminalWindow(), BreezeProgressManager.createEmpty());
        }
        this.sampleMover = this.hardwareRegistry.getSampleMover();
        if (this.sampleMover != null) {
            this.sampleMover.connect(breezeProgress, null);
        }
        this.camera = TcpManager.getInstance().initializeRemoteCamera(breezeProgress, 0);
        this.connectedCameras = new ArrayList<Camera>();
        this.connectedCameras.add(this.camera);
        if (HardwareRegistry.hasMultiModeCameras()) {
            object = HardwareRegistry.getInstance().getCameras();
            for (int i = 1; i < object.size(); ++i) {
                if (object.get(i) == null) continue;
                this.connectedCameras.add(TcpManager.getInstance().initializeRemoteCamera(breezeProgress, i));
            }
        }
    }

    public RuntimeWorkflow loadWorkflow(RuntimeWorkflow runtimeWorkflow) {
        this.runtimeWorkflow = TcpManager.getInstance().loadWorkflow(runtimeWorkflow, this.camera.getFieldOfView(), this.camera.useReferencesWhenRecordingWithThisCamera());
        return this.runtimeWorkflow;
    }

    public void takeWhiteReference(TcpManager.ReferenceAction referenceAction, int n) {
        if (this.sampleMover != null) {
            this.sampleMover.enterWhiteRefState(null);
        }
        TcpManager.getInstance().takeWhiteReference(null, referenceAction, null, n);
        System.out.println(SpectralReferenceQuality.fromWhiteReference(this.getLastReferences((File)this.workspacePath).white.getFile(), this.camera.getMaxsignal()));
    }

    public void takeDarkReference(int n) {
        TcpManager.getInstance().takeDarkReference(null, n);
        System.out.println(SpectralReferenceQuality.fromDarkReference(this.getLastReferences((File)this.workspacePath).dark.getFile(), this.camera.getMaxsignal()));
    }

    public void startPredict(boolean bl) {
        TcpManager.getInstance().startPredict(FrameCount.Continuously, bl);
        if (this.sampleMover != null) {
            new BreezeThread("BreezeRuntimeDemoScan"){

                @Override
                public void run() {
                    BreezeRuntimeWithSampleMoverAndCamera.this.sampleMover.runScan(BreezeProperties.getInstance().getMeasurementLength().getLength(BreezeRuntimeWithSampleMoverAndCamera.this.camera), SampleMover.ScanMode.DemoByLength, new SampleMover.ScanEventListener(this){

                        @Override
                        public void onScanStarted() {
                        }

                        @Override
                        public void onScanDemo() {
                        }

                        @Override
                        public void onScanFinished() {
                        }
                    }, BreezeRuntimeWithSampleMoverAndCamera.this.camera);
                }
            }.start();
        }
    }

    public void stopPredict() {
        if (this.sampleMover != null) {
            this.sampleMover.stop();
        }
        TcpManager.getInstance().stopPredict(null);
    }

    public boolean isRunning() {
        return this.breezeRuntimeManager.isAnyBreezeRuntimeRunning();
    }

    public void close() {
        if (this.sampleMover != null) {
            this.sampleMover.stop();
        }
        this.breezeRuntimeManager.closeServer();
    }

    private ReferenceFile.ReferenceFiles getLastReferences(File file) {
        IniManager.LoadIniIfNeeded();
        return ReferenceFile.getLastDarkAndWhiteReferencesFromWorkspace(file);
    }

    @Generated
    public SampleMover getSampleMover() {
        return this.sampleMover;
    }

    @Generated
    public Camera getCamera() {
        return this.camera;
    }

    @Generated
    public List<Camera> getConnectedCameras() {
        return this.connectedCameras;
    }

    @Generated
    public RuntimeWorkflow getRuntimeWorkflow() {
        return this.runtimeWorkflow;
    }
}

