/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import se.prediktera.breeze.CommandLineArgsParser;
import se.prediktera.breeze.frontend.BreezeFrame;

public class CommandLineArgs {
    protected final CommandLineArgsParser parser;
    private final String[] args;

    public static CommandLineArgs defaults() {
        return new CommandLineArgs(new String[0]);
    }

    public static CommandLineArgs hardwareDefaults() {
        return new CommandLineArgs(new String[]{"-startserver"});
    }

    public CommandLineArgs(String[] stringArray) {
        this.args = stringArray;
        this.parser = new CommandLineArgsParser(stringArray);
        if (this.parser.getFlag("projectFeature", false, new String[0])) {
            BreezeFrame.projectFeature = true;
        }
    }

    public boolean isFullscreen() {
        return this.parser.getFlag("fullscreen", false, new String[0]);
    }

    public boolean showCursor() {
        boolean bl = this.parser.getFlag("showcursor", true, new String[0]);
        if (this.parser.getFlag("hidecursor", false, new String[0])) {
            bl = false;
        }
        return bl;
    }

    public boolean isTouchScreen() {
        return this.parser.getFlag("touchscreen", false, new String[0]);
    }

    public boolean isDevelopment() {
        return this.parser.getFlag("development", false, new String[0]);
    }

    public String workspacePath() {
        return this.parser.getString("workspace", null, new String[0]);
    }

    public String[] getArgs() {
        return this.args;
    }
}

