/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class CommandLineArgsParser {
    private final Map<String, String> kv = new HashMap<String, String>();
    private final Set<String> on = new HashSet<String>();
    private final Set<String> off = new HashSet<String>();
    private final List<String> positional = new ArrayList<String>();
    private final String[] rawArgs;

    public CommandLineArgsParser(String[] stringArray) {
        this.rawArgs = stringArray == null ? new String[]{} : stringArray;
        this.parseArgs();
    }

    private void parseArgs() {
        for (int i = 0; i < this.rawArgs.length; ++i) {
            String string;
            String string2;
            int n;
            String string3 = this.rawArgs[i];
            if (string3 == null || string3.isBlank()) continue;
            String string4 = string3.trim();
            if (!string4.startsWith("-") && string4.contains("=")) {
                n = string4.indexOf(61);
                String string5 = CommandLineArgsParser.norm(string4.substring(0, n));
                string2 = string4.substring(n + 1);
                this.putKV(string5, string2);
                continue;
            }
            if ("--".equals(string4)) {
                ++i;
                while (i < this.rawArgs.length) {
                    if (this.rawArgs[i] != null && !this.rawArgs[i].isBlank()) {
                        this.positional.add(this.rawArgs[i].trim());
                    }
                    ++i;
                }
                break;
            }
            int n2 = string4.startsWith("--") ? 2 : (n = string4.startsWith("-") ? 1 : 0);
            if (n == 0) {
                this.positional.add(string4);
                continue;
            }
            if ((string4 = string4.substring(n)).startsWith("no-") && string4.length() > 3) {
                String string6 = CommandLineArgsParser.norm(string4.substring(3));
                this.markOff(string6);
                continue;
            }
            int n3 = string4.indexOf(61);
            if (n3 >= 0) {
                string2 = CommandLineArgsParser.norm(string4.substring(0, n3));
                string = string4.substring(n3 + 1);
                this.putKeyForm(string2, string);
                continue;
            }
            string2 = CommandLineArgsParser.norm(string4);
            string = null;
            if (i + 1 < this.rawArgs.length && this.rawArgs[i + 1] != null && !this.rawArgs[i + 1].startsWith("-")) {
                string = this.rawArgs[++i];
            }
            if (string == null) {
                this.markOn(string2);
                continue;
            }
            this.putKeyForm(string2, string);
        }
    }

    private static String norm(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim().toLowerCase(Locale.ROOT);
        if (string2.startsWith("--")) {
            string2 = string2.substring(2);
        } else if (string2.startsWith("-")) {
            string2 = string2.substring(1);
        }
        return string2.replaceAll("[_\\-\\s]", "");
    }

    private void putKV(String string, String string2) {
        this.kv.put(string, string2);
        if (CommandLineArgsParser.isBooleanLiteral(string2)) {
            if (CommandLineArgsParser.toBoolean(string2)) {
                this.markOn(string);
            } else {
                this.markOff(string);
            }
        }
    }

    private void putKeyForm(String string, String string2) {
        this.kv.put(string, string2);
        if (CommandLineArgsParser.isBooleanLiteral(string2)) {
            if (CommandLineArgsParser.toBoolean(string2)) {
                this.markOn(string);
            } else {
                this.markOff(string);
            }
        }
    }

    private static boolean isBooleanLiteral(String string) {
        return string != null && ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string) || "1".equals(string) || "0".equals(string));
    }

    private static boolean toBoolean(String string) {
        return "true".equalsIgnoreCase(string) || "1".equals(string);
    }

    private void markOn(String string) {
        this.on.add(string);
        this.off.remove(string);
    }

    private void markOff(String string) {
        this.off.add(string);
        this.on.remove(string);
    }

    public boolean getFlag(String string, boolean bl, String ... stringArray) {
        for (String string2 : CommandLineArgsParser.keys(string, stringArray)) {
            if (this.on.contains(string2)) {
                return true;
            }
            if (this.off.contains(string2)) {
                return false;
            }
            String string3 = this.kv.get(string2);
            if (string3 == null || !CommandLineArgsParser.isBooleanLiteral(string3)) continue;
            return CommandLineArgsParser.toBoolean(string3);
        }
        return bl;
    }

    public String getString(String string, String string2, String ... stringArray) {
        for (String string3 : CommandLineArgsParser.keys(string, stringArray)) {
            if (!this.kv.containsKey(string3)) continue;
            return this.kv.get(string3);
        }
        return string2;
    }

    public int getInt(String string, int n, String ... stringArray) {
        String string2 = this.getString(string, null, stringArray);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public long getLong(String string, long l, String ... stringArray) {
        String string2 = this.getString(string, null, stringArray);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public double getDouble(String string, double d, String ... stringArray) {
        String string2 = this.getString(string, null, stringArray);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public boolean hasKey(String string, String ... stringArray) {
        for (String string2 : CommandLineArgsParser.keys(string, stringArray)) {
            if (!this.on.contains(string2) && !this.off.contains(string2) && !this.kv.containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    private static List<String> keys(String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(1 + (stringArray == null ? 0 : stringArray.length));
        arrayList.add(CommandLineArgsParser.norm(string));
        if (stringArray != null) {
            for (String string2 : stringArray) {
                arrayList.add(CommandLineArgsParser.norm(string2));
            }
        }
        return arrayList;
    }

    public String[] getRawArgs() {
        return (String[])this.rawArgs.clone();
    }

    public List<String> getPositional() {
        return Collections.unmodifiableList(this.positional);
    }

    public String toString() {
        return "ArgParser{on=" + String.valueOf(this.on) + ", off=" + String.valueOf(this.off) + ", kv=" + String.valueOf(this.kv) + "}";
    }
}

