/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.CommandLineArgsParser;

public class CommandLineArgsParserTest {
    @Test
    public void parsesSimpleFlag() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-fullscreen"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void defaultFlagWhenMissing() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[0]);
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", true, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void parsesNoPrefixedNegation() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"--no-fullscreen"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", true, new String[0]), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void lastOneWinsForFlags() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-fullscreen", "--no-fullscreen", "-fullscreen"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void parsesKeyEqualsValue() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-workspace=C:\\data"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getString("workspace", null, new String[0]), (Matcher)CoreMatchers.equalTo((Object)"C:\\data"));
    }

    @Test
    public void parsesKeyThenValueAsNextToken() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-workspace", "/tmp/ws"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getString("workspace", null, new String[0]), (Matcher)CoreMatchers.equalTo((Object)"/tmp/ws"));
    }

    @Test
    public void doesNotConsumeNextOptionAsValue() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-workspace", "-fullscreen"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getString("workspace", "default", new String[0]), (Matcher)CoreMatchers.equalTo((Object)"default"));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void caseInsensitiveKeys() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-FULLSCREEN", "-WorkSPACE=C:/x"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getString("workspace", null, new String[0]), (Matcher)CoreMatchers.equalTo((Object)"C:/x"));
    }

    @Test
    public void booleanLiteralValuesInfluenceFlags() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-fullscreen=false"});
        CommandLineArgsParser commandLineArgsParser2 = new CommandLineArgsParser(new String[]{"-fullscreen=true"});
        CommandLineArgsParser commandLineArgsParser3 = new CommandLineArgsParser(new String[]{"-fullscreen=0"});
        CommandLineArgsParser commandLineArgsParser4 = new CommandLineArgsParser(new String[]{"-fullscreen=1"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", true, new String[0]), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)commandLineArgsParser2.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser3.getFlag("fullscreen", true, new String[0]), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)commandLineArgsParser4.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void typedGettersReturnDefaultsOnMissingOrInvalid() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-intv=abc", "-longv=xyz", "-doublev=???"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getInt("intv", 42, new String[0]), (Matcher)CoreMatchers.is((Object)42));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getLong("longv", 7L, new String[0]), (Matcher)CoreMatchers.is((Object)7L));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getDouble("doublev", 3.14, new String[0]), (Matcher)CoreMatchers.is((Object)3.14));
    }

    @Test
    public void typedGettersParseValues() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-intv=123", "-longv=9999999999", "-doublev=2.5"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getInt("intv", 0, new String[0]), (Matcher)CoreMatchers.is((Object)123));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getLong("longv", 0L, new String[0]), (Matcher)CoreMatchers.is((Object)9999999999L));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getDouble("doublev", 0.0, new String[0]), (Matcher)CoreMatchers.is((Object)2.5));
    }

    @Test
    public void hasKeyDetectsPresence() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-a", "-b=1", "--no-c"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.hasKey("a", new String[0]), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser.hasKey("b", new String[0]), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser.hasKey("c", new String[0]), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser.hasKey("d", new String[0]), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void aliasesWorkForFlagsAndValues() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-fs", "-wrk=/ws"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, "fs"), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getString("workspace", null, "wrk"), (Matcher)CoreMatchers.equalTo((Object)"/ws"));
    }

    @Test
    public void bareKeyEqualsWithoutDashesIsAccepted() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"path=/data/in"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getString("path", null, new String[0]), (Matcher)CoreMatchers.equalTo((Object)"/data/in"));
    }

    @Test
    public void getRawArgsReturnsCloneAndIsStable() {
        String[] stringArray = new String[]{"-a", "-b=2"};
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(stringArray);
        String[] stringArray2 = commandLineArgsParser.getRawArgs();
        String[] stringArray3 = commandLineArgsParser.getRawArgs();
        MatcherAssert.assertThat((Object)stringArray2, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)stringArray3)));
        MatcherAssert.assertThat((Object)stringArray2.length, (Matcher)CoreMatchers.is((Object)stringArray.length));
        MatcherAssert.assertThat((Object)stringArray2[0], (Matcher)CoreMatchers.equalTo((Object)"-a"));
        stringArray2[0] = "mutated";
        MatcherAssert.assertThat((Object)commandLineArgsParser.getRawArgs()[0], (Matcher)CoreMatchers.equalTo((Object)"-a"));
    }

    @Test
    public void negationBeatsPriorEnable() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-feature", "--no-feature"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("feature", true, new String[0]), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void enableBeatsPriorNegation() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"--no-feature", "-feature"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("feature", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void positionalArgumentsAreCollected_withExplicitFlagValue() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"C:\\data\\measurement.raw", "-fullscreen=true", "anotherfile.raw"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getPositional().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getPositional().get(0), (Matcher)CoreMatchers.equalTo((Object)"C:\\data\\measurement.raw"));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getPositional().get(1), (Matcher)CoreMatchers.equalTo((Object)"anotherfile.raw"));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void positionalArgumentsAfterDoubleDashAreCollected() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-fullscreen", "--", "C:\\data\\a.raw", "b.raw"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("fullscreen", false, new String[0]), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getPositional().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getPositional().get(0), (Matcher)CoreMatchers.equalTo((Object)"C:\\data\\a.raw"));
        MatcherAssert.assertThat((Object)commandLineArgsParser.getPositional().get(1), (Matcher)CoreMatchers.equalTo((Object)"b.raw"));
    }

    @Test
    public void shouldParseNumberOfCamerasWithCamelCaseEquals() {
        for (int i = 0; i <= 10; ++i) {
            MatcherAssert.assertThat((Object)new CommandLineArgsParser(new String[]{"-numberOfCameras=" + i}).getInt("numberOfCameras", 0, new String[0]), (Matcher)CoreMatchers.equalTo((Object)i));
        }
    }

    @Test
    public void shouldParseShowTrayEqualsTrue() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-showTray=true"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("showTray", false, new String[0]), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldParseShowTrayEqualsFalse() {
        CommandLineArgsParser commandLineArgsParser = new CommandLineArgsParser(new String[]{"-showTray=false"});
        MatcherAssert.assertThat((Object)commandLineArgsParser.getFlag("showTray", true, new String[0]), (Matcher)CoreMatchers.equalTo((Object)false));
    }
}

