/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.CommandLineArgs;

public class CommandLineArgsTest {
    @Test
    public void shouldSetFullscreenFromCommandLine() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-fullscreen"});
        MatcherAssert.assertThat((Object)commandLineArgs.isFullscreen(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldDefaultToFullscreenFalse() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[0]);
        MatcherAssert.assertThat((Object)commandLineArgs.isFullscreen(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldDefaultToWorkspacePathNull() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[0]);
        MatcherAssert.assertThat((Object)commandLineArgs.workspacePath(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldSetWorkspacePath() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-workspace=C:\\thework"});
        MatcherAssert.assertThat((Object)commandLineArgs.workspacePath(), (Matcher)CoreMatchers.equalTo((Object)"C:\\thework"));
    }

    @Test
    public void shouldSetSeveralArguments() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-fullscreen", "-development", "-workspace=C:\\thework"});
        MatcherAssert.assertThat((Object)commandLineArgs.isFullscreen(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgs.isDevelopment(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgs.workspacePath(), (Matcher)CoreMatchers.equalTo((Object)"C:\\thework"));
    }

    @Test
    public void shouldDefaultToShowCursorTrue() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[0]);
        MatcherAssert.assertThat((Object)commandLineArgs.showCursor(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldHideCursorWhenHideCursorFlagIsUsed() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-hidecursor"});
        MatcherAssert.assertThat((Object)commandLineArgs.showCursor(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldAllowShowCursorExplicitly() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-showcursor"});
        MatcherAssert.assertThat((Object)commandLineArgs.showCursor(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldSetTouchscreenTrue() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-touchscreen"});
        MatcherAssert.assertThat((Object)commandLineArgs.isTouchScreen(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldDefaultToTouchscreenFalse() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[0]);
        MatcherAssert.assertThat((Object)commandLineArgs.isTouchScreen(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldSetDevelopmentTrue() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-development"});
        MatcherAssert.assertThat((Object)commandLineArgs.isDevelopment(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void shouldDefaultToDevelopmentFalse() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[0]);
        MatcherAssert.assertThat((Object)commandLineArgs.isDevelopment(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void shouldSupportWorkspaceWithEqualsAndSpace() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-workspace", "C:\\thework"});
        MatcherAssert.assertThat((Object)commandLineArgs.workspacePath(), (Matcher)CoreMatchers.equalTo((Object)"C:\\thework"));
    }

    @Test
    public void shouldBeCaseInsensitive() {
        CommandLineArgs commandLineArgs = new CommandLineArgs(new String[]{"-FULLSCREEN", "-WorkSpace=C:\\abc"});
        MatcherAssert.assertThat((Object)commandLineArgs.isFullscreen(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)commandLineArgs.workspacePath(), (Matcher)CoreMatchers.equalTo((Object)"C:\\abc"));
    }
}

