/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.LogFilePanel;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.FileInputField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.DeeTeeCamera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.util.performance.DiagnosticHelper;
import se.prediktera.map.common.progress.ProgressManager;

public class DiagnosticPanel
extends AbstractViewPanel {
    private File diagnosticFile;
    private RuntimeWorkflow workflow;
    private final BreezeLabelField statusField;
    private final LogFilePanel logFilePanel;

    public DiagnosticPanel(final EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        DeeTeeCamera deeTeeCamera;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(breezeTheme.getPanelBackground());
        this.add(jPanel, "Center");
        jPanel.add((Component)new BreezeLabel("Diagnostics"), GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(0, 0, 0, 12)));
        final FileInputField.FolderInputField folderInputField = new FileInputField.FolderInputField((Component)((Object)this), "Folder", BreezeProperties.getInstance().getDiagnosticPath(), null);
        folderInputField.getInputField().setLabelWidth(80);
        jPanel.add((Component)folderInputField, GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(12, 0, 0, 12)));
        this.statusField = new BreezeLabelField("Status", 80, "None", -1);
        jPanel.add((Component)this.statusField, GridBagHelper.createWithWeigthX1(jPanel.getComponentCount(), new Insets(6, 0, 0, 12)));
        CollapsePanel collapsePanel = new CollapsePanel("Log file");
        collapsePanel.setCollapsed(false);
        collapsePanel.setExpandEnabled(false);
        this.logFilePanel = new LogFilePanel(entryMainPanel);
        collapsePanel.addPanel((JComponent)this.logFilePanel, GridBagHelper.createLast(jPanel.getComponentCount(), new Insets(12, 0, 0, 12)));
        GridBagConstraints gridBagConstraints = GridBagHelper.createLast(jPanel.getComponentCount(), new Insets(12, 0, 0, 12));
        jPanel.add((Component)collapsePanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        jPanel2.setPreferredSize(new Dimension(200, 0));
        this.add(jPanel2, "East");
        final BreezeDescriptionButton breezeDescriptionButton = new BreezeDescriptionButton();
        breezeDescriptionButton.setDescription("Start diagnostics");
        breezeDescriptionButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ DiagnosticPanel this$0;
            {
                this.this$0 = diagnosticPanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!breezeDescriptionButton.isToggled()) {
                    File file = folderInputField.getFile();
                    BreezeProperties.getInstance().setDiagnosticPath(file);
                    this.this$0.diagnosticFile = DiagnosticHelper.formatFile(file, this.getDiagnosticName());
                    TcpManager.getInstance().startDiagnostic(this.this$0.diagnosticFile);
                    this.this$0.statusField.setValue("Started");
                    folderInputField.getInputField().setEnabled(false);
                    this.setToggled(true);
                } else if (this.this$0.diagnosticFile != null) {
                    if (this.this$0.getFrame() != null) {
                        BreezeProgressDialog.startProgress(this.this$0.getFrame(), new ProgressAction(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            @Override
                            public void runAction() throws Exception {
                                this.this$1.saveDiagnostic(this.getProgressManager(), folderInputField);
                            }
                        }, "Diagnostic");
                    } else {
                        new BreezeProgressManager(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            @Override
                            public Object doWork() {
                                this.this$1.saveDiagnostic(this, folderInputField);
                                return null;
                            }
                        }.invokeNow();
                    }
                } else {
                    this.setToggled(false);
                }
            }

            private void setToggled(boolean bl) {
                breezeDescriptionButton.setToggled(bl);
                breezeDescriptionButton.setDescription((bl ? "Stop" : "Start") + " diagnostics");
            }

            private String getDiagnosticName() {
                if (this.this$0.workflow != null) {
                    return this.this$0.workflow.getName();
                }
                return "Workflow";
            }

            private void saveDiagnostic(ProgressManager progressManager, FileInputField.FolderInputField folderInputField2) {
                progressManager.setInfoText("Saving diagnostics to file");
                TcpManager.getInstance().stopDiagnostic();
                progressManager.setInfoText("Creating diagnostic summary visualisations");
                DiagnosticHelper.createEvincePlots(progressManager, this.this$0.diagnosticFile);
                this.this$0.statusField.setValue("Saved: " + this.this$0.diagnosticFile.getAbsolutePath());
                folderInputField2.getInputField().setEnabled(true);
                this.setToggled(false);
                FileHelper.openExplorerOnPath(this.this$0.diagnosticFile.getParentFile(), false);
            }
        });
        jPanel2.add((Component)breezeDescriptionButton, GridBagHelper.createWithWeigthX1(jPanel2.getComponentCount(), new Insets(12, 12, 12, 12)));
        Camera camera = HardwareRegistry.getInstance().getActiveCamera();
        if (camera instanceof DeeTeeCamera && ((DeeTeeCamera.DeeTeeSettings)(deeTeeCamera = (DeeTeeCamera)camera).getSettings()).isDynCalibration()) {
            BreezeDescriptionButton breezeDescriptionButton2 = new BreezeDescriptionButton();
            breezeDescriptionButton2.setDescription("Save Dyn.Calibration");
            breezeDescriptionButton2.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    String string = TcpManager.getInstance().getCameraProperty(deeTeeCamera, "SaveDynamicCalibration");
                    if (string.length() > 0) {
                        BreezeOptionDialog.showDialog(entryMainPanel.getFrame(), entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Information", "Dynamic calibration has been saved\n\nFolder: Workspace/Data/Runtime/References/WhiteDynCal\nFile: " + string + ".raw");
                    } else {
                        BreezeOptionDialog.showDialog(entryMainPanel.getFrame(), entryMainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Cannot save", "No dynamic calibration found");
                    }
                }
            });
            jPanel2.add((Component)breezeDescriptionButton2, GridBagHelper.createWithWeigthX1(jPanel2.getComponentCount(), new Insets(12, 12, 12, 12)));
        }
        jPanel2.add((Component)new JLabel(), GridBagHelper.createLast(jPanel2.getComponentCount(), new Insets(0, 0, 0, 0)));
    }

    @Override
    public String getType() {
        return "DiagnosticPanel";
    }

    public void setRuntimeWorkflow(RuntimeWorkflow runtimeWorkflow) {
        this.workflow = runtimeWorkflow;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.workflow = (RuntimeWorkflow)object;
        this.logFilePanel.start();
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        this.logFilePanel.stop();
        return WizardStep.LeaveResult.Ok;
    }
}

