/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import se.prediktera.breeze.hardware.camera.capture.RuntimeEvent;

public class JsonServer
implements Closeable {
    private final Thread thread = new Thread(() -> {
        try {
            this.serverSocket = new ServerSocket(n);
            try {
                while (this.running) {
                    try {
                        this.clientSocket = this.serverSocket.accept();
                        this.connected = true;
                        this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
                        String string = null;
                        while ((string = this.in.readLine()) != null) {
                            this.onJson(new JSONObject(string));
                        }
                    }
                    catch (SocketException socketException) {
                        this.connected = false;
                    }
                }
            }
            finally {
                this.serverSocket.close();
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            this.connected = false;
        }
    });
    private ServerSocket serverSocket;
    private Socket clientSocket;
    private BufferedReader in;
    private boolean connected = false;
    private boolean running = true;
    private static final boolean debug = false;

    public JsonServer(int n) {
        this.thread.start();
    }

    protected void onJson(JSONObject jSONObject) {
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() {
        this.running = false;
        if (this.clientSocket != null) {
            try {
                this.clientSocket.shutdownInput();
                this.clientSocket.shutdownOutput();
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.thread.interrupt();
    }

    public static class EventServer
    extends JsonServer {
        private final List<RuntimeEvent> eventList = new ArrayList<RuntimeEvent>();
        private final OnEventCallback callback;

        public EventServer() {
            this(null);
        }

        public EventServer(OnEventCallback onEventCallback) {
            super(4000);
            this.callback = onEventCallback;
        }

        @Override
        protected void onJson(JSONObject jSONObject) {
            RuntimeEvent runtimeEvent = new RuntimeEvent(jSONObject);
            if (this.callback != null) {
                this.callback.onEvent(runtimeEvent);
            }
            this.eventList.add(runtimeEvent);
        }

        public void awaitEventType(String string) {
            this.awaitEvent(string, null);
        }

        public void awaitEvent(String string, String string2) {
            RuntimeEvent.awaitEvent(this.eventList, string, string2);
        }

        public RuntimeEvent getLastEvent() {
            if (this.eventList.isEmpty()) {
                return null;
            }
            return this.eventList.get(this.eventList.size() - 1);
        }

        public static interface OnEventCallback {
            public void onEvent(RuntimeEvent var1);
        }
    }
}

