/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class LogFilePanel
extends JPanel {
    private final JTextPane textPane = new JTextPane();
    private final LogFileReader logFileReader;

    public LogFilePanel(Component component) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)new BreezeScrollPane(this.textPane), "Center");
        this.textPane.setEditable(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.textPane.setForeground(breezeTheme.getLabelForeground());
        this.textPane.setCaretColor(breezeTheme.getLabelForeground());
        this.textPane.setBackground(breezeTheme.getSettingPanelBackground());
        this.logFileReader = new LogFileReader(string -> {
            this.textPane.setText(string);
            try {
                this.textPane.setCaretPosition(this.textPane.getDocument().getLength());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)EntryMainHelper.createButton("Save", "save", () -> {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Save log file", component);
            jopensaveDialog2.addExtension("log", "Log file");
            jopensaveDialog2.setFileName("BreezeRuntime.log");
            if (jopensaveDialog2.saveshow()) {
                this.logFileReader.save(jopensaveDialog2.getSelectedFile());
            }
        }), GridBagHelper.create(0, new Insets(0, 6, 0, 0)));
        jPanel.add((Component)EntryMainHelper.createButton("Refresh", "applychanges", () -> this.logFileReader.refresh()), GridBagHelper.create(1, new Insets(6, 6, 0, 0)));
        GridBagConstraints gridBagConstraints = GridBagHelper.create(100, new Insets(0, 0, 0, 0));
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel(""), gridBagConstraints);
        this.add((Component)jPanel, "East");
    }

    public void start() {
        this.logFileReader.start();
    }

    public void stop() {
        this.logFileReader.stop();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Breeze Runtime Log file");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(new LogFilePanel(jFrame));
        jFrame.setSize(800, 800);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    private static class LogFileReader {
        private final LogFileCallback callback;
        private final File logFile;
        private long length;
        private String content;

        public LogFileReader(LogFileCallback logFileCallback) {
            this.callback = logFileCallback;
            this.logFile = WorkspaceManager.getBreezeRuntimeLogFile();
        }

        public void save(File file) {
            try (PrintWriter printWriter = new PrintWriter(file);){
                printWriter.println(this.content);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        public void start() {
        }

        private void refresh() {
            if (this.length != this.logFile.length()) {
                try {
                    this.length = this.logFile.length();
                    this.content = new String(Files.readAllBytes(this.logFile.toPath()));
                    this.callback.onChange(this.content);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }

        public void stop() {
        }

        public static interface LogFileCallback {
            public void onChange(String var1);
        }
    }
}

