/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.AbstractRuntimeApplication;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.CommandLineArgs;
import se.prediktera.breeze.SpectralViewerHelper;
import se.prediktera.breeze.WindowsFileExtensionAssociations;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.SaturationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PcaStreamQuantificationDescriptor;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.average.AveragePlotPanel;
import se.prediktera.breeze.common.util.average.AverageSpectrumViewPanel;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.measure.SpectralReferenceHelper;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.raw.RawFileImpl;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.SamplePath;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.EvinceHelper;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;
import se.prediktera.breeze.frontend.main.AbstractMainPanel;
import se.prediktera.breeze.frontend.main.play.GraphOverviewPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceCachePanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.frontend.main.settings.measurement.SpectralReferences;
import se.prediktera.breeze.hardware.camera.component.SpectralRoiInputField;
import se.prediktera.breeze.hardware.runtime.DefaultBreezeRuntime;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.test.stubs.MeasurementWithoutIO;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.breeze.util.raw.RawHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.dataimport.image.hdr.HdrImageImportInfo;
import se.prediktera.map.dataimport.image.hdr.HySpexImageImportInfo;

public class SpectralViewer
extends AbstractRuntimeApplication {
    private static boolean showAnalysis = false;

    public SpectralViewer(CommandLineSpectralViewerArgs commandLineSpectralViewerArgs) {
        super(new SpectralViewerFrame(SpectralViewer.copyFolder(commandLineSpectralViewerArgs.getFile(), commandLineSpectralViewerArgs.copyFolder())), new Breeze.BreezeErrorHandlingSetup(), new DefaultBreezeRuntime());
        Breeze.setFrameIcons(this.breezeFrame);
        this.breezeFrame.showFullScreen(commandLineSpectralViewerArgs.isFullscreen());
        this.waitUntilDoneAndClose();
    }

    @Override
    protected UpdateHelper.Product getProduct() {
        return UpdateHelper.Product.Breeze;
    }

    public static Measurement getMeasurement(BreezeProgressManager breezeProgressManager, File file) {
        File file2 = file.getParentFile();
        Measurement measurement = SpectralViewer.getOrCreateMeasurement(breezeProgressManager, file, file2);
        File file3 = measurement.getThumbnailFile();
        if (!file3.exists()) {
            measurement.updateThumbnail(breezeProgressManager);
        }
        return measurement;
    }

    private static Measurement getOrCreateMeasurement(BreezeProgressManager breezeProgressManager, File file, File file2) {
        File file3 = file2.getParentFile();
        File file4 = file3.getParentFile();
        if (SpectralViewer.isWorkflow(file4)) {
            Workflow workflow = new Workflow(file4);
            Group group = new Group(file3, workflow);
            return new Measurement(file2, group);
        }
        return SpectralViewer.createMeasurementOutsideWorkspace(breezeProgressManager, file, file2);
    }

    private static Measurement createMeasurementOutsideWorkspace(BreezeProgressManager breezeProgressManager, File file, final File file2) {
        final String string = FileHelper.getFileName(file);
        final String string2 = FileHelper.getExtension((File)file);
        final File file3 = new File(file2, string + "_workflow.xml");
        final Workflow workflow = file3.exists() ? new Workflow(file2){

            @Override
            public File getXml() {
                return file3;
            }
        } : new Workflow("Workflow", file2){

            @Override
            public File getXml() {
                return file3;
            }
        };
        final RawFileImpl rawFileImpl = new RawFileImpl(file);
        RawHeader rawHeader = rawFileImpl.header();
        final MaxSignal maxSignal = new MaxSignal(rawFileImpl, rawHeader.rgbBands());
        final SpectralReference.DarkReference darkReference = SpectralViewer.getDarkReference(rawFileImpl);
        final SpectralReference.WhiteReference whiteReference = SpectralViewer.getWhiteReference(rawFileImpl);
        MeasurementWithoutIO measurementWithoutIO = new MeasurementWithoutIO(){

            @Override
            public File getFolder() {
                return file2;
            }

            @Override
            public String getName() {
                return string;
            }

            @Override
            public String getBaseName() {
                return string;
            }

            @Override
            public String getBaseExt() {
                return string2;
            }

            @Override
            public Workflow getWorkflow() {
                return workflow;
            }

            @Override
            public RawFile rawFile() {
                return rawFileImpl;
            }

            @Override
            public SpectralReference.DarkReference darkReference() {
                return darkReference;
            }

            @Override
            public SpectralReference.WhiteReference whiteReference() {
                return whiteReference;
            }

            @Override
            public MaxSignal getMaxSignal() {
                return maxSignal;
            }

            @Override
            public File getThumbnailFile() {
                File file = new File(file2, string + ".png");
                if (file.exists()) {
                    return file;
                }
                return new File(file2, string + ".jpg");
            }
        };
        int n = rawHeader.pixelWidth().value;
        int n2 = rawHeader.frameCount().value;
        RootSample rootSample = new RootSample();
        int[][] nArray = new int[4][2];
        int n3 = n;
        nArray[2][0] = n3;
        nArray[1][0] = n3;
        int n4 = n2;
        nArray[3][1] = n4;
        nArray[2][1] = n4;
        rootSample.getSamplePath().setSelectionPaths(List.of(new SamplePath.SelectionPath(null, nArray)));
        measurementWithoutIO.replaceRootSample(rootSample);
        return measurementWithoutIO;
    }

    private static SpectralReference.DarkReference getDarkReference(RawFile rawFile) {
        File file = SpectralReferenceHelper.getDarkReferenceFile(rawFile);
        if (!FileHelper.exists(file)) {
            if (HySpexHeader.isHySpexFile(rawFile.file())) {
                HySpexHeader hySpexHeader = new HySpexHeader(rawFile.file());
                RawHeader rawHeader = new RawHeader(hySpexHeader);
                double[][] dArray = hySpexHeader.getBackgrounds();
                if (dArray != null && dArray.length > 0) {
                    return new SpectralReference.DarkReference(hySpexHeader.createFrames(dArray), rawHeader){

                        @Override
                        public boolean exits() {
                            return true;
                        }
                    };
                }
            }
            return new SpectralReference.EmptyDarkReference();
        }
        return new SpectralReference.DarkReference(file);
    }

    private static SpectralReference.WhiteReference getWhiteReference(RawFileImpl rawFileImpl) {
        File file = SpectralReferenceHelper.getWhiteReferenceFile(rawFileImpl);
        return FileHelper.exists(file) ? new SpectralReference.WhiteReference(file) : new SpectralReference.EmptyWhiteReference();
    }

    private static boolean isWorkflow(File file) {
        return new File(file, "workflow.xml").exists();
    }

    public static File copyFolder(File file, boolean bl) {
        if (bl && FileHelper.exists(file)) {
            try {
                File file2 = file.getParentFile();
                File file3 = new File(file2.getParentFile(), file2.getName() + "_copy");
                if (file3.exists()) {
                    FileUtils.deleteDirectory((File)file3);
                }
                FileHelper.copyFolder(BreezeProgressImpl.createEmpty(), file2, file3);
                return new File(file3, file.getName());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return file;
    }

    public static void main(String[] stringArray) {
        CommandLineSpectralViewerArgs commandLineSpectralViewerArgs = new CommandLineSpectralViewerArgs(stringArray);
        showAnalysis = commandLineSpectralViewerArgs.analysis();
        Breeze.initForTest();
        new SpectralViewer(commandLineSpectralViewerArgs);
    }

    public static class SpectralViewerFrame
    extends BreezeFrame {
        private final EntryMainPanel mainPanel;
        private final AverageSpectrumViewPanel viewPanel;
        private Measurement measurement;
        private File file;
        private MenuItem radianceMenuItem;
        private MenuItem reflectanceMenuItem;
        private MenuItem absorbanceMenuItem;
        private AveragePlotPanel scatterPlot;
        private static final String defaultTitle = "Prediktera Spectral Viewer";

        public SpectralViewerFrame(final File file) {
            super(UpdateHelper.Product.Breeze);
            this.setDefaultCloseOperation(3);
            this.setJMenuBar(this.createMenuBar());
            this.mainPanel = new EntryMainPanel(this, this, this.getPageType(), "", false, false){
                final /* synthetic */ SpectralViewerFrame this$0;
                {
                    this.this$0 = spectralViewerFrame;
                    super(breezeFrame, breezeType, string, bl, bl2);
                }

                @Override
                public void setDirty(boolean bl) {
                    if (bl && this.this$0.measurement != null) {
                        this.this$0.measurement.getThumbnailFile().delete();
                        this.this$0.openFile(file);
                    }
                }
            };
            ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
            this.viewPanel = new AverageSpectrumViewPanel(this.mainPanel, null, "");
            if (showAnalysis) {
                this.scatterPlot = this.viewPanel.getViewer().addPlot(AveragePlotPanel.AbstractPlot.PlotTypes.Scatter, "");
            }
            arrayList.add(new ViewClass("Overview", this.viewPanel));
            this.setMainPanel(this.mainPanel);
            this.addMainPage();
            this.mainPanel.middlePanel.setVisible(false);
            this.mainPanel.topRightPanel.setVisible(false);
            this.mainPanel.setLists(arrayList, new ArrayList(), "Study_big");
            this.setSize(1000, 800);
            this.setLocationRelativeTo(null);
            this.viewPanel.editingEnabled = false;
            this.updateTitle();
            if (file != null && file.exists()) {
                this.openFile(file);
            } else {
                SwingUtilities.invokeLater(this::showOpenDialog);
            }
            this.updateTheme();
        }

        private void updateTitle() {
            StringBuilder stringBuilder = new StringBuilder(defaultTitle);
            if (!this.isEditMode()) {
                stringBuilder.append(" [Read-only mode]");
            }
            if (this.file != null) {
                stringBuilder.append(" (");
                stringBuilder.append(this.file.getAbsolutePath());
                stringBuilder.append(")");
            }
            this.setTitle(stringBuilder.toString());
        }

        public AverageSpectrumViewPanel getViewPanel() {
            return this.viewPanel;
        }

        private boolean isEditMode() {
            return this.viewPanel.editingEnabled;
        }

        public void openFile(final File file) {
            this.file = file;
            BreezeProgressDialog.startProgressWithCancel(this, new ProgressAction(this){
                final /* synthetic */ SpectralViewerFrame this$0;
                {
                    this.this$0 = spectralViewerFrame;
                }

                @Override
                public void runAction() {
                    this.this$0.openMeasurement(SpectralViewer.getMeasurement(this.getProgressManager(), file));
                    this.this$0.updateTitle();
                }
            }, "Loading file");
        }

        public void openMeasurement(Measurement measurement) {
            this.measurement = measurement;
            this.radianceMenuItem.setEnabled(HySpexHelper.isHySpexFile(measurement.rawFile().file()));
            RtFramePredictor.ReferenceType referenceType = measurement.getReferenceType();
            this.reflectanceMenuItem.setEnabled(referenceType.both());
            this.absorbanceMenuItem.setEnabled(referenceType.both());
            this.viewPanel.showEntry(measurement, null);
        }

        private JMenuBar createMenuBar() {
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenu.add(new MenuItem("Open...", actionEvent -> this.showOpenDialog()));
            if (SystemUtils.IS_OS_WINDOWS) {
                jMenu.add(new MenuItem("Associate with file extensions...", actionEvent -> this.associateExtensions()));
            }
            jMenu.addSeparator();
            jMenu.add(new MenuItem("Exit", actionEvent -> {
                this.exit();
                System.exit(0);
            }));
            JMenu jMenu2 = new JMenu("Edit");
            CheckBoxMenuItem checkBoxMenuItem = new CheckBoxMenuItem("Enable editing of the original file", false, (jMenuItem, bl) -> {
                this.viewPanel.editingEnabled = bl;
                SpectralViewerHelper.enableMenuItems(jMenu2, this.viewPanel.editingEnabled, jMenuItem);
                this.updateTitle();
            });
            jMenu2.add(checkBoxMenuItem);
            jMenu2.add(new MenuItem("Set RGB bands", actionEvent -> this.viewPanel.setRgbBands()));
            jMenu2.addSeparator();
            jMenu2.add(new MenuItem("Import references", actionEvent -> SpectralPanel.importReference(this.mainPanel, List.of(this.measurement), this.file.getParentFile())));
            jMenu2.add(new MenuItem("Extract white reference", actionEvent -> MeasurementPopup.extractWhiteReference(this, this.mainPanel, this.measurement)));
            jMenu2.addSeparator();
            jMenu2.add(new MenuItem("Crop", actionEvent -> MeasurementPopup.cropImage(this, this.mainPanel, string -> {}, this.measurement)));
            jMenu2.addSeparator();
            JMenu jMenu3 = new JMenu("Transform");
            jMenu2.add(jMenu3);
            this.addTranformations(jMenu3, string -> this.mainPanel.setDirty(true));
            SpectralViewerHelper.enableMenuItems(jMenu2, false, checkBoxMenuItem);
            JMenu jMenu4 = new JMenu("View");
            jMenu4.add(new MenuItem("References", actionEvent -> {
                SpectralReferences spectralReferences = new SpectralReferences(this.measurement);
                this.showDialog(new ReferenceCachePanel.CachedSpectralPanel((BreezeMainPanel)this.mainPanel, spectralReferences), spectralReferences, ReferenceHelper.getReferenceTitle(this.measurement));
            }));
            jMenu4.add(new MenuItem("Metadata", actionEvent -> this.showDialog(new MetaPanel(this.mainPanel), this.measurement, "Metadata for " + this.measurement.getName())));
            JMenu jMenu5 = new JMenu("Analyse");
            jMenu5.add(new MenuItem("Analyse Tree", actionEvent -> this.showDialog(new GraphOverviewPanel(this.mainPanel, this.measurement.getWorkflow()), this.measurement, "Analyse Tree for " + this.measurement.getName())));
            jMenu5.addSeparator();
            jMenu5.add(new MenuItem("Apply Changes", "published_with_changes", actionEvent -> this.applyChanges()));
            jMenu5.addSeparator();
            PcaStreamQuantificationDescriptor.Info info = new PcaStreamQuantificationDescriptor.Info();
            jMenu5.add(new CheckBoxMenuItem("PCA", this.hasInfo(info), (jMenuItem, bl) -> {
                FunctionTreeNode functionTreeNode = this.applyAnalysisTree(info, bl);
                if (this.scatterPlot != null) {
                    ((AveragePlotPanel.ScatterPlot)this.scatterPlot.getPlot()).setNode(functionTreeNode);
                }
            }));
            SaturationDescriptor.Info info2 = new SaturationDescriptor.Info();
            jMenu5.add(new CheckBoxMenuItem("Saturation/Intensity", this.hasInfo(info2), (jMenuItem, bl) -> this.applyAnalysisTree(info2, bl)));
            JMenu jMenu6 = new JMenu("Export");
            jMenu6.add(new MenuItem("Open in Evince", actionEvent -> EvinceHelper.startEvince(this.file)));
            jMenu6.addSeparator();
            jMenu6.add(new MenuItem("Raw", actionEvent -> this.export(RtFramePredictor.ReferenceConvertTo.None)));
            this.radianceMenuItem = new MenuItem("Radiance", actionEvent -> this.export(RtFramePredictor.ReferenceConvertTo.Radiance));
            jMenu6.add(this.radianceMenuItem);
            this.reflectanceMenuItem = new MenuItem("Reflectance", actionEvent -> this.export(RtFramePredictor.ReferenceConvertTo.Reflectance));
            jMenu6.add(this.reflectanceMenuItem);
            this.absorbanceMenuItem = new MenuItem("Absorbance", actionEvent -> this.export(RtFramePredictor.ReferenceConvertTo.Absorbance));
            jMenu6.add(this.absorbanceMenuItem);
            JMenu jMenu7 = new JMenu("Help");
            jMenu7.add(new MenuItem("Help", actionEvent -> this.viewPanel.getViewer().help()));
            jMenu7.add(new CheckBoxMenuItem("Classic/Dark mode", BreezeTheme.getInstance().isDarkMode(), (jMenuItem, bl) -> {
                AbstractMainPanel.changeThemeClearInstance(this.mainPanel.getFrame(), bl ? "dark" : "classic");
                this.updateTheme();
                this.repaint();
            }));
            jMenu7.addSeparator();
            jMenu7.add(new MenuItem("About", actionEvent -> JOptionPane.showMessageDialog(this, "Prediktera Spectral Viewer\nVersion 1.0", "About", 1)));
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu4);
            if (showAnalysis) {
                jMenuBar.add(jMenu5);
            }
            jMenuBar.add(jMenu6);
            jMenuBar.add(jMenu7);
            return jMenuBar;
        }

        private void updateTheme() {
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            Color color = breezeTheme.getMainPanelBackground();
            BreezeFrame breezeFrame = this.mainPanel.getFrame();
            breezeFrame.setBackgroundFromTheme();
            this.setBackground(color);
            this.setForeground(color);
        }

        public void showOpenDialog() {
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Open file", (Component)this);
            jopensaveDialog2.setPreview(null, true);
            FileChooserPanel.addDataFileFilters(jopensaveDialog2, FileChooserPanel.FilterType.HS);
            jopensaveDialog2.addAllSupported();
            jopensaveDialog2.setCurrentDirectory(this.getDefaultFolder());
            if (jopensaveDialog2.openshow()) {
                File file = jopensaveDialog2.getSelectedFile();
                this.openFile(file);
            }
        }

        private void associateExtensions() {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(HdrImageImportInfo.hdrExtArray));
            arrayList.removeLast();
            arrayList.addAll(List.of(HySpexImageImportInfo.hdrExtArray));
            BreezeOptionDialog.showDialog(this, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Associate files with Spectral Viewer", "Spectral Viewer will be configured open i Windows for supported file extensions, for example when double-clicking a file in File Explorer.\n\nThis applies to files with extensions: %s\n\nTip: you can override this for individual file extensions in Windows 'Default Apps' app.\n".formatted(arrayList), null, breezeActionEvent -> WindowsFileExtensionAssociations.associateExtensionsForApp(arrayList));
        }

        private File getDefaultFolder() {
            if (this.file != null) {
                return this.file.getParentFile();
            }
            return WorkspaceManager.getWorkspaceFolder();
        }

        private void showDialog(AbstractViewPanel abstractViewPanel, Object object, String string) {
            BreezeOptionDialog.showDialog(this, this.getPageType().getColor(), AbstractBreezeDialog.MessageType.NO_BUTTON_OPTION.setOkText("Close"), string, "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(abstractViewPanel, object, 0.8, this.isEditMode() || showAnalysis), null, null);
        }

        public boolean hasInfo(AbstractDescriptorInfo abstractDescriptorInfo) {
            if (this.measurement == null) {
                return false;
            }
            Workflow workflow = this.measurement.getWorkflow();
            FunctionTreeNode functionTreeNode = workflow.getAnalyseTree().getRoot();
            return functionTreeNode.getNodeByInfo(abstractDescriptorInfo) != null;
        }

        private FunctionTreeNode applyAnalysisTree(AbstractDescriptorInfo abstractDescriptorInfo, boolean bl) {
            Workflow workflow = this.measurement.getWorkflow();
            FunctionTreeNode functionTreeNode = workflow.getAnalyseTree().getRoot();
            FunctionTreeNode functionTreeNode2 = functionTreeNode.getNodeByInfo(abstractDescriptorInfo);
            functionTreeNode.removeChild(functionTreeNode2);
            if (bl) {
                functionTreeNode2 = FunctionHelper.createNew(abstractDescriptorInfo);
                functionTreeNode.addChild(functionTreeNode2);
            }
            workflow.increaseChangeIndex();
            workflow.save();
            this.applyChanges();
            return functionTreeNode2;
        }

        private void applyChanges() {
            Workflow workflow = this.measurement.getWorkflow();
            final File file = FileHelper.createTempFileInWorkspace("xml");
            PPExportBreezeRuntime.export(BreezeProgressManager.createEmpty(), workflow, workflow.getName(), "", file, new RtPredictionMode(RtPredictionMode.PredictionMode.Rgb), workflow.getSegmentationLevel(), workflow.isParallelMeasurementSegmentation(), workflow.isIncludeChildObjects(), false, null, true, false, null);
            BreezeProgressDialog.startProgressWithCancel(this, new ProgressAction(this){
                final /* synthetic */ SpectralViewerFrame this$0;
                {
                    this.this$0 = spectralViewerFrame;
                }

                @Override
                public void runAction() {
                    TcpManager.getInstance().applyChangesFiles(this.getProgressManager(), file, Arrays.asList(this.this$0.file), null, true, false);
                    this.this$0.openMeasurement(this.this$0.measurement);
                }
            }, "Applying changes");
        }

        private void addTranformations(JMenu jMenu, MeasurementPopup.EntryPopupCallback entryPopupCallback) {
            this.addTransformButton(jMenu, "Spectral binning", "Enter binning factor", "2", (breezeProgressManager, measurement, rawFile, object) -> RawHelper.binSpectral(rawFile, RtDataFormat.toNumberInt(object.toString())), true, false, entryPopupCallback);
            this.addTransformButton(jMenu, "Pixel binning", "Enter binning factor", "2", (breezeProgressManager, measurement, rawFile, object) -> RawHelper.binSpatialPixels(rawFile, RtDataFormat.toNumberInt(object.toString())), true, false, entryPopupCallback);
            this.addTransformButton(jMenu, "Frames binning", "Enter binning factor", "2", (breezeProgressManager, measurement, rawFile, object) -> RawHelper.binSpatialFrames(rawFile, RtDataFormat.toNumberInt(object.toString())), false, false, entryPopupCallback);
            jMenu.addSeparator();
            this.addTransformButton(jMenu, "Mirror horizontal", null, null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.mirrorHorizontal(rawFile), true, false, entryPopupCallback);
            this.addTransformButton(jMenu, "Mirror vertical", null, null, (breezeProgressManager, measurement, rawFile, object) -> RawHelper.mirrorVertical(rawFile), false, false, entryPopupCallback);
        }

        private void addTransformButton(JMenu jMenu, String string, String string2, String string3, MeasurementPopup.TransformCallback transformCallback, boolean bl, boolean bl2, MeasurementPopup.EntryPopupCallback entryPopupCallback) {
            jMenu.add(new MenuItem(string, actionEvent -> {
                BreezeFrame breezeFrame = this.mainPanel.getFrame();
                List<Measurement> list = List.of(this.measurement);
                if (string2 != null) {
                    if (string2.equals("confirm")) {
                        BreezeOptionDialog.showDialog(breezeFrame, this.mainPanel.getPageColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm", "Confirm " + string, null, breezeActionEvent -> MeasurementPopup.transformImagesWithProgress(this.mainPanel, list, string, transformCallback, breezeActionEvent.result(), bl, bl2, entryPopupCallback, breezeFrame));
                    } else if (string2.equals("wavelength")) {
                        Measurement measurement = list.getFirst();
                        boolean[] blArray = measurement.getBandNames().getWaterAbsoptionIndexes();
                        BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Settings.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Select wavelengths to mask - included wavelengths are removed from the image", "", (AbstractBreezeCustomPanel)new SpectralRoiInputField.SpectralROIInputPanel(measurement.getBandNames(), blArray, measurement.getRootSample()), null, breezeActionEvent -> MeasurementPopup.transformImagesWithProgress(this.mainPanel, list, string, transformCallback, breezeActionEvent.result(), bl, bl2, entryPopupCallback, breezeFrame));
                    } else {
                        BreezeOptionDialog.showDialog(breezeFrame, this.mainPanel.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "Option", string2, string3, breezeActionEvent -> MeasurementPopup.transformImagesWithProgress(this.mainPanel, list, string, transformCallback, breezeActionEvent.result(), bl, bl2, entryPopupCallback, breezeFrame));
                    }
                } else {
                    MeasurementPopup.transformImagesWithProgress(this.mainPanel, list, string, transformCallback, null, bl, bl2, entryPopupCallback, breezeFrame);
                }
            }));
        }

        private BreezeType getPageType() {
            return BreezeType.Project;
        }

        public void export(final RtFramePredictor.ReferenceConvertTo referenceConvertTo) {
            File file;
            jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Choose export folder", (Component)this);
            jopensaveDialog2.setCurrentDirectory(this.file.getParentFile());
            jopensaveDialog2.setFileSelectionMode(1);
            if (jopensaveDialog2.saveshow() && (file = jopensaveDialog2.getSelectedFile()) != null) {
                BreezeProgressDialog.startProgressWithCancel(this, new ProgressAction(this){
                    final /* synthetic */ SpectralViewerFrame this$0;
                    {
                        this.this$0 = spectralViewerFrame;
                    }

                    @Override
                    public void runAction() {
                        this.setInfoText("Exporting segmentations");
                        new PPExportSegmentation.ExportSegmentations(file).perform(this.getProgressManager(), List.of(this.this$0.measurement), PPExportSegmentation.OutputFormat.Envi, PPExportSegmentation.OutputData.Pixels, referenceConvertTo, 0, null, 5, false, false, false);
                        ToastHandler.getInstance().showToast("Exported");
                    }
                }, "Export spectral pixel data");
            }
        }
    }

    public static class CommandLineSpectralViewerArgs
    extends CommandLineArgs {
        public CommandLineSpectralViewerArgs(String[] stringArray) {
            super(stringArray);
        }

        public File getFile() {
            String string = this.parser.getString("measurement", null, new String[0]);
            if (string != null) {
                return new File(string);
            }
            List<String> list = this.parser.getPositional();
            if (!list.isEmpty()) {
                return new File(list.getFirst());
            }
            return null;
        }

        public boolean copyFolder() {
            return this.parser.getFlag("copyFolder", false, new String[0]);
        }

        public boolean analysis() {
            return this.parser.getFlag("analysis", false, new String[0]);
        }
    }

    private static class CheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public CheckBoxMenuItem(String string, boolean bl, CheckBoxMenuItemCallback checkBoxMenuItemCallback) {
            super(string);
            this.setSelected(bl);
            this.addActionListener(actionEvent -> checkBoxMenuItemCallback.selected(this, this.isSelected()));
        }

        public static interface CheckBoxMenuItemCallback {
            public void selected(JMenuItem var1, boolean var2);
        }
    }

    private static class MenuItem
    extends JMenuItem {
        public MenuItem(String string, ActionListener actionListener) {
            super(string);
            this.addActionListener(actionListener);
        }

        public MenuItem(String string, String string2, ActionListener actionListener) {
            this(string, actionListener);
            this.setIcon(ImageHelper.getResourceIcon("material/" + string2));
        }
    }
}

