/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.prediktera.map.common.error.Logg;

public class WindowsFileExtensionAssociations {
    private static final String progId = "Prediktera.SpectralViewerImage.1";

    public static void associateExtensionsForApp(List<String> list) {
        if (!WindowsFileExtensionAssociations.registerApp()) {
            return;
        }
        for (String string : list) {
            try {
                string = WindowsFileExtensionAssociations.normalizeAndValidateExtension(string);
                WindowsFileExtensionAssociations.runRegCommand(new String[]{"reg", "add", "HKCU\\Software\\Classes\\." + string, "/ve", "/d", progId, "/f"});
            }
            catch (IOException | InterruptedException exception) {
                Logg.warn((String)("Failed to associate extension " + string), (Object[])new Object[]{exception});
            }
        }
        Logg.info((String)("Associated Spectral Viewer with extensions: " + String.valueOf(list)), (Object[])new Object[0]);
    }

    public static void removeExtensionsForApp(List<String> list) {
        for (String string : list) {
            try {
                string = WindowsFileExtensionAssociations.normalizeAndValidateExtension(string);
                WindowsFileExtensionAssociations.runRegCommand(new String[]{"reg", "delete", "HKCU\\Software\\Classes\\." + string, "/f"});
            }
            catch (IOException | InterruptedException exception) {
                Logg.warn((String)("Failed to remove extension " + string), (Object[])new Object[]{exception});
            }
        }
        Logg.info((String)("Removed Spectral Viewer for extensions: " + String.valueOf(list)), (Object[])new Object[0]);
    }

    private static boolean registerApp() {
        String string;
        try {
            string = WindowsFileExtensionAssociations.getAppPath();
        }
        catch (Exception exception) {
            Logg.error((String)"Could not locate Spectral Viewer executable path.", (Throwable)exception);
            return false;
        }
        try {
            WindowsFileExtensionAssociations.runRegCommand(new String[]{"reg", "add", "HKCU\\Software\\Classes\\Prediktera.SpectralViewerImage.1", "/ve", "/d", "Prediktera Spectral Viewer Image", "/f"});
            WindowsFileExtensionAssociations.runRegCommand(new String[]{"reg", "add", "HKCU\\Software\\Classes\\Prediktera.SpectralViewerImage.1\\shell\\open\\command", "/ve", "/d", string, "/f"});
        }
        catch (IOException | InterruptedException exception) {
            Logg.error((String)"Failed to create ProgID and shell command.", (Throwable)exception);
            return false;
        }
        return true;
    }

    private static void runRegCommand(String[] stringArray) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        int n = process.waitFor();
        if (n != 0) {
            throw new IOException("reg command + '" + Arrays.toString(stringArray) + "' failed with exit code: " + n);
        }
    }

    private static String normalizeAndValidateExtension(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Extension cannot be null");
        }
        String string2 = string.trim().toLowerCase();
        if (string2.startsWith(".")) {
            string2 = string2.substring(1);
        }
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("Extension cannot be empty or only a dot");
        }
        if (!string2.matches("[a-z0-9]+")) {
            throw new IllegalArgumentException("Invalid extension '" + string + "'. Allowed characters: [a-z0-9], no dots.");
        }
        return string2;
    }

    private static String getAppPath() throws IOException, InterruptedException {
        int n;
        ProcessBuilder processBuilder = new ProcessBuilder("reg", "query", "HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Prediktera Breeze", "/v", "InstallLocation", "/t", "REG_SZ");
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        String string = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (!string2.trim().startsWith("InstallLocation") || (stringArray = string2.trim().split("\\s+", 3)).length < 3) continue;
                string = stringArray[stringArray.length - 1];
                break;
            }
        }
        if ((n = process.waitFor()) != 0) {
            throw new IOException("Registry query failed with exit code: " + n);
        }
        if (string == null || string.isBlank()) {
            throw new IllegalStateException("InstallLocation not found for key: HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\Prediktera Breeze");
        }
        return Paths.get(string, "SpectralViewer.exe").toString();
    }

    static void main() {
        ArrayList<String> arrayList = new ArrayList<String>(List.of("erik1", "erik2"));
        WindowsFileExtensionAssociations.associateExtensionsForApp(arrayList);
        WindowsFileExtensionAssociations.removeExtensionsForApp(arrayList);
    }
}

