/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.PerformanceTime;
import se.prediktera.map.common.error.Logg;

public class Migrator {
    public static void migrateWorkspaceDirectoryStructure(File file2, BreezeProgressManager breezeProgressManager) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n = breezeProgressManager.setGroupMaximumAndReset(3);
        if (!file2.exists()) {
            throw new FileNotFoundException("No such directory: " + file2.getAbsolutePath());
        }
        if (!Migrator.shouldMigrateWorkspace(file2)) {
            return;
        }
        Logg.info((String)"Migrating workspace directory structure", (Object[])new Object[0]);
        File file3 = new File(file2, "Project");
        FileFilter fileFilter = file -> {
            breezeProgressManager.incStep((int)(file.length() / 1024L));
            return true;
        };
        HashMap<String, File> hashMap = new HashMap<String, File>();
        for (File file4 : Migrator.getFolders(breezeProgressManager, n, new File(file2, "Record"))) {
            breezeProgressManager.setMaximumAndReset((int)file4.length());
            object3 = new File(file4, "workflow.xml");
            object2 = XmlParserHelper.parseXMLRoot((File)object3, "workflow");
            object = new File(file3, file4.getName());
            hashMap.put(object2.getAttributes().getNamedItem("id").getNodeValue(), (File)object);
            FileUtils.copyDirectory((File)file4, (File)new File((File)object, "Data"), (FileFilter)fileFilter);
        }
        for (File file4 : Migrator.getFolders(breezeProgressManager, n, new File(file2, "Model"))) {
            breezeProgressManager.setMaximumAndReset((int)file4.length());
            object3 = new Analyse(file4);
            object2 = new File((File)hashMap.get(((Analyse)object3).getStudyId()), "Model");
            FileUtils.copyDirectory((File)file4, (File)new File((File)object2, file4.getName()), (FileFilter)fileFilter);
        }
        for (File file4 : Migrator.getFolders(breezeProgressManager, n, new File(file2, "Play"))) {
            breezeProgressManager.setMaximumAndReset((int)file4.length());
            object3 = new File(file4, "workflow.xml");
            object2 = XmlParserHelper.parseXMLRoot((File)object3, "workflow");
            object = object2.getChildNodes();
            String string = "";
            block3: for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (!node.getNodeName().equalsIgnoreCase("settings")) continue;
                NodeList nodeList = node.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node2 = nodeList.item(j);
                    if (!node2.getNodeName().equalsIgnoreCase("studyid")) continue;
                    string = node2.getFirstChild().getNodeValue();
                    break block3;
                }
                break;
            }
            if (StringUtils.isEmpty((CharSequence)string)) {
                throw new IOException("No project found for Workflow: " + file4.getName());
            }
            File file5 = new File((File)hashMap.get(string), "Play");
            FileUtils.copyDirectory((File)file4, (File)new File(file5, file4.getName()), (FileFilter)fileFilter);
        }
        breezeProgressManager.incStepGroup(n);
    }

    private static List<File> getFolders(BreezeProgressManager breezeProgressManager, int n, File file) {
        List<File> list;
        try (Stream<Path> stream = Files.list(file.toPath());){
            list = stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).map(Path::toFile).collect(Collectors.toList());
        }
        breezeProgressManager.incStepGroup(n);
        breezeProgressManager.setMaximumAndReset(list.size());
        return list;
    }

    public static boolean shouldMigrateWorkspace(WorkspaceManager workspaceManager) {
        if (workspaceManager == null || workspaceManager.getWorkspace() == null) {
            return false;
        }
        return new File(workspaceManager.getWorkspace().getFolder(), "Record").exists();
    }

    public static boolean shouldMigrateWorkspace(File file) {
        return new File(file, "Record").exists();
    }

    public static void main(String[] stringArray) throws IOException {
        PerformanceTime.globalStart();
        Migrator.migrateWorkspaceDirectoryStructure(new File("C:\\Users\\thoma\\BreezeTest"), BreezeProgressManager.createEmpty());
        PerformanceTime.globalEnd();
    }
}

