/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.map.common.error.Logg;

public class SettingsManager {
    @Generated
    private static final Object $LOCK = new Object[0];
    private static SettingsManager instance;
    private final List<File> workspaces;
    private File currentWorkspace;
    private final Path defaultWorkspace = Paths.get(WorkspaceManager.getUserHome(), "Breeze");

    public void setCurrentWorkspace(File file) {
        if (this.currentWorkspace.toPath() != this.defaultWorkspace) {
            this.workspaces.add(this.currentWorkspace);
        }
        this.currentWorkspace = file;
        this.save();
    }

    private SettingsManager() {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(Settings.class, new LoaderOptions()));
        File file = SettingsManager.getBreezeSettingsFile();
        this.currentWorkspace = this.defaultWorkspace.toFile();
        this.workspaces = new ArrayList<File>();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Settings settings = (Settings)yaml.load((InputStream)fileInputStream);
                if (settings.recent != null) {
                    Arrays.stream(settings.recent).map(File::new).forEach(this.workspaces::add);
                }
                if (settings.rootFolder != null) {
                    this.currentWorkspace = new File(settings.rootFolder);
                }
            }
            catch (Exception exception) {
                Logg.error((String)"Cannot parse Breeze settings file", (Throwable)exception);
            }
        }
        if (this.workspaces.isEmpty()) {
            this.workspaces.add(this.currentWorkspace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SettingsManager getInstance() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new SettingsManager();
            }
            return instance;
        }
    }

    public void save() {
        try (FileWriter fileWriter = new FileWriter(SettingsManager.getBreezeSettingsFile());){
            DumperOptions dumperOptions = new DumperOptions();
            Representer representer = new Representer(dumperOptions);
            representer.addClassTag(Settings.class, Tag.MAP);
            Yaml yaml = new Yaml(representer, dumperOptions);
            Settings settings = new Settings();
            settings.rootFolder = this.currentWorkspace.getAbsolutePath();
            settings.recent = (String[])this.workspaces.stream().map(File::getAbsolutePath).distinct().toArray(String[]::new);
            yaml.dump((Object)settings, (Writer)fileWriter);
        }
    }

    public static File getBreezeSettingsFile() {
        return new File(WorkspaceManager.getBreezeHome(), "Settings.yaml");
    }

    public static String getBreezeInstallFolder() {
        URI uRI = SettingsManager.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        File file = new File(uRI);
        if (file.isFile()) {
            return file.getParentFile().getAbsolutePath();
        }
        return file.getAbsolutePath();
    }

    @Generated
    public List<File> getWorkspaces() {
        return this.workspaces;
    }

    @Generated
    public File getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public static class Settings {
        public String rootFolder;
        public String[] recent;
    }
}

