/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import se.prediktera.breeze.backend.SettingsManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.update.UpdateHelper;

public class WorkspaceManager {
    public boolean SKIP_CREATE_DIRECTORIES = false;
    public boolean SKIP_READING_EVINCE_INI_FOR_UNIT_TEST = false;
    public boolean SKIP_STORING_EVINCE_INI_FOR_UNIT_TEST = false;
    public static boolean GUITEST = false;
    private static WorkspaceManager instance;
    private File overrideWorkspacePath = null;
    Workspace currentWorkspace;

    private WorkspaceManager() {
    }

    public static WorkspaceManager getInstance() {
        if (instance == null) {
            instance = new WorkspaceManager();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static boolean logError() {
        return GUITEST;
    }

    public boolean switchToNewWorkspace(String string) {
        Path path = Paths.get(string, new String[0]);
        if (this.currentWorkspace == null || !this.currentWorkspace.hasPath(path)) {
            Workspace workspace = new Workspace(path);
            workspace.storeWorkspacePath();
            this.currentWorkspace = workspace;
            return true;
        }
        return false;
    }

    public boolean hasWorkspace() {
        try {
            this.affirmExistingWorkspace();
            return this.currentWorkspace != null;
        }
        catch (WorkspacePermissionException workspacePermissionException) {
            return false;
        }
    }

    public Workspace getWorkspace() {
        this.affirmExistingWorkspace();
        return this.currentWorkspace;
    }

    public String getCurrentOrDefaultWorkspacePath() {
        return this.getCurrentOrDefaultWorkspaceFile().getAbsolutePath();
    }

    public File getCurrentOrDefaultWorkspaceFile() {
        if (this.currentWorkspace != null) {
            return this.currentWorkspace.getFolder();
        }
        return this.overrideWorkspacePath != null ? this.overrideWorkspacePath : new File(System.getProperty("user.home"), "Breeze");
    }

    public static File getWorkspaceFolder() {
        return WorkspaceManager.getInstance().getWorkspace().getFolder();
    }

    public static File getTempPath() {
        return WorkspaceManager.getInstance().getWorkspace().getTempPath();
    }

    private void affirmExistingWorkspace() {
        File file;
        if (this.currentWorkspace == null && (file = this.readWorkspacePathFromSettingsFile()) != null) {
            file.mkdirs();
            this.currentWorkspace = new Workspace(file.toPath());
        }
    }

    public void overrideWorkspacePath(File file) {
        this.overrideWorkspacePath = file;
        this.currentWorkspace = null;
        BreezeProperties.clearInstance();
    }

    private File readWorkspacePathFromSettingsFile() {
        if (this.overrideWorkspacePath != null) {
            return this.overrideWorkspacePath;
        }
        if (!this.SKIP_READING_EVINCE_INI_FOR_UNIT_TEST) {
            return SettingsManager.getInstance().getCurrentWorkspace();
        }
        return null;
    }

    public boolean isUnitTesting() {
        return this.SKIP_STORING_EVINCE_INI_FOR_UNIT_TEST;
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static File getPredikteraHome() {
        return new File(WorkspaceManager.getUserHome(), ".Prediktera");
    }

    public static File getBreezeHome() {
        return new File(WorkspaceManager.getPredikteraHome(), "Breeze");
    }

    public static File getBreezeRuntimeLogFile() {
        return new File(WorkspaceManager.getBreezeHome(), "BreezeRuntime.log");
    }

    public static File getIntegrationTestWorkspace() {
        return new File(WorkspaceManager.getUserHome(), "breezeintegrationtest");
    }

    public static WorkspaceManager setupTestWorkspace(boolean bl, boolean bl2) {
        if (bl) {
            WorkspaceManager.deleteWorkspaceBeforeStart(WorkspaceManager.getIntegrationTestWorkspace());
        }
        WorkspaceManager workspaceManager = WorkspaceManager.getInstance();
        workspaceManager.SKIP_STORING_EVINCE_INI_FOR_UNIT_TEST = true;
        if (bl2) {
            try {
                workspaceManager.switchToNewWorkspace(WorkspaceManager.getIntegrationTestWorkspace().getAbsolutePath());
            }
            catch (Exception exception) {
                workspaceManager.switchToNewWorkspace(WorkspaceManager.getIntegrationTestWorkspace().getAbsolutePath());
            }
        }
        BreezeProperties.clearInstance();
        BreezeProperties.getInstance().setWhiteReferenceFrames(new FrameCount(25));
        BreezeProperties.getInstance().setDarkReferenceFrames(new FrameCount(25));
        return workspaceManager;
    }

    private static void deleteWorkspaceBeforeStart(File file) {
        for (int i = 0; i < 10; ++i) {
            try {
                FileUtils.deleteDirectory((File)file);
                break;
            }
            catch (IOException iOException) {
                Logg.error((String)("Cannot delete workspace for GuiTest (try " + (i + 1) + " of 10): " + iOException.getMessage()), (Object[])new Object[0]);
                ThreadUtil.sleep(1000L);
                continue;
            }
        }
        MatcherAssert.assertThat((String)"Workspace was not deleted", (Object)file.exists(), (Matcher)CoreMatchers.is((Object)false));
    }

    public class Workspace {
        private final Path path;

        public Workspace(Path path) {
            this.path = path;
            if (!Files.exists(path, new LinkOption[0])) {
                this.createWorkspaceDirectory(path);
            }
            if (!WorkspaceManager.this.SKIP_CREATE_DIRECTORIES) {
                this.createFoldersAndCheckFolderPermissions();
            }
        }

        private void createFoldersAndCheckFolderPermissions() {
            for (File file : Arrays.asList(this.getRecordPath(), this.getModelPath(), this.getPlayPath(), this.getDataPath(), this.getImportPath(), this.getDownloadPath(), this.getTempPath(), this.getRuntimePath(), this.getCustomizePath())) {
                boolean bl;
                boolean bl2 = bl = !file.exists() && !file.mkdirs();
                if (!bl && file.canRead() && file.canWrite()) continue;
                Logg.error((String)("Incorrect folder permission for folder " + file.getAbsolutePath() + " (Read: " + (file.canRead() ? "Yes" : "No") + ", Write: " + (file.canRead() ? "Yes" : "No") + ")"), (Object[])new Object[0]);
                throw new WorkspacePermissionException(file);
            }
            this.clearTempFolder();
        }

        public void clearTempFolder() {
            try {
                FileUtils.cleanDirectory((File)this.getTempPath());
            }
            catch (IOException iOException) {
                Logg.error((String)("Cannot clear temp folder: " + iOException.getMessage()), (Object[])new Object[0]);
            }
        }

        public void storeWorkspacePath() {
            if (!WorkspaceManager.this.SKIP_STORING_EVINCE_INI_FOR_UNIT_TEST) {
                SettingsManager.getInstance().setCurrentWorkspace(this.path.toFile());
            }
        }

        public boolean hasPath(Path path) {
            return this.path.equals(path);
        }

        public Path getPath() {
            return this.path;
        }

        public File getFolder() {
            return this.path.toFile();
        }

        private void createWorkspaceDirectory(Path path) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new WorkspacePermissionException("Failed to create directory for workspace: " + String.valueOf(path), iOException, path.toFile());
            }
        }

        public File getBreezeProperties() {
            return new File(this.path.toFile(), "BreezeProperties.xml");
        }

        public File getRecordPath() {
            return new File(this.path.toFile(), "Record");
        }

        public File getModelPath() {
            return new File(this.path.toFile(), "Model");
        }

        public File getPlayPath() {
            return new File(this.path.toFile(), "Play");
        }

        public File getDataPath() {
            return new File(this.path.toFile(), "Data");
        }

        public File getImportPath() {
            return new File(this.getDataPath(), "Import");
        }

        public File getDownloadPath() {
            return new File(this.getDataPath(), "Download");
        }

        public File getRecyclePath() {
            return new File(this.getDataPath(), "Recycled");
        }

        public File getTempPath() {
            return new File(this.getDataPath(), "Temp");
        }

        public File getBackupPath() {
            return new File(this.getDataPath(), "Backup");
        }

        public File getRuntimePath() {
            return new File(this.getDataPath(), "Runtime");
        }

        public File getRuntimeReferencesPath() {
            return new File(this.getRuntimePath(), "References");
        }

        public File getRuntimeWhiteReferencePath() {
            return new File(this.getRuntimeReferencesPath(), "White");
        }

        public File getRuntimeWhiteIntensityReferencePath() {
            return new File(this.getRuntimeReferencesPath(), "WhiteIntensity");
        }

        public File getRuntimeDarkReferencePath() {
            return new File(this.getRuntimeReferencesPath(), "Dark");
        }

        public File getRuntimeScReferencePath() {
            return new File(this.getRuntimeReferencesPath(), "SC");
        }

        public File getRuntimeMeasurementsPath() {
            return new File(this.getRuntimePath(), "Measurements");
        }

        public File getCustomizePath() {
            return new File(this.getDataPath(), "Customize");
        }

        public long getTotalSpace() throws IOException {
            return Files.getFileStore(this.path.getRoot()).getTotalSpace();
        }

        public long getUsableSpace() throws IOException {
            return Files.getFileStore(this.path.getRoot()).getUsableSpace();
        }

        public boolean hasLowDiskSpace() {
            try {
                long l = this.getUsableSpace();
                double d = (double)l / 1024.0 / 1024.0 / 1024.0;
                return d < 10.0;
            }
            catch (IOException iOException) {
                System.err.println("Cannot get usable disk space: " + iOException.getMessage());
                return false;
            }
        }

        public void showDiscSpaceDialog(BreezeFrame breezeFrame) {
            try {
                long l = this.getTotalSpace();
                long l2 = this.getUsableSpace();
                BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.WARNING_OPTION, "Low disk space", "Workspace disk (" + String.valueOf(this.path.getRoot()) + ") is running low on disk space\n\nAvailable: " + UpdateHelper.formatSize((long)l2) + " of total " + UpdateHelper.formatSize((long)l) + "\n\nPlease free more space before running Breeze", null, null);
            }
            catch (IOException iOException) {
                System.err.println("Cannot get usable space: " + iOException.getMessage());
            }
        }
    }

    public static class WorkspacePermissionException
    extends RuntimeException {
        private final File folder;

        public WorkspacePermissionException(File file) {
            this.folder = file;
        }

        public WorkspacePermissionException(String string, IOException iOException, File file) {
            super(string, iOException);
            this.folder = file;
        }

        public File getFolder() {
            return this.folder;
        }
    }
}

