/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.entry;

import java.awt.Component;
import javax.swing.JList;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;

public class RtPredictionMode {
    private final PredictionMode predictionMode;
    private PredictionModeSetup predictionSetup;

    public RtPredictionMode(PredictionMode predictionMode) {
        this.predictionMode = predictionMode;
        if (predictionMode.equals((Object)PredictionMode.Normal)) {
            this.predictionSetup = new NormalModeSetup();
        } else if (predictionMode.equals((Object)PredictionMode.ObjectToPixelsPipeline)) {
            this.predictionSetup = new PixelToObjectModeSetup();
        } else if (predictionMode.equals((Object)PredictionMode.Rgb)) {
            this.predictionSetup = new RgbModeSetup();
        }
    }

    public RtPredictionMode(Node node) {
        if (node != null) {
            this.predictionMode = RtPredictionMode.parseMode(node.getTextContent());
            if (this.predictionMode.equals((Object)PredictionMode.Normal)) {
                this.predictionSetup = new NormalModeSetup(node);
            } else if (this.predictionMode.equals((Object)PredictionMode.ObjectToPixelsPipeline)) {
                this.predictionSetup = new PixelToObjectModeSetup(node);
            } else if (this.predictionMode.equals((Object)PredictionMode.Rgb)) {
                this.predictionSetup = new RgbModeSetup(node);
            }
        } else {
            this.predictionMode = PredictionMode.Rgb;
        }
    }

    public RtPredictionMode(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.predictionMode = RtPredictionMode.parseMode(jSONObject.getString("PredictionMode"));
            if (this.predictionMode.equals((Object)PredictionMode.Normal)) {
                this.predictionSetup = new NormalModeSetup(jSONObject);
            } else if (this.predictionMode.equals((Object)PredictionMode.ObjectToPixelsPipeline)) {
                this.predictionSetup = new PixelToObjectModeSetup(jSONObject);
            } else if (this.predictionMode.equals((Object)PredictionMode.Rgb)) {
                this.predictionSetup = new RgbModeSetup(jSONObject);
            }
        } else {
            this.predictionMode = PredictionMode.Rgb;
        }
    }

    public boolean isMode(PredictionMode predictionMode) {
        return this.predictionMode.equals((Object)predictionMode);
    }

    public PredictionMode getMode() {
        return this.predictionMode;
    }

    public PredictionModeSetup getPredictionSetup() {
        return this.predictionSetup;
    }

    public void save(Element element) {
        Element element2 = XmlParserHelper.addElement((Node)element, "predictionMode", this.predictionMode.toString());
        if (this.predictionSetup != null) {
            this.predictionSetup.save(element2);
        }
    }

    public static PredictionMode parseMode(String string) {
        for (PredictionMode predictionMode : PredictionMode.values()) {
            if (!predictionMode.toString().equalsIgnoreCase(string)) continue;
            return predictionMode;
        }
        return PredictionMode.Normal;
    }

    public String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.predictionMode.getDisplayName());
        if (this.predictionSetup != null && (string = this.predictionSetup.toString()).length() > 0) {
            stringBuilder.append(" (");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static enum PredictionMode {
        Rgb,
        Normal,
        ObjectToPixelsPipeline;


        public String getDisplayName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "RGB";
                case 1 -> "Pixel Prediction Lines";
                case 2 -> "Object to Pixels Pipeline";
            };
        }

        public static class PredictionModeCellRenderer
        extends BreezeComboBox.ComboBoxListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                return super.getListCellRendererComponent(jList, (Object)((PredictionMode)((Object)object)).getDisplayName(), n, bl, bl2);
            }
        }
    }

    public static class NormalModeSetup
    implements PredictionModeSetup {
        private int chunks;

        public NormalModeSetup() {
            this.chunks = this.getDefaultChunks();
        }

        public NormalModeSetup(Node node) {
            this.chunks = XmlParserHelper.getIntAttribute(node, "chunks", this.getDefaultChunks());
        }

        public NormalModeSetup(JSONObject jSONObject) {
            this();
            if (jSONObject.has("Chunks")) {
                this.chunks = jSONObject.getInt("Chunks");
            }
        }

        protected int getDefaultChunks() {
            return 1;
        }

        @Override
        public void save(Element element) {
            element.setAttribute("chunks", String.valueOf(this.chunks));
        }

        @Override
        public int getChunks() {
            return this.chunks;
        }

        @Override
        public void setChunks(int n) {
            this.chunks = n;
        }

        public String toString() {
            if (this.chunks > 1) {
                return "Chunks = " + this.chunks;
            }
            return "";
        }
    }

    public static interface PredictionModeSetup {
        public void save(Element var1);

        public int getChunks();

        public void setChunks(int var1);
    }

    public static class PixelToObjectModeSetup
    extends NormalModeSetup {
        private int bufferSize = 20;
        private int lineBinning = 1;

        public PixelToObjectModeSetup() {
        }

        public PixelToObjectModeSetup(Node node) {
            super(node);
            this.bufferSize = XmlParserHelper.getIntAttribute(node, "bufferSize", 20);
            this.lineBinning = XmlParserHelper.getIntAttribute(node, "lineBinning", 20);
        }

        public PixelToObjectModeSetup(int n, int n2) {
            this.bufferSize = n;
            this.lineBinning = n2;
        }

        public PixelToObjectModeSetup(JSONObject jSONObject) {
            super(jSONObject);
            if (jSONObject.has("BufferSize")) {
                this.bufferSize = jSONObject.getInt("BufferSize");
            }
            if (jSONObject.has("LineBinning")) {
                this.lineBinning = jSONObject.getInt("LineBinning");
            }
        }

        @Override
        protected int getDefaultChunks() {
            return 5;
        }

        @Override
        public void save(Element element) {
            super.save(element);
            element.setAttribute("bufferSize", String.valueOf(this.bufferSize));
            element.setAttribute("lineBinning", String.valueOf(this.lineBinning));
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public int getLineBinning() {
            return this.lineBinning;
        }

        @Override
        public String toString() {
            return "Buffer size = " + this.bufferSize + ", Chunks = " + this.getChunks() + ", Line binning = " + this.lineBinning;
        }
    }

    public static class RgbModeSetup
    extends NormalModeSetup {
        private boolean blending = true;

        public RgbModeSetup() {
        }

        public RgbModeSetup(Node node) {
            super(node);
            this.blending = XmlParserHelper.getBooleanAttribute(node, "blendBackground", true);
        }

        public RgbModeSetup(boolean bl) {
            this.blending = bl;
        }

        public RgbModeSetup(JSONObject jSONObject) {
            super(jSONObject);
            this.blending = jSONObject.optBoolean("BlendBackground", true);
        }

        @Override
        public void save(Element element) {
            super.save(element);
            element.setAttribute("blendBackground", String.valueOf(this.blending));
        }

        public void setBlending(boolean bl) {
            this.blending = bl;
        }

        public boolean isBlending() {
            return this.blending;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getChunks() > 1) {
                stringBuilder.append("Chunks = " + this.getChunks() + ", ");
            }
            if (this.blending) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("Blend background");
            }
            return stringBuilder.toString();
        }
    }
}

