/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.entry;

import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import lombok.Generated;
import org.w3c.dom.Node;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.common.entry.BasicMasterCache;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyseList;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflowList;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.Logg;

public class RtWorkflow
extends BasicWorkflow
implements BasicMasterCache.MasterCacheInterface {
    private EvaluationTree tree;
    private final BasicWorkflowList studyList = new BasicWorkflowList();
    private final BasicAnalyseList<BasicAnalyse> analyseList = new BasicAnalyseList();
    private final BasicWorkflowList workflowList = new BasicWorkflowList();
    private int maxLines = 10000;
    private String uid = "";
    private String studyId = "";
    private String name = "";
    private String createdTime;
    private String createdBy;
    private String description = "";
    private String sourceVersion = "";
    private RtPredictionMode predictionMode = new RtPredictionMode(RtPredictionMode.PredictionMode.Rgb);
    private File xmlFile;
    protected String direction = "vertical";
    protected String horizontalDirection = "right";
    protected String verticalDirection = "up";

    public RtWorkflow() {
    }

    public RtWorkflow(String string, String string2, String string3, String string4, String string5) {
        this.uid = string;
        this.name = string2;
        this.description = string3;
        this.createdTime = string4;
        this.createdBy = string5;
    }

    public RtWorkflow(File file) {
        this.xmlFile = file;
        Node node = XmlParserHelper.parseXMLRoot(file, "breezeapi");
        this.name = XmlParserHelper.getAttribute(node, "name");
        this.createdTime = XmlParserHelper.getAttribute(node, "createddate");
        this.createdBy = XmlParserHelper.getAttribute(node, "createdby");
        this.uid = XmlParserHelper.getAttribute(node, "id");
        String string = InitClass.getBreezeVersion().format(true);
        this.sourceVersion = XmlParserHelper.getAttribute(node, "sourceversion", string);
        if (!StringHelper.equals((String)this.sourceVersion, (String)string)) {
            Logg.warn((String)("Workflow source version is not the same as the current version. Source version: " + this.sourceVersion), (Object[])new Object[0]);
        }
        for (Node node2 : XmlParserHelper.getNodeList(node)) {
            if (node2.getNodeName().equalsIgnoreCase("settings")) {
                for (Node node3 : XmlParserHelper.getNodeList(node2)) {
                    if (node3.getNodeName().equalsIgnoreCase("maxlines")) {
                        this.maxLines = RtDataFormat.toNumberInt(node3.getTextContent());
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("studyId")) {
                        this.studyId = node3.getTextContent();
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("description")) {
                        this.description = node3.getTextContent();
                        continue;
                    }
                    if (node3.getNodeName().equalsIgnoreCase("predictionMode")) {
                        this.predictionMode = new RtPredictionMode(node3);
                        continue;
                    }
                    if (!node3.getNodeName().equalsIgnoreCase("visualization")) continue;
                    this.direction = XmlParserHelper.getAttribute(node3, "direction", "vertical");
                    this.horizontalDirection = XmlParserHelper.getAttribute(node3, "horizontalDirection", "right");
                    this.verticalDirection = XmlParserHelper.getAttribute(node3, "verticalDirection", "up");
                }
                continue;
            }
            if (node2.getNodeName().equalsIgnoreCase("graph")) {
                HashMap hashMap = new HashMap();
                this.tree = new EvaluationTree(node2, hashMap);
                continue;
            }
            if (!node2.getNodeName().equalsIgnoreCase("analyse")) continue;
            this.analyseList.add(new RtAnalyse(node2));
        }
        this.studyList.add(this);
        this.workflowList.add(this);
    }

    @Override
    public File getXml() {
        return this.xmlFile;
    }

    public void setAnalyseTree(EvaluationTree evaluationTree) {
        this.tree = evaluationTree;
    }

    @Override
    public EvaluationTree getAnalyseTree() {
        return this.tree;
    }

    @Override
    public int getMaxLines() {
        return this.maxLines;
    }

    @Override
    public BasicWorkflowList getStudyList() {
        return this.studyList;
    }

    @Override
    public BasicAnalyseList<BasicAnalyse> getAnalyseList() {
        return this.analyseList;
    }

    @Override
    public BasicAnalyseList<BasicAnalyse> getRtAnalyseList() {
        return this.analyseList;
    }

    @Override
    public BasicWorkflowList getWorkflowList() {
        return this.workflowList;
    }

    @Override
    public String getStudyId() {
        return this.studyId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isGrayed() {
        return false;
    }

    @Override
    public File getFolder() {
        return WorkspaceManager.getInstance().getWorkspace().getRuntimePath();
    }

    public boolean isDirectionVertical() {
        return this.direction == null || !this.direction.equals("horizontal");
    }

    public boolean isHorizontalDirectionRight() {
        return this.horizontalDirection == null || !this.horizontalDirection.equals("left");
    }

    public boolean isVerticalDirectionUp() {
        return this.verticalDirection == null || !this.verticalDirection.equals("down");
    }

    public int compareTo(ListHelper.SortType sortType, RtWorkflow rtWorkflow) {
        try {
            Date date;
            Date date2;
            int n;
            if (sortType.equals((Object)ListHelper.SortType.Created) && (n = (date2 = EntryData.format.parse(this.getCreatedTime())).compareTo(date = EntryData.format.parse(rtWorkflow.getCreatedTime()))) != 0) {
                return n;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return this.name.compareToIgnoreCase(rtWorkflow.getName());
    }

    @Override
    public boolean delete(boolean bl) {
        if (this.xmlFile != null && this.xmlFile.exists()) {
            return this.xmlFile.delete();
        }
        return TcpManager.getInstance().deleteWorkflow(this.uid).hasSucceded();
    }

    @Override
    public EntryData getEntryData() {
        return null;
    }

    @Generated
    public String getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getSourceVersion() {
        return this.sourceVersion;
    }

    @Generated
    public RtPredictionMode getPredictionMode() {
        return this.predictionMode;
    }

    @Generated
    public void setPredictionMode(RtPredictionMode rtPredictionMode) {
        this.predictionMode = rtPredictionMode;
    }

    @Generated
    public void setXmlFile(File file) {
        this.xmlFile = file;
    }

    @Generated
    public void setDirection(String string) {
        this.direction = string;
    }
}

