/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.grabber;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.grabber.CameraStreamAddOn;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ExceptionHandlingThread;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.hardware.Camera;

public class CameraStreamGrabber {
    private ExceptionHandlingThread grabbingThread = null;
    private final AddOnList addOnList = new AddOnList();
    private Boolean stop = null;
    private boolean toggle;
    private Camera.CaptureControl captureControl;

    public void startGrab(Camera camera) {
        this.startGrab(camera, FrameCount.Continuously, null, false);
    }

    public void startGrab(Camera camera, FrameCount frameCount) {
        this.startGrab(camera, frameCount, null, false);
    }

    public void startGrab(Camera camera, FrameCount frameCount, final Runnable runnable, boolean bl) {
        this.addOnList.init(camera, frameCount);
        this.toggle = false;
        this.stop = false;
        this.grabbingThread = new ExceptionHandlingThread("CameraStreamGrabber", () -> {
            if (bl) {
                ThreadUtil.awaitOrThrow(() -> this.toggle || this.stop != false, new Time.Minutes(2.0), "Timeout waiting for OnScanStarted Event");
                if (this.stop.booleanValue()) {
                    return;
                }
            }
            camera.startCapture(frameCount, new Camera.DefaultCaptureCallback(this){
                final /* synthetic */ CameraStreamGrabber this$0;
                {
                    this.this$0 = cameraStreamGrabber;
                }

                @Override
                public void onStart(Camera.CaptureControl captureControl) {
                    this.this$0.captureControl = captureControl;
                }

                @Override
                public void onFrame(FrameStack frameStack, Camera.CaptureControl captureControl) {
                    this.this$0.addOnList.apply(frameStack);
                    if (this.this$0.stop.booleanValue()) {
                        captureControl.stop();
                    }
                }

                @Override
                public void onStop() {
                    this.this$0.addOnList.stop();
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }, runtimeException -> {
            throw runtimeException;
        });
        this.grabbingThread.start();
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
    }

    public void stop() {
        if (this.captureControl != null) {
            this.captureControl.stop();
            this.captureControl = null;
        }
        this.stop = true;
        if (this.grabbingThread != null) {
            this.grabbingThread.joinOrThrow();
        }
    }

    public boolean isRunning() {
        if (this.grabbingThread == null) {
            return false;
        }
        return this.grabbingThread.isAlive();
    }

    public void addOn(CameraStreamAddOn cameraStreamAddOn) {
        this.addOnList.addOn(cameraStreamAddOn);
    }

    public static class AddOnList {
        private final List<CameraStreamAddOn> list = new ArrayList<CameraStreamAddOn>();

        public void addOn(CameraStreamAddOn cameraStreamAddOn) {
            this.list.add(cameraStreamAddOn);
        }

        public void init(Camera camera, FrameCount frameCount) {
            for (CameraStreamAddOn cameraStreamAddOn : this.list) {
                cameraStreamAddOn.init(camera, frameCount);
            }
        }

        public void apply(FrameStack frameStack) {
            for (CameraStreamAddOn cameraStreamAddOn : this.list) {
                cameraStreamAddOn.apply(frameStack);
            }
        }

        public void stop() {
            for (CameraStreamAddOn cameraStreamAddOn : this.list) {
                cameraStreamAddOn.stop();
            }
        }
    }
}

