/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.grabber;

import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import se.prediktera.breeze.backend.grabber.CameraStreamAddOn;
import se.prediktera.breeze.backend.grabber.CameraStreamGrabber;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.util.BoolHolder;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.hardware.camera.capture.TcpStream;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.util.datacreation.ShortFrameCreator;

@Category(value={SlowTestCategory.class})
public class CameraStreamGrabberTest {
    @Test
    public void shouldInitAddons() {
        GrabberTestSetup grabberTestSetup = new GrabberTestSetup();
        grabberTestSetup.grabber.startGrab(grabberTestSetup.camera);
        MatcherAssert.assertThat((String)"addon was inititialized with correct camera", (boolean)grabberTestSetup.addOn.initCalledWith(grabberTestSetup.camera));
    }

    @Test
    public void shouldApplyAddons() {
        GrabberTestSetup grabberTestSetup = new GrabberTestSetup();
        ShortFrame shortFrame = ShortFrameCreator.create(10, 10, 1.0f);
        grabberTestSetup.stream.returnFrame(shortFrame);
        grabberTestSetup.grabber.startGrab(grabberTestSetup.camera);
        BoolHolder boolHolder = new BoolHolder(false);
        grabberTestSetup.stream.afterFirstFrame(() -> {
            grabberTestSetup.grabber.stop();
            boolHolder.setTrue();
        });
        ThreadUtil.awaitOrThrow(() -> boolHolder.getValue(), Time.Second);
        MatcherAssert.assertThat((String)"addon was applied with frame", (boolean)grabberTestSetup.addOn.appliedWith(shortFrame));
    }

    private static class GrabberTestSetup {
        private final TcpStream.FakeStream stream = new TcpStream.FakeStream();
        private final FakeCamera camera = new FakeCamera(this.stream);
        private final CameraStreamGrabber grabber = new CameraStreamGrabber();
        private final CameraStreamAddOn.FakeAddOn addOn = new CameraStreamAddOn.FakeAddOn();

        public GrabberTestSetup() {
            this.grabber.addOn(this.addOn);
        }
    }
}

