/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.wizard.telops.ReflectiveType;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.map.common.error.Logg;

public class HySpexTelopReflectivityHandler {
    private final Camera lwirCamera;
    private final Camera mwirCamera;
    private Map<ReflectiveType, File> scFilesLwir;
    private Map<ReflectiveType, File> scFilesMwir;

    public HySpexTelopReflectivityHandler(Camera camera, Camera camera2) {
        this.lwirCamera = camera;
        this.mwirCamera = camera2;
    }

    public boolean sendReflectivityScanCommand(BreezeProgress breezeProgress, ReflectiveType reflectiveType) {
        RemoteSampleMover remoteSampleMover = (RemoteSampleMover)HardwareRegistry.getInstance().getSampleMover();
        try {
            Map<String, String> map = remoteSampleMover.remoteScan(breezeProgress, 0.0f, new LengthValue(0.0f), reflectiveType.getScanMode(), this.lwirCamera, List.of(new FrameCount(0)), false, false);
            if (map.containsKey("scFilePath1")) {
                this.scFilesLwir.put(reflectiveType, HySpexTelopReflectivityHandler.copyAndLog(map.get("scFilePath1"), this.lwirCamera, reflectiveType));
            }
            if (map.containsKey("scFilePath2")) {
                this.scFilesMwir.put(reflectiveType, HySpexTelopReflectivityHandler.copyAndLog(map.get("scFilePath2"), this.mwirCamera, reflectiveType));
            }
            return true;
        }
        catch (Exception exception) {
            Logg.error((String)"Command failed", (Throwable)exception);
            return false;
        }
    }

    private static File copyAndLog(String string, Camera camera, ReflectiveType reflectiveType) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            Logg.error((String)("Could not find file: " + file.getAbsolutePath()), (Object[])new Object[0]);
            return FileHelper.newNonExistingFile();
        }
        Map<String, String> map = Map.of("timestamp", Instant.now().toString(), "integrationTime", RtDataFormat.toString(camera.getIntegrationTime().value));
        File file2 = new File(WorkspaceManager.getInstance().getWorkspace().getRuntimeScReferencePath(), file.getName());
        FileUtils.copyFile((File)file, (File)file2);
        BreezeProperties.getInstance().setCameraTypeProperty(camera, camera.getCameraType(), reflectiveType.getScanMode().name().toLowerCase(), file2.getAbsolutePath(), map);
        return file2;
    }

    @Generated
    public Map<ReflectiveType, File> getScFilesLwir() {
        return this.scFilesLwir;
    }

    @Generated
    public Map<ReflectiveType, File> getScFilesMwir() {
        return this.scFilesMwir;
    }
}

