/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure;

import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.backend.measure.state.DarkRefGrabState;
import se.prediktera.breeze.backend.measure.state.MeasurementGrabState;
import se.prediktera.breeze.backend.measure.state.ScanGrabState;
import se.prediktera.breeze.backend.measure.state.WhiteRefGrabState;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.thread.ExceptionHandlingThread;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.client.select.active.ActiveRealtimePanel;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.common.error.Logg;

public class MeasurementTaker {
    private final MeasureSettings measureSettings;
    private final ExceptionHandlingThread.ThreadExceptionCallback exceptionCallback;
    protected final DarkRefGrabState darkRefGrabState;
    protected final WhiteRefGrabState whiteRefGrabState;
    private final ScanGrabState scanGrabState;
    private final MeasurementGrabState measurementGrabState;
    private final HashSet<Camera> tookManualWhiteReference = new HashSet();
    private final HashSet<Camera> tookManualDarkReference = new HashSet();
    private ExceptionHandlingThread measureThread;
    private final BreezeMainPanel mainPanel;
    private MeasurementStatus status = MeasurementStatus.Idle;
    private final List<Camera> cameras;
    private boolean measurementStopped;
    private List<Measurement> measurements;
    private ActiveRealtimePanel.ActiveTablePanel activeTablePanel;

    public MeasurementTaker(BreezeMainPanel breezeMainPanel, ActiveRealtimePanel.ActiveTablePanel activeTablePanel, Group group, MeasureSettings measureSettings, ExceptionHandlingThread.ThreadExceptionCallback threadExceptionCallback, List<Camera> list, BreezeRecorder.RecordMode recordMode, RtBasicVariable rtBasicVariable, Camera.MultiCameraMode multiCameraMode) {
        this.mainPanel = breezeMainPanel;
        this.activeTablePanel = activeTablePanel;
        this.cameras = list;
        this.darkRefGrabState = new DarkRefGrabState(measureSettings);
        this.whiteRefGrabState = new WhiteRefGrabState(measureSettings);
        this.measurementGrabState = new MeasurementGrabState(breezeMainPanel, this, list, group, measureSettings, recordMode, rtBasicVariable, multiCameraMode);
        this.scanGrabState = new ScanGrabState(group, measureSettings, this.measurementGrabState);
        this.measureSettings = measureSettings;
        this.exceptionCallback = runtimeException -> {
            this.stopMeasurementTaking(true, list -> threadExceptionCallback.onException(runtimeException));
            return true;
        };
    }

    public void startMeasurementTaking(BreezeFrame breezeFrame, final OnMeasurementTakingStartedCallback onMeasurementTakingStartedCallback, final OnMeasurementTakingFinishedCallback onMeasurementTakingFinishedCallback, final OnMeasurementTakingAbortedCallback onMeasurementTakingAbortedCallback, final OnMeasurementFrameCallback onMeasurementFrameCallback) {
        Logg.trace((String)"startMeasurementTaking {} {}", (Object[])new Object[]{this.scanGrabState, this.measureSettings});
        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(this){
            final /* synthetic */ MeasurementTaker this$0;
            {
                this.this$0 = measurementTaker;
            }

            @Override
            public void runAction() {
                this.this$0.status = MeasurementStatus.References;
                int n = this.getProgressManager().setGroupMaximumAndReset(this.this$0.cameras.size() * 2 + 1);
                for (Camera camera : this.this$0.cameras) {
                    if (!this.this$0.tookManualDarkReference.contains(camera)) {
                        this.this$0.darkRefGrabState.grabWithQualityCheck(this.this$0.mainPanel, this.getProgressManager(), camera);
                    }
                    this.getProgressManager().incStepGroup(n);
                    if (!this.this$0.tookManualWhiteReference.contains(camera)) {
                        this.this$0.whiteRefGrabState.grabWithQualityCheck(this.this$0.mainPanel, this.getProgressManager(), true, camera);
                    }
                    this.getProgressManager().incStepGroup(n);
                }
                this.setTitle("Loading workflow");
                this.this$0.scanGrabState.loadWorkflow(this.this$0.cameras, () -> {
                    this.this$0.status = MeasurementStatus.Recorded;
                    onMeasurementTakingFinishedCallback.onMeasurementTakingFinished();
                }, onMeasurementFrameCallback, this.getProgressManager());
                this.getProgressManager().incStepGroup(n);
                this.setIndeterminate();
            }

            @Override
            public void actionComplete() {
                this.this$0.measureThread = new ExceptionHandlingThread("MeasurementTaker.startMeasurementTaking", () -> {
                    onMeasurementTakingStartedCallback.onMeasurementTakingStarted();
                    this.this$0.status = MeasurementStatus.Grabbing;
                    this.this$0.scanGrabState.grab(this.this$0.cameras);
                }, this.this$0.exceptionCallback);
                this.this$0.measureThread.start();
            }

            @Override
            public boolean actionFailed(Exception exception) {
                onMeasurementTakingAbortedCallback.onMeasurementTakingAborted();
                return super.actionFailed(exception);
            }

            @Override
            public void actionAborted() {
                onMeasurementTakingAbortedCallback.onMeasurementTakingAborted();
            }
        }, "Taking references");
    }

    public void stopMeasurementTaking(boolean bl, OnStopCallback onStopCallback) {
        this.stopMeasurementTaking(null, bl, onStopCallback);
    }

    public void stopMeasurementTaking(BreezeProgressManager breezeProgressManager, final boolean bl, final OnStopCallback onStopCallback) {
        if (!this.measurementStopped) {
            this.measurementStopped = true;
            ProgressAction progressAction = new ProgressAction(this){
                final /* synthetic */ MeasurementTaker this$0;
                {
                    this.this$0 = measurementTaker;
                }

                @Override
                public void runAction() {
                    this.setInfoText("Finishing...");
                    this.this$0.measurements = this.this$0.scanGrabState.stopCapture(this.getProgressManager(), bl);
                    if (this.this$0.measureThread != null) {
                        this.this$0.measureThread.joinOrThrow();
                    }
                    onStopCallback.onMeasurement(this.this$0.measurements);
                    this.this$0.status = MeasurementStatus.Finished;
                }
            };
            if (breezeProgressManager != null) {
                progressAction.setProgressManager(breezeProgressManager);
                progressAction.runAction();
            } else {
                BreezeProgressDialog.startProgress(this.mainPanel.getFrame(), progressAction, "Done capture measurement(s)");
            }
        } else {
            onStopCallback.onMeasurement(this.measurements);
        }
    }

    public ReferenceStatus grabManualWhiteReference(BreezeProgressManager breezeProgressManager, Camera camera) {
        ReferenceStatus referenceStatus = this.whiteRefGrabState.grabWithQualityCheck(this.mainPanel, breezeProgressManager, false, camera);
        this.addTookWhiteReference(camera);
        return referenceStatus;
    }

    public void addTookWhiteReference(Camera camera) {
        this.tookManualWhiteReference.add(camera);
    }

    public ReferenceStatus grabManualDarkReference(BreezeProgressManager breezeProgressManager, Camera camera) {
        this.addTookDarkReference(camera);
        return this.darkRefGrabState.grab(breezeProgressManager, camera);
    }

    public void addTookDarkReference(Camera camera) {
        this.tookManualDarkReference.add(camera);
    }

    public ViewContainer getRuntimePanel() {
        return this.measurementGrabState.getRuntimePanel();
    }

    public RtBasicVariable getCurrentVariable() {
        return this.measurementGrabState.getCurrentVariable();
    }

    public void reset() {
        this.status = MeasurementStatus.Idle;
        this.measurementStopped = false;
        this.measurementGrabState.reset();
    }

    public void cleanUp() {
        SwingUtilities.invokeLater(this.measurementGrabState::cleanUp);
    }

    public int getCurrentFrameCount() {
        return this.scanGrabState.getCurrentFrameCount();
    }

    public ActiveRealtimePanel.ActiveTablePanel getActiveTablePanel() {
        return this.activeTablePanel;
    }

    @Generated
    public BreezeMainPanel getMainPanel() {
        return this.mainPanel;
    }

    @Generated
    public MeasurementStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(MeasurementStatus measurementStatus) {
        this.status = measurementStatus;
    }

    public static enum MeasurementStatus {
        Idle,
        References,
        Grabbing,
        Recorded,
        Finished,
        Done;

    }

    public static interface OnMeasurementTakingFinishedCallback {
        public void onMeasurementTakingFinished();
    }

    public static interface OnMeasurementFrameCallback {
        public void onFrame(int var1);
    }

    public static interface OnMeasurementTakingStartedCallback {
        public void onMeasurementTakingStarted();
    }

    public static interface OnMeasurementTakingAbortedCallback {
        public void onMeasurementTakingAborted();
    }

    public static interface OnStopCallback {
        public void onMeasurement(List<Measurement> var1);
    }
}

