/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.applychanges;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.raw.PredictionDataCache;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.error.ErrorHandler;

public class ApplyChanges {
    public static void applyChanges(BreezeFrame breezeFrame, final List<Measurement> list) {
        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), (List<Measurement>)list);
            }
        }, "Applying changes");
    }

    public static void applyChanges(BreezeProgress breezeProgress, Measurement measurement) {
        ApplyChanges.applyChanges(breezeProgress, Collections.singletonList(measurement));
    }

    public static void applyChanges(BreezeProgress breezeProgress, List<Measurement> list) {
        ApplyChanges.applyChanges(breezeProgress, list, true, true, true, false);
    }

    public static void applyChanges(BreezeProgress breezeProgress, List<Measurement> list, boolean bl) {
        ApplyChanges.applyChanges(breezeProgress, list, true, true, true, bl);
    }

    public static void applyChanges(BreezeProgress breezeProgress, List<Measurement> list, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List<MeasurementList> list2 = MeasurementList.splitMeasurementsIntoSpecificLists(list);
        if (list2.isEmpty()) {
            return;
        }
        if (list2.size() > 1) {
            int n = breezeProgress.setGroupMaximumAndReset(list2.size());
            for (MeasurementList measurementList : list2) {
                ApplyChanges.applyChangesLocal(breezeProgress, measurementList.getMeasurements(), bl, bl2, bl3, bl4);
                breezeProgress.incStepGroup(n);
            }
        } else {
            ApplyChanges.applyChangesLocal(breezeProgress, list, bl, bl2, bl3, bl4);
        }
    }

    public static void applyChangesOnNeeded(BreezeFrame breezeFrame, final List<Measurement> list) {
        BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

            @Override
            public void runAction() throws Exception {
                ApplyChanges.applyChangesOnNeeded(this.getProgressManager(), (List<Measurement>)list);
            }
        }, "Applying changes");
    }

    public static void applyChangesOnNeeded(BreezeProgress breezeProgress, List<Measurement> list) {
        ArrayList<Measurement> arrayList = new ArrayList<Measurement>();
        for (Measurement measurement : list) {
            if (!measurement.applyChangesNeeded()) continue;
            arrayList.add(measurement);
        }
        if (arrayList.size() > 0) {
            ApplyChanges.applyChanges(breezeProgress, arrayList);
        }
    }

    private static void applyChangesLocal(BreezeProgress breezeProgress, List<Measurement> list, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (list.isEmpty()) {
            return;
        }
        boolean bl5 = true;
        ProgressAction progressAction = breezeProgress.getAction();
        if (progressAction != null && progressAction.hasCtrShiftDown()) {
            bl4 = true;
            bl3 = true;
            bl2 = true;
            bl = true;
            bl5 = false;
            for (Measurement entry2 : list) {
                ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(entry2);
            }
        }
        Object object = null;
        Workflow workflow = ApplyChanges.createWorkflow(list, bl || bl2);
        try {
            workflow.functionErrorId = null;
            object = ApplyChanges.createRuntimeWorkflow(breezeProgress, workflow, list);
            for (Measurement measurement : list) {
                DataSetCache.clearParents(measurement);
            }
            System.gc();
            workflow.save();
            TcpManager.getInstance().applyChanges(breezeProgress, (File)object, list, bl, bl2, bl3, bl4, bl5);
            ApplyChanges.reloadMeasurements(breezeProgress, workflow, list);
        }
        catch (TcpManager.CommandErrorException methodException) {
            workflow.functionErrorId = methodException.getFunctionId();
            throw methodException;
        }
        catch (FunctionTreeNodeWithId.MethodException methodException) {
            workflow.functionErrorId = methodException.getNode().getUid();
            throw methodException;
        }
        finally {
            if (object != null) {
                ((File)object).delete();
            }
        }
    }

    public static void reloadMeasurements(BreezeProgress breezeProgress, Workflow workflow, List<Measurement> list) {
        breezeProgress.setInfoText("Reloading measurement(s)");
        breezeProgress.setMaximumAndReset(list.size());
        boolean bl = true;
        for (Measurement measurement : list) {
            measurement.reload(bl);
            breezeProgress.incStep();
            bl = false;
        }
        PredictionDataCache.clearCache();
        workflow.getHighlighedSamples().update(list);
    }

    public static File createRuntimeWorkflow(BreezeProgress breezeProgress, Workflow workflow, List<Measurement> list) {
        File file = FileHelper.createTempFileInWorkspace("xml");
        ApplyChanges.checkLicenseForNode(workflow);
        PPExportBreezeRuntime.export(breezeProgress, workflow, workflow.getName(), "", file, workflow.getSegmentationLevel(), PPExportBreezeRuntime.ObjectProcessing.Sequential, false);
        return file;
    }

    public static Workflow createWorkflow(List<Measurement> list, boolean bl) {
        Workflow workflow;
        Workflow workflow2 = list.get(0).getWorkflow();
        if (bl) {
            workflow = workflow2;
        } else {
            workflow = new WorkflowWithoutIO();
            workflow.getProperties().setRootProperty(workflow2.getProperties().getRootProperty());
        }
        return workflow;
    }

    public static void checkLicenseForNode(Workflow workflow) {
        if (workflow != null) {
            ApplyChanges.checkLicenseForNode(workflow.getRoot());
        }
    }

    public static void checkLicenseForNode(FunctionTreeNode functionTreeNode) {
        if (!functionTreeNode.getFunction().getInfo().validLicense()) {
            throw new ErrorHandler.InformationMessageException("Your license does not support this Analyse Tree", "License");
        }
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            ApplyChanges.checkLicenseForNode(functionTreeNode2);
        }
    }

    public static class MeasurementList
    implements Iterable<Measurement> {
        private final List<Measurement> measurements = new ArrayList<Measurement>();
        private final Workflow workflow;
        private final PixelWidth pixelWidth;
        private final BandCount bandCount;
        private final DataSize dataSize;

        public MeasurementList(Workflow workflow, PixelWidth pixelWidth, BandCount bandCount, DataSize dataSize) {
            this.workflow = workflow;
            this.pixelWidth = pixelWidth;
            this.bandCount = bandCount;
            this.dataSize = dataSize;
        }

        private boolean compatible(Measurement measurement) {
            RawHeader rawHeader = measurement.rawFile().header();
            return measurement.getWorkflow().equals(this.workflow) && rawHeader.pixelWidth().equals(this.pixelWidth) && rawHeader.bandCount().equals(this.bandCount) && rawHeader.dataSize().equals((Object)this.dataSize);
        }

        private void add(Measurement measurement) {
            this.measurements.add(measurement);
        }

        public List<Measurement> getMeasurements() {
            return this.measurements;
        }

        @Override
        public Iterator<Measurement> iterator() {
            return this.measurements.iterator();
        }

        public static List<MeasurementList> splitMeasurementsIntoSpecificLists(List<Measurement> list) {
            ArrayList<MeasurementList> arrayList = new ArrayList<MeasurementList>();
            for (Measurement measurement : list) {
                if (!MeasurementList.canApplyChanges(measurement)) continue;
                MeasurementList measurementList = MeasurementList.getCompatibleList(arrayList, measurement);
                if (measurementList == null) {
                    RawHeader rawHeader = measurement.rawFile().header();
                    measurementList = new MeasurementList(measurement.getWorkflow(), rawHeader.pixelWidth(), rawHeader.bandCount(), rawHeader.dataSize());
                    arrayList.add(measurementList);
                }
                measurementList.add(measurement);
            }
            return arrayList;
        }

        private static boolean canApplyChanges(Measurement measurement) {
            if (measurement.hasData()) {
                return !measurement.noIO();
            }
            return false;
        }

        private static MeasurementList getCompatibleList(List<MeasurementList> list, Measurement measurement) {
            for (MeasurementList measurementList : list) {
                if (!measurementList.compatible(measurement)) continue;
                return measurementList;
            }
            return null;
        }
    }
}

