/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.applychanges;

import java.awt.Rectangle;
import java.awt.Shape;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;

public class ReferenceValueCopyer {
    protected static void copyReferenceValuesFromPreviousToNewSamples(Workflow workflow, RootSample rootSample, RootSample rootSample2) {
        if (rootSample == null) {
            return;
        }
        ReferenceValueCopyer.updateSample(workflow, rootSample, rootSample2, 0);
    }

    private static void updateSample(Workflow workflow, RootSample rootSample, Sample sample, int n) {
        Sample sample2 = ReferenceValueCopyer.getClosest(rootSample, sample, n);
        ReferenceValueCopyer.updateSample(workflow, sample, sample2);
        for (BasicSample basicSample : sample.getChildList()) {
            ReferenceValueCopyer.updateSample(workflow, rootSample, (Sample)basicSample, n + 1);
        }
    }

    public static void updateSample(Workflow workflow, Sample sample, Sample sample2) {
        for (ThingWithName thingWithName : workflow.getPropertyFactors()) {
            ReferenceValueCopyer.updateFactor(sample, sample2, (Factor)thingWithName);
        }
        for (ThingWithName thingWithName : workflow.getCategoryFactors()) {
            ReferenceValueCopyer.updateFactor(sample, sample2, (Factor)thingWithName);
        }
        for (ThingWithName thingWithName : workflow.getIdentifiers()) {
            sample.setID((Identifier)thingWithName, ((Identifier)thingWithName).getTextValue(sample2));
        }
    }

    private static void updateFactor(BasicSample basicSample, BasicSample basicSample2, Factor factor) {
        Float f = basicSample2.getVariableValue(factor);
        SampleValues sampleValues = basicSample.getSampleValues();
        if (sampleValues.isMissing(factor)) {
            if (f != null) {
                sampleValues.setValue(factor, f.floatValue());
            } else {
                sampleValues.removeValue(factor);
            }
        }
    }

    private static Sample getClosest(Sample sample, Sample sample2, int n) {
        Sample sample3 = ReferenceValueCopyer.getClosesRecursive(sample, 0, sample2, n);
        if (sample3 != null) {
            return sample3;
        }
        return sample;
    }

    private static Sample getClosesRecursive(Sample sample, int n, Sample sample2, int n2) {
        if (n < n2 && ReferenceValueCopyer.inside(sample, sample2)) {
            for (BasicSample basicSample : sample.getChildList()) {
                Sample sample3;
                if (!ReferenceValueCopyer.inside((Sample)basicSample, sample2) || (sample3 = ReferenceValueCopyer.getClosesRecursive((Sample)basicSample, n + 1, sample2, n2)) == null) continue;
                return sample3;
            }
            return ReferenceValueCopyer.getClosest(sample, sample2);
        }
        return null;
    }

    private static Sample getClosest(Sample sample, Sample sample2) {
        int n = Integer.MAX_VALUE;
        Sample sample3 = null;
        for (BasicSample basicSample : sample.getChildList()) {
            Sample sample4 = (Sample)basicSample;
            int n2 = ReferenceValueCopyer.distCtr(sample4, sample2);
            if (n2 >= n) continue;
            n = n2;
            if (n == 0) {
                return sample4;
            }
            sample3 = sample4;
        }
        return sample3;
    }

    private static boolean inside(Sample sample, Sample sample2) {
        Shape shape = sample.getPath().getOrCreateGeneralPath();
        Shape shape2 = sample2.getPath().getOrCreateGeneralPath();
        if (shape != null && shape2 != null) {
            Rectangle rectangle = shape.getBounds();
            Rectangle rectangle2 = shape2.getBounds();
            return rectangle.contains(rectangle2.getCenterX(), rectangle2.getCenterY());
        }
        return false;
    }

    private static int distCtr(Sample sample, Sample sample2) {
        Shape shape = sample.getPath().getOrCreateGeneralPath();
        Shape shape2 = sample2.getPath().getOrCreateGeneralPath();
        if (shape != null && shape2 != null) {
            Rectangle rectangle = shape.getBounds();
            Rectangle rectangle2 = shape2.getBounds();
            double d = rectangle.getCenterX() - rectangle2.getCenterX();
            double d2 = rectangle.getCenterY() - rectangle2.getCenterY();
            return (int)(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
        }
        return Short.MAX_VALUE;
    }
}

