/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.applychanges;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import se.prediktera.breeze.backend.measure.applychanges.ReferenceValueCopyer;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.SampleValues;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.sample.RootSample;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;

@Category(value={SlowTestCategory.class})
public class ReferenceValueCopyerTest {
    @Test
    public void testSourceIsNull() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = this.addTestProperty(workflowWithoutIO, "property");
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        RootSample rootSample = new RootSample();
        SampleValues sampleValues = rootSample.getSampleValues();
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, null, rootSample);
        MatcherAssert.assertThat((String)"Property is missing", (Object)sampleValues.getValue(propertyFactor), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Category is missing", (Object)sampleValues.getValue(categoryFactor), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testCopyReferencesValuesNoFactors() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        RootSample rootSample = new RootSample();
        RootSample rootSample2 = new RootSample();
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
    }

    @Test
    public void testCopyReferencesValuesWithFactorAndIdentifier() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = this.addTestProperty(workflowWithoutIO, "property");
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        Identifier identifier = this.addTestIdentifier(workflowWithoutIO);
        RootSample rootSample = new RootSample();
        rootSample.getSampleValues().setValue(propertyFactor, 1.0f);
        rootSample.getSampleValues().setValue(categoryFactor, 2.0f);
        rootSample.setID(identifier, "test");
        RootSample rootSample2 = new RootSample();
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"Property is one", (Object)rootSample2.getSampleValues().getValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"Category is two", (Object)rootSample2.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"Identifier is test", (Object)identifier.getTextValue(rootSample2), (Matcher)CoreMatchers.is((Object)"test"));
    }

    @Test
    public void shouldKeepValuesAsMissingOnCopy() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = this.addTestProperty(workflowWithoutIO, "property");
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        Identifier identifier = this.addTestIdentifier(workflowWithoutIO);
        RootSample rootSample = new RootSample();
        RootSample rootSample2 = new RootSample();
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"Property is zero", (Object)rootSample2.getSampleValues().getValue(propertyFactor), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Category is zero", (Object)rootSample2.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((String)"Identifier is empty", (Object)rootSample2.getIdentifierProperties().getValue(identifier), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldNotReplaceValuesExplicitySet() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = this.addTestProperty(workflowWithoutIO, "property");
        RootSample rootSample = new RootSample();
        rootSample.getSampleValues().setValue(propertyFactor, 1.0f);
        RootSample rootSample2 = new RootSample();
        rootSample2.getSampleValues().setValue(propertyFactor, 2.0f);
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"Property is explicity set to two", (Object)rootSample2.getSampleValues().getValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
    }

    @Test
    public void testCopyReferencesValuesWithFactorAndIdentifierWithSubSamples() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = this.addTestProperty(workflowWithoutIO, "property");
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        Identifier identifier = this.addTestIdentifier(workflowWithoutIO);
        RootSample rootSample = new RootSample();
        rootSample.getSampleValues().setValue(propertyFactor, 1.0f);
        rootSample.getSampleValues().setValue(categoryFactor, 2.0f);
        rootSample.setID(identifier, "test");
        RootSample rootSample2 = new RootSample();
        rootSample2.addChild(new Sample(rootSample2));
        SampleValues sampleValues = rootSample2.getSampleValues();
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"Property is one", (Object)sampleValues.getValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"Category is two", (Object)sampleValues.getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"Identifier is test", (Object)identifier.getTextValue(rootSample2), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((String)"Property sub sample is one", (Object)rootSample2.getChild(0).getVariableValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"Category sub sample is two", (Object)rootSample2.getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"Identifier sub sample is test", (Object)identifier.getTextValue(rootSample2.getChild(0)), (Matcher)CoreMatchers.is((Object)"test"));
    }

    @Test
    public void testCopyReferencesValuesWithFactorAndIdentifierWithClosestSubSamples() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        PropertyFactor propertyFactor = this.addTestProperty(workflowWithoutIO, "property");
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        Identifier identifier = this.addTestIdentifier(workflowWithoutIO);
        RootSample rootSample = new RootSample();
        rootSample.setSelectionPath(new int[][]{{0, 0}, {20, 0}, {20, 20}, {0, 20}});
        rootSample.getSampleValues().setValue(propertyFactor, 1.0f);
        rootSample.getSampleValues().setValue(categoryFactor, 2.0f);
        rootSample.setID(identifier, "test");
        Sample sample = new Sample(rootSample);
        sample.setSelectionPath(new int[][]{{10, 10}});
        rootSample.addChild(sample);
        sample.getSampleValues().setValue(propertyFactor, 10.0f);
        sample.getSampleValues().setValue(categoryFactor, 20.0f);
        sample.setID(identifier, "test2");
        RootSample rootSample2 = new RootSample();
        Sample sample2 = new Sample(rootSample2);
        sample2.setSelectionPath(new int[][]{{10, 10}});
        rootSample2.addChild(sample2);
        SampleValues sampleValues = rootSample2.getSampleValues();
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"Property is one", (Object)sampleValues.getValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"Category is two", (Object)sampleValues.getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"Identifier is test", (Object)identifier.getTextValue(rootSample2), (Matcher)CoreMatchers.is((Object)"test"));
        MatcherAssert.assertThat((String)"Property sub sample is one", (Object)rootSample2.getChild(0).getVariableValue(propertyFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(10.0f)));
        MatcherAssert.assertThat((String)"Category sub sample is one", (Object)rootSample2.getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(20.0f)));
        MatcherAssert.assertThat((String)"Identifier sub sample is one", (Object)identifier.getTextValue(rootSample2.getChild(0)), (Matcher)CoreMatchers.is((Object)"test2"));
    }

    @Test
    public void testCopyReferencesValuesWithFactorClosestSubSubSamples() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        RootSample rootSample = this.createSubSubSamples(categoryFactor);
        RootSample rootSample2 = this.createSubSubSamples(null);
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"1", (Object)rootSample2.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1", (Object)rootSample2.getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:1:1", (Object)rootSample2.getChild(0).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(11.0f)));
        MatcherAssert.assertThat((String)"1:1:2", (Object)rootSample2.getChild(0).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(12.0f)));
        MatcherAssert.assertThat((String)"1:1:3", (Object)rootSample2.getChild(0).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(13.0f)));
        MatcherAssert.assertThat((String)"1:1:4", (Object)rootSample2.getChild(0).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(14.0f)));
        MatcherAssert.assertThat((String)"1:2", (Object)rootSample2.getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"1:2:1", (Object)rootSample2.getChild(1).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(21.0f)));
        MatcherAssert.assertThat((String)"1:2:2", (Object)rootSample2.getChild(1).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(22.0f)));
        MatcherAssert.assertThat((String)"1:2:3", (Object)rootSample2.getChild(1).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(23.0f)));
        MatcherAssert.assertThat((String)"1:2:4", (Object)rootSample2.getChild(1).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(24.0f)));
    }

    @Test
    public void testCopyReferencesValuesWithFactorClosestSubSubSamplesWithOutSomeGrid() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        RootSample rootSample = this.createSubSubSamples(categoryFactor);
        rootSample.getChild(0).getChildList().remove(3);
        rootSample.getChild(0).getChildList().remove(0);
        rootSample.getChild(1).getChildList().remove(2);
        rootSample.getChild(1).getChildList().remove(1);
        RootSample rootSample2 = this.createSubSubSamples(null);
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"1", (Object)rootSample2.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1", (Object)rootSample2.getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:1:1", (Object)rootSample2.getChild(0).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(12.0f)));
        MatcherAssert.assertThat((String)"1:1:2", (Object)rootSample2.getChild(0).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(12.0f)));
        MatcherAssert.assertThat((String)"1:1:3", (Object)rootSample2.getChild(0).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(13.0f)));
        MatcherAssert.assertThat((String)"1:1:4", (Object)rootSample2.getChild(0).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(12.0f)));
        MatcherAssert.assertThat((String)"1:2", (Object)rootSample2.getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"1:2:1", (Object)rootSample2.getChild(1).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(21.0f)));
        MatcherAssert.assertThat((String)"1:2:2", (Object)rootSample2.getChild(1).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(21.0f)));
        MatcherAssert.assertThat((String)"1:2:3", (Object)rootSample2.getChild(1).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(21.0f)));
        MatcherAssert.assertThat((String)"1:2:4", (Object)rootSample2.getChild(1).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(24.0f)));
    }

    @Test
    public void testCopyReferencesValuesWithFactorClosestSubSubSamplesSourceWithoutGrid() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        RootSample rootSample = this.createSubSubSamples(categoryFactor);
        rootSample.getChild(0).getChildList().clear();
        rootSample.getChild(1).getChildList().clear();
        RootSample rootSample2 = this.createSubSubSamples(null);
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"1", (Object)rootSample2.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1", (Object)rootSample2.getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:1:1", (Object)rootSample2.getChild(0).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:1:2", (Object)rootSample2.getChild(0).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:1:3", (Object)rootSample2.getChild(0).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:1:4", (Object)rootSample2.getChild(0).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(1.0f)));
        MatcherAssert.assertThat((String)"1:2", (Object)rootSample2.getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"1:2:1", (Object)rootSample2.getChild(1).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"1:2:2", (Object)rootSample2.getChild(1).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"1:2:3", (Object)rootSample2.getChild(1).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
        MatcherAssert.assertThat((String)"1:2:4", (Object)rootSample2.getChild(1).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(2.0f)));
    }

    @Test
    public void testCopyReferencesValuesWithFactorClosestSubSubSamplesSourceWithoutChilds() {
        WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO();
        CategoryFactor categoryFactor = this.addTestCategory(workflowWithoutIO);
        RootSample rootSample = this.createSubSubSamples(categoryFactor);
        rootSample.getChildList().clear();
        RootSample rootSample2 = this.createSubSubSamples(null);
        ReferenceValueCopyer.copyReferenceValuesFromPreviousToNewSamples(workflowWithoutIO, rootSample, rootSample2);
        MatcherAssert.assertThat((String)"1", (Object)rootSample2.getSampleValues().getValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1", (Object)rootSample2.getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1:1", (Object)rootSample2.getChild(0).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1:2", (Object)rootSample2.getChild(0).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1:3", (Object)rootSample2.getChild(0).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:1:4", (Object)rootSample2.getChild(0).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:2", (Object)rootSample2.getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:2:1", (Object)rootSample2.getChild(1).getChild(0).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:2:2", (Object)rootSample2.getChild(1).getChild(1).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:2:3", (Object)rootSample2.getChild(1).getChild(2).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"1:2:4", (Object)rootSample2.getChild(1).getChild(3).getVariableValue(categoryFactor), (Matcher)CoreMatchers.is((Object)Float.valueOf(0.0f)));
    }

    private RootSample createSubSubSamples(CategoryFactor categoryFactor) {
        RootSample rootSample = new RootSample();
        rootSample.setSelectionPath(new int[][]{{0, 0}, {10, 0}, {10, 20}, {0, 20}});
        rootSample.getSampleValues().setValue(categoryFactor, 0.0f);
        Sample sample = this.addSubSample(categoryFactor, 1, rootSample, new int[][]{{0, 0}, {10, 0}, {10, 10}, {0, 10}});
        this.addSubSample(categoryFactor, 11, sample, new int[][]{{0, 0}, {5, 0}, {5, 5}, {0, 5}});
        this.addSubSample(categoryFactor, 12, sample, new int[][]{{5, 0}, {10, 0}, {10, 5}, {5, 5}});
        this.addSubSample(categoryFactor, 13, sample, new int[][]{{0, 5}, {5, 5}, {5, 10}, {0, 10}});
        this.addSubSample(categoryFactor, 14, sample, new int[][]{{5, 5}, {10, 5}, {10, 10}, {5, 10}});
        Sample sample2 = this.addSubSample(categoryFactor, 2, rootSample, new int[][]{{0, 10}, {10, 10}, {10, 20}, {0, 20}});
        this.addSubSample(categoryFactor, 21, sample2, new int[][]{{0, 10}, {5, 10}, {5, 15}, {0, 15}});
        this.addSubSample(categoryFactor, 22, sample2, new int[][]{{5, 10}, {10, 10}, {10, 15}, {5, 15}});
        this.addSubSample(categoryFactor, 23, sample2, new int[][]{{0, 15}, {5, 15}, {5, 20}, {0, 20}});
        this.addSubSample(categoryFactor, 24, sample2, new int[][]{{5, 15}, {10, 15}, {10, 20}, {5, 20}});
        return rootSample;
    }

    private Sample addSubSample(CategoryFactor categoryFactor, int n, Sample sample, int[][] nArray) {
        Sample sample2 = new Sample(sample);
        sample2.setSelectionPath(nArray);
        sample.addChild(sample2);
        if (categoryFactor != null) {
            sample2.getSampleValues().setValue(categoryFactor, n);
        }
        return sample2;
    }

    private Identifier addTestIdentifier(Workflow workflow) {
        Identifier identifier = new Identifier(EntryMainHelper.getUniqueName("Name", workflow.getIdentifiers().getList()));
        workflow.getIdentifiers().add(identifier);
        return identifier;
    }

    private CategoryFactor addTestCategory(Workflow workflow) {
        CategoryFactor categoryFactor = new CategoryFactor("Category");
        categoryFactor.addClass("A");
        categoryFactor.addClass("B");
        workflow.getCategoryFactors().add(categoryFactor);
        return categoryFactor;
    }

    private PropertyFactor addTestProperty(Workflow workflow, String string) {
        PropertyFactor propertyFactor = new PropertyFactor(string);
        workflow.getPropertyFactors().add(propertyFactor);
        workflow.getPropertyFactors().add(propertyFactor);
        return propertyFactor;
    }
}

