/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.settings;

import se.prediktera.breeze.backend.measure.settings.MeasureSaveSettings;
import se.prediktera.breeze.backend.measure.settings.MoverMeasureSettings;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.common.hardware.settings.MeasureLengthSettings;
import se.prediktera.breeze.common.util.type.LengthValue;
import se.prediktera.breeze.hardware.HardwareRegistry;

public class MeasureSettings {
    private final MoverMeasureSettings sampleMoverSettings;
    private final MeasureSaveSettings saveSettings;
    private final ReferenceSettings referenceSettings;
    private final MeasureLengthSettings lengthSettings;

    public MeasureSettings(MoverMeasureSettings moverMeasureSettings, MeasureLengthSettings measureLengthSettings, MeasureSaveSettings measureSaveSettings, ReferenceSettings referenceSettings) {
        this.sampleMoverSettings = moverMeasureSettings;
        this.lengthSettings = measureLengthSettings;
        this.saveSettings = measureSaveSettings;
        this.referenceSettings = referenceSettings;
    }

    public MoverMeasureSettings sampleMoverSettings() {
        return this.sampleMoverSettings;
    }

    public MeasureLengthSettings lengthSettings() {
        return this.lengthSettings;
    }

    public LengthValue getScanLength() {
        LengthValue lengthValue = this.lengthSettings().sampleMoverScanLength();
        if (HardwareRegistry.hasMultiModeCameras()) {
            return lengthValue.withOffset(HardwareRegistry.getInstance().getMaxOffset());
        }
        return lengthValue;
    }

    public MeasureSaveSettings saveSettings() {
        return this.saveSettings;
    }

    public ReferenceSettings referenceSettings() {
        return this.referenceSettings;
    }
}

