/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.settings;

import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.measure.ReferenceStatus;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.camera.StateCamera;

public class ReferenceSettings {
    private final List<Camera> cameras;
    private final SampleMover mover;
    private final ReferenceAction defaultDarkCaptureMode;
    private final ReferenceAction defaultWhiteCaptureMode;
    private final HashMap<Camera, ReferenceInfo> cameraReferenceInfo = new HashMap();

    public ReferenceSettings(List<Camera> list, SampleMover sampleMover, ReferenceAction referenceAction, ReferenceAction referenceAction2) {
        this.cameras = list;
        this.mover = sampleMover;
        this.defaultDarkCaptureMode = referenceAction;
        this.defaultWhiteCaptureMode = referenceAction2;
        this.updateReferenceInfo();
    }

    public void updateReferenceInfo() {
        this.cameraReferenceInfo.clear();
        boolean bl = this.cameras.stream().anyMatch(Camera::useReferencesWhenRecordingWithThisCamera);
        for (Camera camera : this.cameras) {
            this.cameraReferenceInfo.put(camera, new ReferenceInfo(camera, this.defaultDarkCaptureMode, this.defaultWhiteCaptureMode, bl));
        }
    }

    public boolean useAnyReferences() {
        for (Camera camera : this.cameras) {
            if (!camera.useReferencesWhenRecordingWithThisCamera()) continue;
            return true;
        }
        return false;
    }

    public boolean isCamerasConnected() {
        return this.cameras.stream().allMatch(Hardware::isConnected);
    }

    public boolean isHardwareConnected() {
        if (this.mover != null && !this.mover.isConnected()) {
            return false;
        }
        return this.isCamerasConnected();
    }

    private static boolean canTakeAutomaticWhiteReference(Camera camera, SampleMover sampleMover) {
        if (camera instanceof StateCamera) {
            StateCamera stateCamera = (StateCamera)camera;
            return stateCamera.hasWhiteReference();
        }
        if (sampleMover != null) {
            return sampleMover.hasWhiteRefState();
        }
        return false;
    }

    private static boolean canTakeAutomaticDarkReference(Camera camera) {
        if (camera != null) {
            return camera.hasShutter();
        }
        return false;
    }

    public boolean shouldTakeAnyReferencesManually() {
        for (Camera camera : this.cameras) {
            if (!this.shouldTakeWhiteReferenceManually(camera) && !this.shouldTakeDarkReferenceManually(camera)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldTakeWhiteReferenceManually(Camera camera) {
        return (!ReferenceSettings.canTakeAutomaticWhiteReference(camera, this.mover) && this.shouldTakeWhiteReference(camera) || this.shouldCaptureNewWhiteStoredReference(camera)) && camera.useReferencesWhenRecordingWithThisCamera();
    }

    public boolean shouldCaptureNewWhiteStoredReference() {
        for (Camera camera : this.cameras) {
            if (!this.shouldCaptureNewWhiteStoredReference(camera)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldCaptureNewWhiteStoredReference(Camera camera) {
        return this.cameraReferenceInfo.get(camera).shouldCaptureNewWhenStoredWhite();
    }

    public boolean shouldTakeDarkReferenceManually(Camera camera) {
        return !ReferenceSettings.canTakeAutomaticDarkReference(camera) && this.shouldTakeDarkReference(camera);
    }

    public boolean shouldTakeDarkReferenceAutomatically(boolean bl) {
        for (Camera camera : this.cameras) {
            if (!StateCamera.showTakeReferenceInWizard(camera, bl) || !this.shouldTakeDarkReferenceAutomatically(camera)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldTakeDarkReferenceAutomatically(Camera camera) {
        return ReferenceSettings.canTakeAutomaticDarkReference(camera) && this.shouldTakeDarkReference(camera);
    }

    public boolean canTakeDarkReferenceAutomatically() {
        for (Camera camera : this.cameras) {
            if (!ReferenceSettings.canTakeAutomaticDarkReference(camera)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDarkReference(Camera camera) {
        return this.cameraReferenceInfo.get((Object)camera).hasDark;
    }

    public boolean shouldTakeDarkReference(Camera camera) {
        return this.cameraReferenceInfo.get((Object)camera).actionDark.record();
    }

    public boolean shouldCaptureNewDarkStoredReference(Camera camera) {
        return this.cameraReferenceInfo.get(camera).shouldCaptureNewWhenStoredDark();
    }

    public boolean shouldTakeWhiteReferenceAutomatically(boolean bl) {
        for (Camera camera : this.cameras) {
            if (!StateCamera.showTakeReferenceInWizard(camera, bl) || !ReferenceSettings.canTakeAutomaticWhiteReference(camera, this.mover) || !this.shouldTakeWhiteReference(camera)) continue;
            return true;
        }
        return false;
    }

    public boolean canTakeWhiteReferenceAutomatically() {
        for (Camera camera : this.cameras) {
            if (!ReferenceSettings.canTakeAutomaticWhiteReference(camera, this.mover)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWhiteReference(Camera camera) {
        return this.cameraReferenceInfo.get((Object)camera).hasWhite;
    }

    public boolean shouldTakeWhiteReference(Camera camera) {
        return this.cameraReferenceInfo.get((Object)camera).actionWhite.record();
    }

    public boolean useReferences(Camera camera) {
        return camera.useReferencesWhenRecordingWithThisCamera();
    }

    public RtFramePredictor.ReferenceType referenceType(Camera camera) {
        return this.cameraReferenceInfo.get(camera).getReferenceType();
    }

    public ReferenceStatus takeDarkReference(BreezeProgress breezeProgress, Camera camera) {
        return ReferenceHelper.takeDarkReference(breezeProgress, camera);
    }

    public ReferenceStatus takeWhiteReference(BreezeProgress breezeProgress, Camera camera, boolean bl) {
        return ReferenceHelper.takeWhiteReference(breezeProgress, camera, this.mover, ReferenceSettings.canTakeAutomaticWhiteReference(camera, this.mover));
    }

    public boolean shouldTakeAllReferences(Camera camera) {
        return this.shouldTakeWhiteReference(camera) && this.shouldTakeDarkReference(camera);
    }

    public void setActionDark(ReferenceAction referenceAction) {
        for (Camera camera : this.cameras) {
            this.cameraReferenceInfo.get((Object)camera).actionDark = referenceAction;
        }
    }

    public void setActionWhite(ReferenceAction referenceAction) {
        for (Camera camera : this.cameras) {
            this.cameraReferenceInfo.get((Object)camera).actionWhite = referenceAction;
        }
    }

    public Time getDarkReferenceValidTime() {
        return new Time.Seconds((double)ReferenceHelper.getDarkReferenceValidTime(this.cameras.getFirst()));
    }

    public Time getWhiteReferenceValidTime() {
        return new Time.Seconds((double)ReferenceHelper.getWhiteReferenceValidTime(this.cameras.getFirst()));
    }

    public ReferenceAction getDarkAction() {
        for (Camera camera : this.cameras) {
            if (!this.cameraReferenceInfo.get((Object)camera).actionDark.using()) continue;
            return this.cameraReferenceInfo.get((Object)camera).actionDark;
        }
        return ReferenceAction.Disable;
    }

    public ReferenceAction getWhiteAction() {
        for (Camera camera : this.cameras) {
            if (!this.cameraReferenceInfo.get((Object)camera).actionWhite.using()) continue;
            return this.cameraReferenceInfo.get((Object)camera).actionWhite;
        }
        return ReferenceAction.Disable;
    }

    public SpectralReference.DarkReference getDarkReference() {
        return ReferenceHelper.getDarkReference(this.cameras.getFirst());
    }

    public SpectralReference.WhiteReference getWhiteReference() {
        return ReferenceHelper.getWhiteReference(this.cameras.getFirst());
    }

    public List<Camera> getCameras() {
        return this.cameras;
    }

    public static ReferenceSettings FromPropertiesCaptureMode(List<Camera> list, SampleMover sampleMover) {
        return new ReferenceSettings(list, sampleMover, BreezeProperties.getInstance().getDarkReferenceCaptureMode(), BreezeProperties.getInstance().getWhiteReferenceCaptureMode());
    }

    public static enum ReferenceAction {
        CaptureNew("Capture new"),
        UseStored("Use stored"),
        Disable("Disabled"),
        UseStoredTestScan("Use stored for Test scan");

        private final String displayName;

        public boolean using() {
            return !this.equals((Object)Disable);
        }

        public boolean capture() {
            return this.equals((Object)CaptureNew) || this.equals((Object)UseStored);
        }

        public boolean record() {
            return this.equals((Object)CaptureNew);
        }

        private ReferenceAction(String string2) {
            this.displayName = string2;
        }

        public static ReferenceAction getAction(Object object) {
            String string = object.toString();
            if (string.startsWith("Capture")) {
                return CaptureNew;
            }
            if (string.startsWith("Use")) {
                return UseStored;
            }
            return Disable;
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }

    private static class ReferenceInfo {
        private final Camera camera;
        private final ReferenceAction darkCaptureMode;
        private final ReferenceAction whiteCaptureMode;
        public boolean hasDark;
        public ReferenceAction actionDark = ReferenceAction.Disable;
        public boolean hasWhite;
        public ReferenceAction actionWhite = ReferenceAction.Disable;

        public ReferenceInfo(Camera camera, ReferenceAction referenceAction, ReferenceAction referenceAction2, boolean bl) {
            this.camera = camera;
            this.darkCaptureMode = referenceAction;
            this.whiteCaptureMode = referenceAction2;
            if (bl || camera.useReferencesWhenRecordingWithThisCamera()) {
                this.hasDark = ReferenceHelper.HasDarkReference(camera);
                this.actionDark = referenceAction;
                if (this.shouldCaptureNewDark()) {
                    this.actionDark = ReferenceAction.CaptureNew;
                }
                this.hasWhite = ReferenceHelper.HasWhiteReference(camera);
                this.actionWhite = referenceAction2;
                if (this.shouldCaptureNewWhite()) {
                    this.actionWhite = ReferenceAction.CaptureNew;
                }
            }
        }

        private boolean shouldCaptureNewDark() {
            return this.actionDark.capture() && (!this.hasDark || !ReferenceHelper.isDarkReferenceValid(this.camera));
        }

        private boolean shouldCaptureNewWhite() {
            return this.actionWhite.capture() && (!this.hasWhite || !ReferenceHelper.isWhiteReferenceValid(this.camera));
        }

        public boolean shouldCaptureNewWhenStoredDark() {
            if (this.shouldCaptureNewDark()) {
                return this.darkCaptureMode == ReferenceAction.UseStored;
            }
            return false;
        }

        public boolean shouldCaptureNewWhenStoredWhite() {
            if (this.shouldCaptureNewWhite()) {
                return this.whiteCaptureMode == ReferenceAction.UseStored;
            }
            return false;
        }

        public RtFramePredictor.ReferenceType getReferenceType() {
            if (this.actionDark.using() && this.actionWhite.using()) {
                return RtFramePredictor.ReferenceType.Both;
            }
            if (this.actionDark.using()) {
                return RtFramePredictor.ReferenceType.OnlyDark;
            }
            if (this.actionWhite.using()) {
                return RtFramePredictor.ReferenceType.OnlyWhite;
            }
            return RtFramePredictor.ReferenceType.None;
        }
    }
}

