/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.state;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.backend.measure.settings.MeasureSaveSettings;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.backend.measure.settings.ReferenceSettings;
import se.prediktera.breeze.backend.measure.state.TcpPredictSession;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.SaturationDescriptor;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtRenderModeVariable;
import se.prediktera.breeze.common.util.AverageFrame;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.entry.application.RuntimeMeasurement;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimePredictionMode;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.client.select.active.ActiveRealtimePanel;
import se.prediktera.breeze.frontend.client.workflow.RuntimeWorkflowTable;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportBreezeRuntime;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.breeze.recorder.RenderMode;
import se.prediktera.breeze.util.raw.HySpexHeader;
import se.prediktera.breeze.util.raw.HySpexHelper;
import se.prediktera.map.common.error.Logg;

public class MeasurementGrabState {
    private final Workflow workflow;
    private final Group group;
    private final MeasureSettings measureSettings;
    private final ViewContainer viewContainer = new ViewContainer();
    private final BreezeMainPanel mainPanel;
    private final HashMap<Integer, ActiveRealtimePanel> runtimePanels = new HashMap();
    private boolean useSamplesFromMeasurement;
    private final ConcurrentLinkedQueue<Measurement> addedMeasurements = new ConcurrentLinkedQueue();
    private final Camera.TransformAlgorithm transformAlgorithm;
    private final boolean realignBackup;
    private final String realignmentOptions;
    private final String rotateOption;
    private final boolean includeAnalyseTree;
    private RtBasicVariable currentVariable;
    public final List<FrameCount> frameCounts = new ArrayList<FrameCount>();
    private final ActiveRealtimePanel primaryRuntimePanel;
    private final BreezeRecorder.RecordMode recordMode;
    private final ActiveRealtimePanel.ActiveTablePanel activeTablePanel;
    private final Camera.MultiCameraMode mode;

    public MeasurementGrabState(BreezeMainPanel breezeMainPanel, MeasurementTaker measurementTaker, List<Camera> list, Group group, MeasureSettings measureSettings, BreezeRecorder.RecordMode recordMode, RtBasicVariable rtBasicVariable, Camera.MultiCameraMode multiCameraMode) {
        this.mainPanel = breezeMainPanel;
        this.group = group;
        this.measureSettings = measureSettings;
        this.recordMode = recordMode;
        this.currentVariable = rtBasicVariable;
        this.mode = multiCameraMode;
        this.workflow = group.getParent();
        boolean bl = this.workflow.getVisualisationDirection().equalsIgnoreCase("vertical");
        Camera camera = list.getFirst();
        this.primaryRuntimePanel = this.createRuntimePanel(breezeMainPanel, measurementTaker, this.workflow, recordMode, camera, rtBasicVariable);
        this.viewContainer.addViewPanel((Component)((Object)this.primaryRuntimePanel), 0, 0);
        if (list.size() > 1) {
            this.realignBackup = BreezeProperties.getInstance().isMultiCameraBackup();
            if (multiCameraMode.isScale()) {
                this.transformAlgorithm = BreezeProperties.getInstance().getMultiCameraRealignAlgorithm();
                String string = Camera.TransformAlgorithm.getAlgorithmOptions(this.transformAlgorithm);
                this.realignmentOptions = string.isEmpty() ? null : string;
                this.rotateOption = this.transformAlgorithm.equals((Object)Camera.TransformAlgorithm.None) ? "" : BreezeProperties.getInstance().getMultiCameraRotate();
            } else {
                this.transformAlgorithm = Camera.TransformAlgorithm.None;
                this.realignmentOptions = null;
                this.rotateOption = "";
            }
            if (multiCameraMode.equals((Object)Camera.MultiCameraMode.SeparateFiles)) {
                for (int i = 1; i < list.size(); ++i) {
                    this.viewContainer.addViewPanel((Component)((Object)this.createRuntimePanel(breezeMainPanel, measurementTaker, this.workflow, recordMode, list.get(i), rtBasicVariable)), bl ? i : 0, bl ? 0 : i);
                }
            }
            this.includeAnalyseTree = this.transformAlgorithm.equals((Object)Camera.TransformAlgorithm.None);
        } else {
            this.transformAlgorithm = Camera.TransformAlgorithm.None;
            this.realignmentOptions = null;
            this.realignBackup = false;
            this.rotateOption = "";
            this.includeAnalyseTree = true;
        }
        this.activeTablePanel = measurementTaker.getActiveTablePanel();
    }

    private ActiveRealtimePanel createRuntimePanel(BreezeMainPanel breezeMainPanel, MeasurementTaker measurementTaker, Workflow workflow, BreezeRecorder.RecordMode recordMode, Camera camera, RtBasicVariable rtBasicVariable) {
        ActiveRealtimePanel activeRealtimePanel = new ActiveRealtimePanel(breezeMainPanel, measurementTaker, workflow, camera, null, recordMode, rtBasicVariable);
        this.runtimePanels.put(camera.getId(), activeRealtimePanel);
        return activeRealtimePanel;
    }

    public RuntimeWorkflow loadWorkflow(MeasurementCallback measurementCallback, List<Camera> list, BreezeProgressManager breezeProgressManager) {
        Logg.trace((String)"enter", (Object[])new Object[0]);
        this.frameCounts.clear();
        for (Camera object2 : list) {
            this.frameCounts.add(this.measureSettings.lengthSettings().totalMeasurementLengthFrameCount(object2));
        }
        File file = FileHelper.createTempFileInWorkspace("xml");
        RuntimePredictionMode runtimePredictionMode = new RuntimePredictionMode(this.workflow);
        RtPredictionMode rtPredictionMode = new RtPredictionMode(RtPredictionMode.PredictionMode.Rgb);
        RtPredictionMode.PredictionModeSetup predictionModeSetup = rtPredictionMode.getPredictionSetup();
        predictionModeSetup.setChunks(runtimePredictionMode.getPredictionSetup().getChunks());
        ((RtPredictionMode.RgbModeSetup)predictionModeSetup).setBlending(BreezeProperties.getInstance().isBlend());
        PPExportBreezeRuntime.export(breezeProgressManager, this.workflow, this.workflow.getName(), "", file, rtPredictionMode, this.workflow.getSegmentationLevel(), this.workflow.isParallelMeasurementSegmentation(), this.workflow.isIncludeChildObjects(), false, null, this.includeAnalyseTree, false, this.frameCounts);
        MeasureSaveSettings measureSaveSettings = this.measureSettings.saveSettings();
        File file2 = measureSaveSettings.shouldSaveMeasurements() ? this.group.getFolder() : null;
        int n = BreezeProperties.getInstance().getChunks();
        Camera camera2 = list.getFirst();
        breezeProgressManager.setInfoText("Loading workflow data");
        breezeProgressManager.setIndeterminate(true);
        boolean bl = list.stream().anyMatch(Camera::useReferencesWhenRecordingWithThisCamera);
        Optional<RtFramePredictor.ReferenceType> optional = list.stream().map(camera -> this.measureSettings.referenceSettings().referenceType((Camera)camera)).filter(referenceType -> referenceType != RtFramePredictor.ReferenceType.None).findFirst();
        RuntimeWorkflow runtimeWorkflow = TcpManager.getInstance().loadWorkflow(breezeProgressManager, file, camera2, bl, optional.orElse(RtFramePredictor.ReferenceType.None), file2, measureSaveSettings.getMeasurementName(this.group), measureSaveSettings.shouldSaveRawData(), this.frameCounts, measureSaveSettings.isCropMeasurement(), BreezeProperties.getInstance().getLoginUser().toString(), n, true, this.mode);
        runtimeWorkflow.setXmlFile(file);
        RtBasicVariable rtBasicVariable = this.currentVariable == null ? this.getDefaultVariable(this.workflow) : this.currentVariable;
        boolean bl2 = this.useSamplesFromMeasurement = file2 != null;
        if (this.runtimePanels.size() == 1) {
            FrameCount i = this.frameCounts.getFirst();
            this.primaryRuntimePanel.setApplication(runtimeWorkflow, rtBasicVariable, i);
            new TcpPredictSession(this.primaryRuntimePanel, i, measurementCallback, runtimeWorkflow, BreezeProperties.getInstance().getDataStreamPort());
        } else {
            for (int i = 0; i < list.size(); ++i) {
                ActiveRealtimePanel activeRealtimePanel = this.runtimePanels.get(list.get(i).getId());
                FrameCount frameCount = this.frameCounts.get(i);
                activeRealtimePanel.setApplication(runtimeWorkflow, rtBasicVariable, frameCount);
                new TcpPredictSession(activeRealtimePanel, frameCount, measurementCallback, runtimeWorkflow, BreezeProperties.getInstance().getDataStreamPort() + i);
            }
        }
        this.activeTablePanel.setApplication(runtimeWorkflow, new RuntimeWorkflowTable.RTableConfig(this.measureSettings.saveSettings().shouldSaveMeasurements(), this.runtimePanels.size() > 1));
        this.activeTablePanel.start();
        TcpManager.getInstance().setListener(runtimeEvent -> {
            if (runtimeEvent.isObject()) {
                RuntimeObjectFormat.DescriptorValues descriptorValues = RuntimeObjectFormat.DescriptorValues.fromJSON(runtimeEvent.getMessage());
                ActiveRealtimePanel activeRealtimePanel = this.runtimePanels.get(descriptorValues.getCameraId());
                if (this.useSamplesFromMeasurement) {
                    activeRealtimePanel.addTrack(descriptorValues);
                } else {
                    activeRealtimePanel.addObject(descriptorValues);
                }
                this.activeTablePanel.needUpdate();
            } else if (runtimeEvent.isMeasurement()) {
                if (this.useSamplesFromMeasurement) {
                    RuntimeMeasurement runtimeMeasurement = RuntimeMeasurement.fromJSON(runtimeEvent.getMessage());
                    File file = new File(this.group.getFolder(), runtimeMeasurement.getName());
                    if (file.exists()) {
                        Measurement measurement = this.group.getMeasurement(file.getName());
                        if (measurement == null) {
                            measurement = new Measurement(file, this.group);
                            this.group.addChild(measurement);
                            this.addedMeasurements.add(measurement);
                        }
                        for (Sample sample : measurement.getSamples(this.group.getParent().getSegmentationLevel())) {
                            this.primaryRuntimePanel.addObject(new RuntimeObjectFormat.DescriptorValues(sample));
                        }
                        this.runtimePanels.get(runtimeMeasurement.getCameraId()).setMeasurement(measurement);
                    }
                }
            } else if (runtimeEvent.isError()) {
                ToastHandler.getInstance().showToast(runtimeEvent.getMessageError(), Toast.IconType.Error);
            } else if (runtimeEvent.isWarning()) {
                ToastHandler.getInstance().showToast(runtimeEvent.getMessageError(), Toast.IconType.Warning);
            } else {
                Logg.trace((String)("Unknown event: " + String.valueOf(runtimeEvent)), (Object[])new Object[0]);
            }
        });
        return runtimeWorkflow;
    }

    public ViewContainer getRuntimePanel() {
        return this.viewContainer;
    }

    /*
     * WARNING - void declaration
     */
    public List<Measurement> stopCapture(BreezeProgressManager breezeProgressManager) {
        void var3_10;
        Object object;
        Object object2;
        for (ActiveRealtimePanel object32 : this.runtimePanels.values()) {
            object32.stop();
        }
        breezeProgressManager.setInfoText("Finalizing measurements");
        try {
            TcpManager.getInstance().stopPredict(breezeProgressManager);
        }
        catch (Exception exception) {
            Logg.debug((String)"Error finalizing measurements", (Object[])new Object[]{exception});
        }
        ThreadUtil.sleep(200L);
        if (WorkspaceManager.GUITEST) {
            Logg.debug((String)("Added measurements: " + this.addedMeasurements.size()), (Object[])new Object[0]);
        }
        this.activeTablePanel.stop();
        if (this.recordMode.equals((Object)BreezeRecorder.RecordMode.Measurement)) {
            for (Measurement measurement : this.addedMeasurements) {
                ReferenceSettings referenceSettings;
                Camera camera;
                object2 = measurement.rawFile();
                if (object2 == null) continue;
                object = object2.header().getDescriptionData();
                if (object != null && (camera = HardwareRegistry.getInstance().getCamera(((RawHeader.DescriptionData)object).cameraId)) != null && camera.takeDarkAfterMeasurement() && (referenceSettings = this.measureSettings.referenceSettings()).shouldTakeDarkReference(camera)) {
                    referenceSettings.takeDarkReference(breezeProgressManager, camera);
                    SpectralReference.DarkReference darkReference = ReferenceHelper.getDarkReference(camera);
                    if (darkReference != null && HySpexHeader.isHySpexFile(object2.file())) {
                        HySpexHeader hySpexHeader = new HySpexHeader(object2.file());
                        hySpexHeader.backgroundLast = HySpexHelper.createBackground(new AverageFrame(darkReference.readFrames()));
                        hySpexHeader.replace();
                    }
                }
                measurement.clearFilesCache();
            }
        }
        if (!this.includeAnalyseTree && ThreadUtil.awaitAndReturn(() -> !this.addedMeasurements.isEmpty(), Time.FiveSeconds)) {
            List list = this.addedMeasurements.stream().toList();
            if (!this.transformAlgorithm.equals((Object)Camera.TransformAlgorithm.None)) {
                TcpManager.getInstance().transformData(breezeProgressManager, list, this.transformAlgorithm, this.realignBackup, this.realignmentOptions, this.rotateOption);
                ThumbnailManager.deleteAndRemoveMeasurementImagesFromCache(list);
            }
            ApplyChanges.applyChanges(breezeProgressManager, list, true, true, true, true);
        }
        TcpManager.getInstance().setListener(null);
        breezeProgressManager.setInfoText("Loading measurements");
        this.group.syncToExisting(breezeProgressManager);
        int n = this.group.getChildList().size();
        Object var3_8 = null;
        if (n > 0) {
            Measurement measurement = this.group.getChildList().get(n - 1);
            object = this.mainPanel;
            if (object instanceof EntryMainItemPanel) {
                object2 = (EntryMainItemPanel)object;
                ((EntryMainPanel)object2).getEntryList().sort();
                ((EntryMainPanel)object2).setDirty(true);
            }
            this.measureSettings.saveSettings().onMeasurementCallback(measurement);
        }
        if (this.useSamplesFromMeasurement) {
            object2 = new ArrayList();
            for (ActiveRealtimePanel activeRealtimePanel : this.runtimePanels.values()) {
                ((ArrayList)object2).add(activeRealtimePanel.getMeasurement());
            }
            return object2;
        }
        return Collections.singletonList(var3_10);
    }

    public void reset() {
        this.currentVariable = this.getCurrentVariable();
        for (ActiveRealtimePanel activeRealtimePanel : this.runtimePanels.values()) {
            activeRealtimePanel.reset();
        }
        ActiveRealtimePanel.InReRenderMode = false;
    }

    public void cleanUp() {
        for (ActiveRealtimePanel activeRealtimePanel : this.runtimePanels.values()) {
            activeRealtimePanel.cleanUp();
        }
    }

    public RtBasicVariable getCurrentVariable() {
        return this.primaryRuntimePanel.getSelectedVariable();
    }

    private RtBasicVariable getDefaultVariable(Workflow workflow) {
        if (this.recordMode.equals((Object)BreezeRecorder.RecordMode.TestScan)) {
            return new RtRenderModeVariable(RenderMode.Rgb);
        }
        List<DescriptorTreeNode> list = workflow.getSegmentationLevelDescriptorNodes(true);
        boolean bl = this.recordMode.equals((Object)BreezeRecorder.RecordMode.Play);
        for (DescriptorTreeNode descriptorTreeNode : list) {
            Factor factor;
            BasicAnalyse basicAnalyse = descriptorTreeNode.getAnalyse();
            if (!(descriptorTreeNode.getFunction() instanceof SaturationDescriptor) && (!bl || basicAnalyse == null) || (factor = basicAnalyse.getFactor()) == null) continue;
            return new RtBasicVariable(null, factor.getName() + ":" + factor.getUid(), 0.0f, 1.0f);
        }
        return new RtRenderModeVariable(RenderMode.Rgb);
    }

    @Generated
    public ActiveRealtimePanel.ActiveTablePanel getActiveTablePanel() {
        return this.activeTablePanel;
    }

    public static interface MeasurementCallback {
        public void onFinish();

        public void onFrame(int var1);
    }
}

