/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.state;

import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.settings.MeasureSettings;
import se.prediktera.breeze.backend.measure.state.MeasurementGrabState;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.SampleMover;
import se.prediktera.breeze.hardware.samplemover.tray.RemoteSampleMover;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.error.Logg;

public class ScanGrabState {
    private final Group group;
    private final MeasureSettings measureSettings;
    private final MeasurementGrabState measurementGrabState;
    private int currentFrameCount;

    public ScanGrabState(Group group, MeasureSettings measureSettings, MeasurementGrabState measurementGrabState) {
        this.group = group;
        this.measureSettings = measureSettings;
        this.measurementGrabState = measurementGrabState;
    }

    public RuntimeWorkflow loadWorkflow(List<Camera> list, final MeasurementTaker.OnMeasurementTakingFinishedCallback onMeasurementTakingFinishedCallback, final MeasurementTaker.OnMeasurementFrameCallback onMeasurementFrameCallback, BreezeProgressManager breezeProgressManager) {
        return this.measurementGrabState.loadWorkflow(new MeasurementGrabState.MeasurementCallback(){
            final /* synthetic */ ScanGrabState this$0;
            {
                this.this$0 = scanGrabState;
            }

            @Override
            public void onFrame(int n) {
                this.this$0.currentFrameCount = n;
                onMeasurementFrameCallback.onFrame(n);
            }

            @Override
            public void onFinish() {
                onMeasurementTakingFinishedCallback.onMeasurementTakingFinished();
            }
        }, list, breezeProgressManager);
    }

    public void grab(List<Camera> list) {
        Logg.trace((String)"enter", (Object[])new Object[0]);
        SampleMover sampleMover = this.measureSettings.sampleMoverSettings().sampleMover();
        if (sampleMover instanceof RemoteSampleMover) {
            RemoteSampleMover remoteSampleMover = (RemoteSampleMover)sampleMover;
            SampleMover.ScanMode scanMode = this.measureSettings.sampleMoverSettings().sampleMoverScanMode();
            if (scanMode.equals((Object)SampleMover.ScanMode.WhiteReferenceOnly)) {
                remoteSampleMover.scanWhiteReference(null, list.getFirst(), scanMode);
            } else {
                remoteSampleMover.remoteScan(this.measureSettings.getScanLength(), scanMode, list, this.measurementGrabState.frameCounts, true, list.size() > 1 && HardwareRegistry.hasMultiModeCameras());
                this.measureSettings.sampleMoverSettings().performSampleMoverScanFinish();
            }
        } else {
            TcpManager.getInstance().startPredict(this.measurementGrabState.frameCounts, true);
        }
    }

    public List<Measurement> stopCapture(BreezeProgressManager breezeProgressManager, boolean bl) {
        List<Measurement> list = this.measurementGrabState.stopCapture(breezeProgressManager);
        SampleMover sampleMover = this.measureSettings.sampleMoverSettings().sampleMover();
        if (sampleMover instanceof RemoteSampleMover) {
            RemoteSampleMover remoteSampleMover = (RemoteSampleMover)sampleMover;
            remoteSampleMover.stopDemo();
        }
        DataSetCache.clearRecursive(this.group);
        DataSetCache.clear(this.group.getParent());
        try {
            this.group.performGroupDescriptors();
            this.group.save();
        }
        catch (Exception exception) {
            Logg.error((String)"Could not save group", (Throwable)exception);
        }
        return list;
    }

    @Generated
    public int getCurrentFrameCount() {
        return this.currentFrameCount;
    }
}

