/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.state;

import se.prediktera.breeze.backend.measure.state.MeasurementGrabState;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.thread.ExceptionHandlingThread;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.client.select.active.ActiveRealtimePanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowFrameStack;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowHandleFrame;
import se.prediktera.breeze.hardware.camera.capture.TcpStreamCaptureSession;

public class TcpPredictSession {
    private BufferedTcpStream tcpStream;
    private TcpStreamCaptureSession tcpStreamCaptureSession;
    private int predictFrameCount = 0;

    public TcpPredictSession(final ActiveRealtimePanel activeRealtimePanel, final FrameCount frameCount, final MeasurementGrabState.MeasurementCallback measurementCallback, RuntimeWorkflow runtimeWorkflow, int n) {
        this.tcpStream = new BufferedTcpStream(new RuntimeWorkflowHandleFrame(runtimeWorkflow, activeRealtimePanel.getCameraWidth()), BreezeProperties.getInstance().getBreezeRuntimeConnectHost(), n, new BufferedTcpStream.StreamCallback(){
            final /* synthetic */ TcpPredictSession this$0;
            {
                this.this$0 = tcpPredictSession;
            }

            @Override
            public void onStop() {
                this.this$0.stop();
            }

            @Override
            public void onStart() {
                ExceptionHandlingThread exceptionHandlingThread = new ExceptionHandlingThread("CameraStreamGrabber", () -> {
                    this.this$0.tcpStreamCaptureSession = new TcpStreamCaptureSession(this.this$0.tcpStream, frameCount, new TcpStreamCaptureSession.CameraCallbacks(){

                        @Override
                        public void stopCapture() {
                            if (measurementCallback != null) {
                                measurementCallback.onFinish();
                            }
                        }

                        @Override
                        public void startCapture(FrameCount frameCount) {
                        }
                    }, new Camera.CaptureCallback(){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void onStop() {
                        }

                        @Override
                        public void onStart(Camera.CaptureControl captureControl) {
                        }

                        @Override
                        public void onFrame(FrameStack frameStack, Camera.CaptureControl captureControl) {
                            ++this.this$1.this$0.predictFrameCount;
                            activeRealtimePanel.apply((RuntimeWorkflowFrameStack)frameStack);
                            if (measurementCallback != null) {
                                measurementCallback.onFrame(this.this$1.this$0.predictFrameCount);
                            }
                        }

                        @Override
                        public void onError(Camera.CaptureControl captureControl, Exception exception) {
                            captureControl.stop();
                        }
                    });
                    this.this$0.tcpStreamCaptureSession.runBlocking();
                });
                exceptionHandlingThread.start();
            }
        }, null);
        this.tcpStream.connect();
    }

    public void stop() {
        if (this.tcpStreamCaptureSession != null) {
            this.tcpStreamCaptureSession.stop();
            this.tcpStreamCaptureSession = null;
        }
        if (this.tcpStream != null) {
            this.tcpStream.disconnect();
            this.tcpStream = null;
        }
    }
}

