/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.writers;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.entry.workflow.Workflow;

public class FileImageWriter {
    public static final double DEFAULT_HISTOGRAM_PERCENTAGE = 0.01;
    public static final int DEFAULT_HISTOGRAM_BUCKETSIZE = 10000;
    public static final boolean DEFAULT_HISTOGRAM_STRECHALL = true;
    public static final boolean DEFAULT_HISTOGRAM_NORMALIZEMIN = true;
    public static final String DEFAULT_FORMAT = "png";
    private final int pixelWidth;
    private final RgbBands rgbBands;
    private final ImageHistogram settings;
    private final int[][] histogram;
    private final List<short[][]> dataList = new ArrayList<short[][]>();
    private final float[][] minInvAbs = new float[3][2];
    private final float inverted;
    private final int step;
    private final int size;

    public FileImageWriter(PixelWidth pixelWidth, RgbBands rgbBands, MaxSignal maxSignal, ImageHistogram imageHistogram) {
        this.pixelWidth = pixelWidth.value;
        this.rgbBands = rgbBands;
        this.settings = imageHistogram;
        this.inverted = maxSignal.inverted();
        if (imageHistogram.strechAll) {
            this.histogram = new int[3][imageHistogram.bucketSize + 1];
            this.step = 1;
            this.size = 1;
        } else {
            this.histogram = new int[1][imageHistogram.bucketSize + 1];
            this.step = 0;
            this.size = 3;
        }
    }

    public void write(File file, RtFrameStackList rtFrameStackList) {
        this.write(file, rtFrameStackList.getReflectanceOrRawFrameList());
    }

    public void write(File file, List<? extends Frame> list) {
        if (list.isEmpty()) {
            throw new RuntimeException("Cant write image from empty frame list");
        }
        for (Frame frame : list) {
            this.addFrameDataAndUpdateHistogram(frame);
        }
        this.normalizeAndWriteToDisk(file);
    }

    public void addFrameDataAndUpdateHistogram(Frame frame) {
        int n = frame.getColumns().value;
        short[][] sArray = new short[this.pixelWidth][3];
        int n2 = this.settings.bucketSize;
        int[] nArray = this.rgbBands.getWithin(frame.getRows().value);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            int n5 = 0;
            for (int i = 0; i < 3; ++i) {
                short s;
                float f = frame.getReferenceValue(nArray[i], n3) * this.inverted;
                sArray[n4][i] = s = (short)Math.max(0.0f, Math.min((float)n2, f * (float)n2));
                int[] nArray2 = this.histogram[n5];
                short s2 = s;
                nArray2[s2] = nArray2[s2] + 1;
                n5 += this.step;
            }
            ++n3;
            ++n4;
        }
        this.dataList.add(sArray);
    }

    public void normalizeAndWriteToDisk(File file) {
        if (this.settings.perctage > 0.0) {
            this.normalizeFromHistogram();
        }
        try {
            ImageIO.write((RenderedImage)this.convertDataListToImage(), DEFAULT_FORMAT, file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private void normalizeFromHistogram() {
        this.calculateMinInvAbs();
        int n = this.settings.bucketSize;
        float f = 255.0f / (float)n;
        Iterator<short[][]> iterator = this.dataList.iterator();
        while (iterator.hasNext()) {
            short[][] sArray;
            short[][] sArray2 = sArray = iterator.next();
            for (int i = 0; i < sArray2.length; ++i) {
                for (int j = 0; j < sArray2[i].length; ++j) {
                    sArray2[i][j] = (short)(Math.max(0.0f, Math.min((float)n, ((float)sArray2[i][j] - this.minInvAbs[j][0]) * this.minInvAbs[j][1])) * f);
                }
            }
        }
    }

    private void calculateMinInvAbs() {
        int n;
        int n2 = (int)((double)(this.dataList.size() * this.pixelWidth) * this.settings.perctage * (double)this.size);
        int n3 = this.histogram[0].length;
        for (n = 0; n < this.histogram.length; ++n) {
            int n4;
            int n5;
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.settings.normalizeMin) {
                n5 = 0;
                for (n4 = 0; n4 < n3; ++n4) {
                    if ((n5 += this.histogram[n][n4]) < n2) continue;
                    f = n4;
                    break;
                }
            }
            n5 = 0;
            for (n4 = n3 - 1; n4 >= 0; --n4) {
                if ((n5 += this.histogram[n][n4]) < n2) continue;
                f2 = n4;
                break;
            }
            this.minInvAbs[n][0] = f;
            float f3 = f2 - f;
            this.minInvAbs[n][1] = (float)this.settings.bucketSize / f3;
        }
        if (this.histogram.length == 1) {
            for (n = 1; n < 3; ++n) {
                this.minInvAbs[n][0] = this.minInvAbs[0][0];
                this.minInvAbs[n][1] = this.minInvAbs[0][1];
            }
        }
    }

    private BufferedImage convertDataListToImage() {
        BufferedImage bufferedImage = new BufferedImage(this.pixelWidth, this.dataList.size(), 1);
        int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n = 0;
        for (int i = 0; i < this.dataList.size(); ++i) {
            short[][] sArray = this.dataList.get(i);
            for (int j = 0; j < sArray.length; ++j) {
                short[] sArray2 = sArray[j];
                nArray[n++] = sArray2[0] << 16 | sArray2[1] << 8 | sArray2[2] | 0xFF000000;
            }
        }
        return bufferedImage;
    }

    public static class ImageHistogram {
        public double perctage = 0.01;
        public int bucketSize = 10000;
        public boolean normalizeMin = true;
        public boolean strechAll = true;

        public ImageHistogram() {
        }

        public ImageHistogram(Workflow workflow) {
            this(workflow.getImageHistogramPerctage(), workflow.getImageHistogramBucketSize(), workflow.getImageHistogramNormalizeMin(), workflow.getImageHistogramStrechAll());
        }

        public ImageHistogram(double d, int n, boolean bl, boolean bl2) {
            this.perctage = d;
            this.bucketSize = n;
            this.normalizeMin = bl;
            this.strechAll = bl2;
        }
    }
}

