/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.writers;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.backend.measure.writers.FileImageWriter;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.datacreation.FrameStackCreator;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;
import se.prediktera.breeze.test.SlowTestCategory;

@Category(value={SlowTestCategory.class})
public class ImageWriterTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    private File pngFile;

    @Before
    public void setup() {
        this.pngFile = new File(this.tempFolder.getRoot(), "file.png");
    }

    @Test
    public void shouldWriteRGBAndHistogramAdjustedImageCreatedFromFrames() throws IOException {
        RtFrameStackList rtFrameStackList = this.createReflectanceFrameListWithData();
        new FileImageWriter(rtFrameStackList.getWidth(), new RgbBands(64, 128, 192), new MaxSignal(500.0f), new FileImageWriter.ImageHistogram()).write(this.pngFile, rtFrameStackList);
        WritableRaster writableRaster = ImageIO.read(this.pngFile).getRaster();
        int[][][] nArrayArray = new int[][][]{new int[][]{{35, 67, 100}, {67, 133, 198}, {100, 198, 255}}};
        MatcherAssert.assertThat((String)"image width is correct", (Object)writableRaster.getWidth(), (Matcher)CoreMatchers.equalTo((Object)rtFrameStackList.getWidth().value));
        MatcherAssert.assertThat((String)"image height is correct", (Object)writableRaster.getHeight(), (Matcher)CoreMatchers.equalTo((Object)rtFrameStackList.frameCount().value));
        this.assertDataEquals(writableRaster, nArrayArray);
    }

    @Test
    public void shouldWriteRGBAndHistogramAdjustedImageCreatedFromFramesWithDifferentHistogramPercentageAndMaxSignal() throws IOException {
        RtFrameStackList rtFrameStackList = this.createReflectanceFrameListWithData();
        FileImageWriter.ImageHistogram imageHistogram = new FileImageWriter.ImageHistogram();
        imageHistogram.perctage = 0.4;
        new FileImageWriter(rtFrameStackList.getWidth(), new RgbBands(64, 128, 192), new MaxSignal(300.0f), imageHistogram).write(this.pngFile, rtFrameStackList);
        WritableRaster writableRaster = ImageIO.read(this.pngFile).getRaster();
        int[][][] nArrayArray = new int[][][]{new int[][]{{0, 0, 0}, {127, 195, 255}, {255, 255, 255}}};
        MatcherAssert.assertThat((String)"image width is correct", (Object)writableRaster.getWidth(), (Matcher)CoreMatchers.equalTo((Object)rtFrameStackList.getWidth().value));
        MatcherAssert.assertThat((String)"image height is correct", (Object)writableRaster.getHeight(), (Matcher)CoreMatchers.equalTo((Object)rtFrameStackList.frameCount().value));
        this.assertDataEquals(writableRaster, nArrayArray);
    }

    private void printRasterDataInArrayFormat(Raster raster) {
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                int[] nArray = raster.getPixel(i, j, (int[])null);
                System.out.printf("{ %d, %d, %d }, ", nArray[0], nArray[1], nArray[2]);
            }
        }
    }

    private void assertDataEquals(Raster raster, int[][][] nArray) {
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                int[] nArray2 = raster.getPixel(i, j, (int[])null);
                MatcherAssert.assertThat((String)String.format("pixel x%d y%dshould equal expected data", i, j), (Object)nArray2, (Matcher)CoreMatchers.equalTo((Object)nArray[i][j]));
            }
        }
    }

    private RtFrameStackList createReflectanceFrameListWithData() {
        RtFrameStackList.Builder builder = new RtFrameStackList.Builder();
        for (int i = 0; i < 3; ++i) {
            builder.addFrame(FrameStackCreator.frameStackWith_SpecificRawRefAndAbsFrame(this.createReflectanceFrameWithData(i)));
        }
        return builder.build();
    }

    private RtFrame createReflectanceFrameWithData(int n) {
        RtFrame rtFrame = new RtFrame(new BandCount(256), new PixelWidth(1), BandNames.fromIndex(256), 1);
        for (int i = 0; i < 256; ++i) {
            int n2 = 5 + i * (n + 1);
            rtFrame.setFrameValue(i, 0, n2);
        }
        return rtFrame;
    }
}

