/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.writers;

import java.awt.Rectangle;
import java.io.File;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.raw.RawFileFrameWriter;
import se.prediktera.breeze.common.util.raw.RawFileHeaderWriter;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.HdrByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class PredictionRawAndHeaderFileWriter {
    public void writeRawFileAndHeader(File file, File file2, RtFrameStackList rtFrameStackList) {
        if (rtFrameStackList.isEmpty() || !rtFrameStackList.getFrameStack(0).hasModelFrames()) {
            throw new RuntimeException("Cant write empty raw file");
        }
        DataSize dataSize = DataSize.FLOAT_4;
        BandNames bandNames = BandNames.fromModelFrames(rtFrameStackList);
        Rectangle rectangle = rtFrameStackList.getBoundingBox();
        try (RawFileFrameWriter rawFileFrameWriter = new RawFileFrameWriter(file, bandNames.count(), rtFrameStackList.getWidth(), dataSize, rectangle);){
            for (RtFrameStack rtFrameStack : rtFrameStackList) {
                rawFileFrameWriter.writeFrames(rtFrameStack.getModelFrames());
            }
            this.createRawFileHeaderWriter().writeHeader(file2, bandNames.count(), rtFrameStackList.getBoundingBoxWidth(), bandNames, dataSize, null, rawFileFrameWriter.lineCount(), RtInterleave.BIL, HdrByteOrder.Default(), null);
        }
    }

    protected RawFileHeaderWriter createRawFileHeaderWriter() {
        return new RawFileHeaderWriter();
    }

    public static class FakePredictionRawAndHeaderFileWriter
    extends PredictionRawAndHeaderFileWriter {
        public File lastWrittenRawFile;
        public File lastWrittenHeaderFile;
        public RtFrameStackList lastWrittenFrameStackList;

        @Override
        public void writeRawFileAndHeader(File file, File file2, RtFrameStackList rtFrameStackList) {
            this.lastWrittenRawFile = file;
            this.lastWrittenHeaderFile = file2;
            this.lastWrittenFrameStackList = rtFrameStackList;
        }
    }
}

