/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.measure.writers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import se.prediktera.breeze.backend.measure.writers.PredictionRawAndHeaderFileWriter;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.realtime.frame.RtModelFrame;
import se.prediktera.breeze.common.util.StringFromFile;
import se.prediktera.breeze.common.util.datacreation.FrameStackCreator;
import se.prediktera.breeze.common.util.raw.RawFileHeaderWriter;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.hardware.camera.FakeCamera;
import se.prediktera.breeze.test.MockBreezeTestProperties;
import se.prediktera.breeze.test.SlowTestCategory;
import se.prediktera.breeze.test.stubs.AnalyseWithoutIO;

@Category(value={SlowTestCategory.class})
public class PredictionRawAndHeaderFileWriterTest
extends MockBreezeTestProperties {
    @Rule
    public TemporaryFolder measurementFolder = new TemporaryFolder();
    private Measurement measurement;
    private PredictionRawAndHeaderFileWriter writer;
    private FakeCamera cameraDeviceStub;

    @Before
    public void setup() {
        this.measurement = new Measurement(new Group("Group", new Workflow("Workflow", this.measurementFolder.getRoot())));
        this.writer = new PredictionRawAndHeaderFileWriter(this){

            @Override
            protected RawFileHeaderWriter createRawFileHeaderWriter() {
                return new RawFileHeaderWriter(this){

                    @Override
                    protected String getTimestamp() {
                        return "Test";
                    }
                };
            }
        };
        this.cameraDeviceStub = new FakeCamera();
    }

    @Test
    public void shouldWriteResultAndResultHeaderFileToDisk() {
        RtFrameStackList rtFrameStackList = this.createFrameStackListWith2ModelFramesWith2Bands(new AnalyseWithoutIO(), new AnalyseWithoutIO(), Arrays.asList("band1", "band2"), Arrays.asList("2band1", "2band2"), 10, new PixelWidth(10));
        MatcherAssert.assertThat((String)"measurement does not have result raw file before write", (Object)this.measurement.getPredictionRawFile().exists(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((String)"measurement does not have result header file before write", (Object)this.measurement.getPredictionHdrFile().exists(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.writer.writeRawFileAndHeader(this.measurement.getPredictionRawFile(), this.measurement.getPredictionHdrFile(), rtFrameStackList);
        MatcherAssert.assertThat((String)"measurement has result raw file after write", (boolean)this.measurement.getPredictionRawFile().exists());
        MatcherAssert.assertThat((String)"measurement has result header file after write", (boolean)this.measurement.getPredictionHdrFile().exists());
    }

    @Test
    public void shouldWriteCorrectResultHeaderFile() throws IOException {
        RtFrameStackList rtFrameStackList = this.createFrameStackListWith2ModelFramesWith2Bands(new AnalyseWithoutIO(), new AnalyseWithoutIO(), Arrays.asList("band1", "band2"), Arrays.asList("2band1", "2band2"), 10, new PixelWidth(10));
        this.writer.writeRawFileAndHeader(this.measurement.getPredictionRawFile(), this.measurement.getPredictionHdrFile(), rtFrameStackList);
        String string = new StringFromFile(this.measurement.getPredictionHdrFile()).trimmed().replace("\r", "");
        MatcherAssert.assertThat((Object)string, (Matcher)CoreMatchers.equalTo((Object)"ENVI\ndescription = {}\nfile type = ENVI\ndate = Test\n\ninterleave = BIL\nsamples = 10\nlines   = 10\nbands   = 4\nheader offset = 0\ndata type = 4\nbyte order = 0\n\nx start = 0\ny start = 0\nerrors = {none}\n\nWavelength = {\nband1,\nband2,\n2band1,\n2band2\n}"));
    }

    @Test
    public void shouldWriteCorrectResultRawFile() throws FileNotFoundException, IOException {
        AnalyseWithoutIO analyseWithoutIO = new AnalyseWithoutIO();
        AnalyseWithoutIO analyseWithoutIO2 = new AnalyseWithoutIO();
        RtFrameStackList rtFrameStackList = this.createFrameStackListWith2ModelFramesWith2Bands(analyseWithoutIO, analyseWithoutIO2, Arrays.asList("band1", "band2"), Arrays.asList("2band1", "2band2"), 2, new PixelWidth(3));
        float[][] fArrayArray = new float[][]{{1.0f, 2.0f, 3.0f}, {5.0f, 6.0f, 7.0f}};
        float[][] fArrayArray2 = new float[][]{{3.0f, 2.0f, 3.0f}, {5.0f, 6.0f, 7.0f}};
        float[][] fArrayArray3 = new float[][]{{5.0f, 2.0f, 3.0f}, {5.0f, 5.0f, 7.0f}};
        float[][] fArrayArray4 = new float[][]{{3.0f, 2.0f, 3.0f}, {5.0f, 2.0f, 9.0f}};
        this.setModelFrameData(rtFrameStackList.getFrameStack(0).getModelFrame(analyseWithoutIO.getUid()), fArrayArray);
        this.setModelFrameData(rtFrameStackList.getFrameStack(1).getModelFrame(analyseWithoutIO.getUid()), fArrayArray2);
        this.setModelFrameData(rtFrameStackList.getFrameStack(0).getModelFrame(analyseWithoutIO2.getUid()), fArrayArray3);
        this.setModelFrameData(rtFrameStackList.getFrameStack(1).getModelFrame(analyseWithoutIO2.getUid()), fArrayArray4);
        this.cameraDeviceStub.width = new PixelWidth(3);
        this.writer.writeRawFileAndHeader(this.measurement.getPredictionRawFile(), this.measurement.getPredictionHdrFile(), rtFrameStackList);
        float[] fArray = this.readFileAsFloatArray(this.measurement.getPredictionRawFile());
        this.assertArrayMatchesData(fArray, 0, fArrayArray);
        this.assertArrayMatchesData(fArray, 6, fArrayArray3);
        this.assertArrayMatchesData(fArray, 12, fArrayArray2);
        this.assertArrayMatchesData(fArray, 18, fArrayArray4);
    }

    private RtFrameStackList createFrameStackListWith2ModelFramesWith2Bands(Analyse analyse, Analyse analyse2, List<String> list, List<String> list2, int n, PixelWidth pixelWidth) {
        RtFrameStackList.Builder builder = new RtFrameStackList.Builder();
        for (int i = 0; i < n; ++i) {
            RtModelFrame rtModelFrame = new RtModelFrame(analyse.getUid(), list, pixelWidth, 1);
            RtModelFrame rtModelFrame2 = new RtModelFrame(analyse2.getUid(), list2, pixelWidth, 1);
            RtFrameStack rtFrameStack = FrameStackCreator.frameStackWith_EmptyRawRefAndAbsFrame_NoModelFrames(new BandCount(10), pixelWidth, new BandNames(list));
            rtFrameStack.addModelFrame(rtModelFrame);
            rtFrameStack.addModelFrame(rtModelFrame2);
            builder.addFrame(rtFrameStack);
        }
        return builder.build();
    }

    private void setModelFrameData(RtFrame rtFrame, float[][] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[0].length; ++j) {
                rtFrame.setFrameValue(i, j, fArray[i][j]);
            }
        }
    }

    private float[] readFileAsFloatArray(File file) throws FileNotFoundException, IOException {
        byte[] byArray = IOUtils.toByteArray((InputStream)new FileInputStream(file));
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        FloatBuffer floatBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer();
        float[] fArray = new float[byArray.length / 4];
        floatBuffer.get(fArray);
        return fArray;
    }

    private void assertArrayMatchesData(float[] fArray, int n, float[][] fArray2) {
        int n2 = n;
        for (float[] fArray3 : fArray2) {
            for (int i = 0; i < fArray2[0].length; ++i) {
                MatcherAssert.assertThat((String)"buffer value equals expected data value", (Object)Float.valueOf(fArray[n2]), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(fArray3[i])));
                ++n2;
            }
        }
    }
}

