/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime;

import java.util.ArrayList;
import org.junit.Test;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.realtime.segmentation.spatial.SpatialRectangleObject;
import se.prediktera.breeze.common.util.test.asserts.AssertMatrix;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class CalculateAverageProfileTest {
    @Test
    public void calculateAverageAndRepresentativeProfileTest2x2() {
        float[][] fArray = this.calculateAverageProfile(new BandCount(10), 2, new PixelWidth(2), BandNames.fromIndex(10));
        float[][] fArrayArray = new float[][]{{0.0f, -0.25f, 0.5f, -0.75f, 1.0f, -1.25f, 1.5f, -1.7499f, 2.0f, -2.2499f}};
        AssertMatrix.assertThatMatrixEquals(fArray, fArrayArray, 0.01);
    }

    @Test
    public void calculateAverageAndRepresentativeProfileTest10x10() {
        float[][] fArray = this.calculateAverageProfile(new BandCount(10), 10, new PixelWidth(10), BandNames.fromIndex(10));
        float[][] fArrayArray = new float[][]{{0.0f, -5.05f, 10.1f, -15.15f, 20.2f, -25.25f, 30.3f, -35.35f, 40.4f, -45.45f}};
        AssertMatrix.assertThatMatrixEquals(fArray, fArrayArray, 0.01);
    }

    private float[][] calculateAverageProfile(BandCount bandCount, int n, PixelWidth pixelWidth, BandNames bandNames) {
        RtFrameStackList rtFrameStackList = this.createRealtimeFrameStackList(bandCount, n, pixelWidth, bandNames);
        SpatialRectangleObject spatialRectangleObject = new SpatialRectangleObject(0, 0, pixelWidth.value, n);
        return RtFrameStackList.calculateAverageProfile(rtFrameStackList, spatialRectangleObject);
    }

    private double round(double d) {
        return (double)((int)(d * 10000.0)) / 10000.0;
    }

    private RtFrameStackList createRealtimeFrameStackList(BandCount bandCount, int n, PixelWidth pixelWidth, BandNames bandNames) {
        ArrayList<RtFrameStack> arrayList = new ArrayList<RtFrameStack>();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            RtFrame rtFrame = new RtFrame(bandCount, pixelWidth, bandNames, 1);
            for (int j = 0; j < rtFrame.getColumns().value; ++j) {
                this.setRepresentativeSpectrum(rtFrame, j, n2++);
            }
            arrayList.add(new RtFrameStack(rtFrame, rtFrame));
        }
        return new RtFrameStackList(arrayList);
    }

    private void setRepresentativeSpectrum(RtFrame rtFrame, int n, float f) {
        BandCount bandCount = rtFrame.getRows();
        for (int i = 0; i < bandCount.value; ++i) {
            rtFrame.setFrameValue(i, n, (i % 2 == 0 ? f : -f) * (float)i / (float)bandCount.value);
        }
    }

    private void printProfiles(double[][] dArray) {
        for (double[] dArray2 : dArray) {
            System.out.print("{");
            for (int i = 0; i < dArray[1].length; ++i) {
                System.out.print(this.round(dArray2[i]) + ",");
            }
            System.out.println("},");
        }
    }
}

