/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jblas.FloatMatrix;
import org.junit.Test;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.hardware.camera.frame.RingBuffer;

public class FrameRingBufferTest {
    @Test
    public void test() {
        int n;
        RingBuffer<Frame> ringBuffer = new RingBuffer<Frame>(Frame.class, 3);
        for (n = 0; n < 4; ++n) {
            FrameRingBufferTest.putFrame(ringBuffer, new RtFrame(new FloatMatrix(new float[]{n}), 1));
        }
        MatcherAssert.assertThat((Object)ringBuffer.getFilled(), (Matcher)CoreMatchers.equalTo((Object)3));
        for (n = 0; n < ringBuffer.getFilled(); ++n) {
            MatcherAssert.assertThat((Object)Float.valueOf(ringBuffer.get(n).getFrameValue(0, 0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf((float)n + 1.0f)));
        }
        MatcherAssert.assertThat((Object)ringBuffer.getFilled(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)ringBuffer.getMissed(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testPoll() {
        int n;
        RingBuffer<Frame> ringBuffer = new RingBuffer<Frame>(Frame.class, 3);
        for (n = 0; n < 4; ++n) {
            FrameRingBufferTest.putFrame(ringBuffer, new RtFrame(new FloatMatrix(new float[]{n}), 1));
        }
        n = ringBuffer.getFilled();
        MatcherAssert.assertThat((Object)ringBuffer.getFilled(), (Matcher)CoreMatchers.equalTo((Object)3));
        for (int i = 0; i < n; ++i) {
            MatcherAssert.assertThat((Object)Float.valueOf(ringBuffer.poll().getFrameValue(0, 0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf((float)i + 1.0f)));
            MatcherAssert.assertThat((Object)ringBuffer.getFilled(), (Matcher)CoreMatchers.equalTo((Object)(n - i - 1)));
        }
        MatcherAssert.assertThat((Object)ringBuffer.getFilled(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)ringBuffer.getMissed(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void testGetLast() {
        RingBuffer<Frame> ringBuffer = new RingBuffer<Frame>(Frame.class, 3);
        for (int i = 0; i < 4; ++i) {
            FrameRingBufferTest.putFrame(ringBuffer, new RtFrame(new FloatMatrix(new float[]{i}), 1));
            MatcherAssert.assertThat((Object)Float.valueOf(ringBuffer.getLast().getFrameValue(0, 0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(i)));
        }
        MatcherAssert.assertThat((Object)ringBuffer.getFilled(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)ringBuffer.getMissed(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    private static final void putFrame(RingBuffer<Frame> ringBuffer, Frame frame) {
        Frame frame2 = ringBuffer.getNext();
        if (frame2 == null) {
            frame2 = frame.copy();
        } else {
            FrameRingBufferTest.copyTo(frame, frame2);
        }
        ringBuffer.putDirect(frame2);
    }

    private static final void copyTo(Frame frame, Frame frame2) {
        for (int i = 0; i < frame.rows.value; ++i) {
            for (int j = 0; j < frame.columns.value; ++j) {
                frame2.setFrameValue(i, j, frame.getFrameValue(i, j));
            }
        }
    }
}

