/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.backend.realtime.VisualizationAddOn;
import se.prediktera.breeze.backend.realtime.holder.RtAbsorbanceModuleHolder;
import se.prediktera.breeze.backend.realtime.holder.RtRadianceModuleHolder;
import se.prediktera.breeze.backend.realtime.holder.RtRawModuleHolder;
import se.prediktera.breeze.backend.realtime.holder.RtReflectanceModuleHolder;
import se.prediktera.breeze.backend.realtime.module.SaturationRtModule;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.RtModuleHolder;
import se.prediktera.breeze.common.realtime.frame.FramePool;
import se.prediktera.breeze.common.realtime.frame.RtFrameStack;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.IntegrationTime;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtThreader;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.map.register.RegInfo;

public class RtFramePredictor {
    private final int blocks;
    private final BandCount bandCount;
    private final PixelWidth pixelWidth;
    private final BandNames bandNames;
    private final List<RtModuleHolder> holderList = new ArrayList<RtModuleHolder>();
    private final RtRawModuleHolder rawHolder;
    private RtRadianceModuleHolder radianceHolder;
    private RtReflectanceModuleHolder reflectanceHolder;
    private RtAbsorbanceModuleHolder absorbanceHolder;
    private VisualizationAddOn visualizationAddOn;
    private final RefSettings referenceSettings;

    public RtFramePredictor(BreezeProgress breezeProgress, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, MaxSignal maxSignal, FramePoolSettings framePoolSettings, Workflow workflow, RefSettings refSettings) {
        this.referenceSettings = refSettings;
        FramePool.INITIAL_POOL_SIZE = framePoolSettings.initialFramePoolSize;
        this.bandCount = bandCount;
        this.pixelWidth = pixelWidth;
        this.bandNames = bandNames;
        int n = Math.min(Runtime.getRuntime().availableProcessors(), pixelWidth.value);
        this.blocks = Math.min(n * 2, pixelWidth.value);
        breezeProgress.setInfoText("Initiating model workflow");
        int n2 = workflow.getMaxSaturatedBand();
        SaturationRtModule saturationRtModule = new SaturationRtModule(n2 > 0 && n2 <= bandCount.value ? maxSignal : null, this.blocks, n2);
        ReferenceType referenceType = refSettings.referenceType;
        ReferenceConvertTo referenceConvertTo = refSettings.convertTo;
        boolean bl = referenceConvertTo.useReferences() && !referenceType.equals((Object)ReferenceType.None);
        this.rawHolder = new RtRawModuleHolder(bandCount, pixelWidth, bandNames, maxSignal, this.blocks, (referenceType.equals((Object)ReferenceType.None) || !referenceConvertTo.useReferences()) && framePoolSettings.keep(), saturationRtModule, bl);
        this.holderList.add(this.rawHolder);
        if (bl) {
            if (referenceConvertTo.equals((Object)ReferenceConvertTo.Radiance)) {
                this.radianceHolder = new RtRadianceModuleHolder(bandCount, pixelWidth, bandNames, maxSignal, this.blocks, framePoolSettings.keep() || referenceType.equals((Object)ReferenceType.KeepReflectance), workflow, refSettings, saturationRtModule);
                this.add(this.rawHolder, this.radianceHolder);
            } else {
                boolean bl2 = referenceType.white() && referenceConvertTo.isCalcAbsorbance();
                this.reflectanceHolder = new RtReflectanceModuleHolder(bandCount, pixelWidth, bandNames, maxSignal, this.blocks, !bl2 && framePoolSettings.keep() || referenceType.equals((Object)ReferenceType.KeepReflectance), workflow, refSettings, saturationRtModule);
                this.add(this.rawHolder, this.reflectanceHolder);
                if (bl2) {
                    this.absorbanceHolder = new RtAbsorbanceModuleHolder(bandCount, pixelWidth, bandNames, this.blocks, framePoolSettings.keep());
                    this.add(this.reflectanceHolder, this.absorbanceHolder);
                }
            }
        }
    }

    public void add(RtModuleHolder rtModuleHolder, RtModuleHolder rtModuleHolder2) {
        rtModuleHolder.addHolder(rtModuleHolder2);
        this.holderList.add(rtModuleHolder2);
    }

    public RtFrameStack apply(final Frame frame, long l, SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, Measurement measurement) {
        this.setLatestReferences(whiteReference, darkReference, measurement);
        final RtFrameStack rtFrameStack = new RtFrameStack(l);
        this.rawHolder.populateFrameStackAccordingToHolderStructure(rtFrameStack, frame, this.blocks);
        new RtThreader(this, this.blocks){
            final /* synthetic */ RtFramePredictor this$0;
            {
                this.this$0 = rtFramePredictor;
                super(n);
            }

            @Override
            protected void doOp(boolean bl, int n, int n2) {
                for (int i = n; i < n2; ++i) {
                    this.this$0.applyBlock(frame, rtFrameStack, i);
                }
            }
        }.execute(this.blocks);
        if (this.visualizationAddOn != null) {
            this.visualizationAddOn.apply(rtFrameStack);
        }
        return rtFrameStack;
    }

    protected void applyBlock(Frame frame, RtFrameStack rtFrameStack, int n) {
        this.rawHolder.primeWithRawData(rtFrameStack, frame, n, this.blocks);
        this.rawHolder.apply(rtFrameStack, null, n);
    }

    public void setLatestReferences(SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, Measurement measurement) {
        if (this.reflectanceHolder != null) {
            this.reflectanceHolder.setLatestReferences(whiteReference, darkReference, this.blocks, true, measurement);
        } else if (this.radianceHolder != null) {
            this.radianceHolder.setLatestReferences(whiteReference, darkReference, this.blocks, true, measurement);
        }
    }

    public List<RtModuleHolder> getHolderList() {
        return this.holderList;
    }

    public void setVisualizationAddOn(VisualizationAddOn visualizationAddOn) {
        this.visualizationAddOn = visualizationAddOn;
    }

    public RtAbsorbanceModuleHolder getAbsorbanceHolder() {
        return this.absorbanceHolder;
    }

    public RtModuleHolder getAbsRefOrRawHolder() {
        if (this.absorbanceHolder != null) {
            return this.absorbanceHolder;
        }
        if (this.reflectanceHolder != null) {
            return this.reflectanceHolder;
        }
        if (this.radianceHolder != null) {
            return this.radianceHolder;
        }
        return this.rawHolder;
    }

    public RtRawModuleHolder getRawHolder() {
        return this.rawHolder;
    }

    public ReferenceType getReferenceType() {
        return this.referenceSettings.referenceType;
    }

    public int getBlocks() {
        return this.blocks;
    }

    public BandCount getBandCount() {
        return this.bandCount;
    }

    public PixelWidth getPixelWidth() {
        return this.pixelWidth;
    }

    public BandNames getBandNames() {
        return this.bandNames;
    }

    public void stop() {
    }

    public static class RefSettings {
        public ReferenceType referenceType = ReferenceType.Both;
        public ReferenceConvertTo convertTo = ReferenceConvertTo.Absorbance;
        public int baseLineOffset = 0;
        public String strayLightFile;
        public IntegrationTime integrationTime = new IntegrationTime(0.0f);
        public int initialFramePoolSize = 300;
        public boolean useDarkReferenceAfter = false;
        public FrameListFromRaw.Reduce reduce = FrameListFromRaw.Reduce.Original;
        public Rectangle bounds;

        public RefSettings() {
        }

        public RefSettings(IntegrationTime integrationTime) {
            this.integrationTime = integrationTime;
        }

        public RefSettings(ReferenceType referenceType) {
            this.referenceType = referenceType;
            if (referenceType.equals((Object)ReferenceType.OnlyDark)) {
                this.convertTo = ReferenceConvertTo.Reflectance;
            }
        }
    }

    public static class FramePoolSettings {
        public boolean keepFramesInPool;
        public int initialFramePoolSize = 300;

        public FramePoolSettings(boolean bl) {
            this.keepFramesInPool = bl;
        }

        public boolean keep() {
            return this.keepFramesInPool;
        }

        public static FramePoolSettings fromMin(boolean bl, int n) {
            FramePoolSettings framePoolSettings = new FramePoolSettings(bl);
            framePoolSettings.initialFramePoolSize = Math.min(n, 300);
            return framePoolSettings;
        }
    }

    public static enum ReferenceType {
        None(false),
        Both(true),
        OnlyDark(true),
        OnlyWhite(true),
        KeepReflectance(true);

        private final boolean using;

        private ReferenceType(boolean bl) {
            this.using = bl;
        }

        public boolean using() {
            return this.using;
        }

        public boolean both() {
            return this.equals((Object)Both);
        }

        public boolean dark() {
            return this.equals((Object)Both) || this.equals((Object)OnlyDark);
        }

        public boolean white() {
            return this.equals((Object)Both) || this.equals((Object)OnlyWhite) || this.equals((Object)KeepReflectance);
        }
    }

    public static enum ReferenceConvertTo {
        None,
        Radiance,
        Reflectance,
        Absorbance;


        public boolean isCalcAbsorbance() {
            return this.equals((Object)Absorbance);
        }

        public boolean useReferences() {
            return !this.equals((Object)None);
        }

        public String format() {
            if (this.useReferences()) {
                return this.toString();
            }
            return "Raw";
        }

        public String getVariable() {
            if (this.isCalcAbsorbance()) {
                return Reflectance.name();
            }
            return this.name();
        }

        public String getPlotTitle(Measurement measurement) {
            if (this.equals((Object)Radiance)) {
                return "Normalised radiance spectrum";
            }
            if (measurement != null) {
                ReferenceConvertTo referenceConvertTo = measurement.getDataFormat();
                if (referenceConvertTo != null && !referenceConvertTo.equals((Object)None)) {
                    return referenceConvertTo.getPlotTitle();
                }
                ReferenceType referenceType = measurement.getReferenceType();
                if (referenceType.white()) {
                    return this.getPlotTitle();
                }
            }
            return "Raw spectrum";
        }

        private String getPlotTitle() {
            if (this.equals((Object)Radiance)) {
                return "Normalised radiance spectrum";
            }
            if (this.equals((Object)Reflectance)) {
                return "Normalised reflectance spectrum";
            }
            if (this.equals((Object)Absorbance)) {
                return "Normalised pseudo absorbance spectrum";
            }
            return "Raw spectrum";
        }

        public String getPrefix() {
            return this.name().substring(0, 3).toLowerCase();
        }

        public String getExt(PPExportSegmentation.OutputFormat outputFormat) {
            if (outputFormat.equals((Object)PPExportSegmentation.OutputFormat.HySpex)) {
                return "hyspex";
            }
            if (outputFormat.equals((Object)PPExportSegmentation.OutputFormat.Matlab)) {
                return "mat";
            }
            if (this.equals((Object)None)) {
                return "raw";
            }
            return "img";
        }

        public String toString() {
            if (this.equals((Object)None)) {
                return "Raw";
            }
            return super.toString();
        }

        public static ReferenceConvertTo parse(String string) {
            return ReferenceConvertTo.parse(string, Absorbance);
        }

        public static ReferenceConvertTo parse(String string, ReferenceConvertTo referenceConvertTo) {
            if (string != null) {
                if (string.equalsIgnoreCase("none") || string.equalsIgnoreCase("raw")) {
                    return None;
                }
                if (string.equalsIgnoreCase("radiance")) {
                    return Radiance;
                }
                if (string.equalsIgnoreCase("reflectance")) {
                    return Reflectance;
                }
                if (string.equalsIgnoreCase("absorbance")) {
                    return Absorbance;
                }
            }
            return referenceConvertTo;
        }

        public static ReferenceConvertTo getDefault() {
            if (RegInfo.isGeoFeature()) {
                return Reflectance;
            }
            return Absorbance;
        }

        public static List<ReferenceConvertTo> supported() {
            return ReferenceConvertTo.supported(null);
        }

        public static List<ReferenceConvertTo> supported(Measurement measurement) {
            ArrayList<ReferenceConvertTo> arrayList = new ArrayList<ReferenceConvertTo>();
            arrayList.add(None);
            if (measurement != null) {
                if (measurement.isHySpex()) {
                    arrayList.add(Radiance);
                }
                if (measurement.getReferenceType().white()) {
                    arrayList.add(Reflectance);
                    arrayList.add(Absorbance);
                }
            } else {
                arrayList.add(Radiance);
                arrayList.add(Reflectance);
                arrayList.add(Absorbance);
            }
            return arrayList;
        }
    }

    public static class WorkflowTreeException
    extends RuntimeException {
        public WorkflowTreeException(Throwable throwable) {
            super(throwable);
        }
    }
}

