/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.backend.realtime;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.test.asserts.AssertCloseTo;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.PixelWidth;

public class RtFrameTest {
    @Test
    public void testDifferentSetups() {
        for (int i = 1; i < 10; i += 2) {
            while (i < 200) {
                for (int j = 1; j <= 12; ++j) {
                    this.evaluate(new BandCount(i), new PixelWidth(12), j);
                }
                i += 20;
            }
        }
    }

    @Test
    public void shouldThrowExceptionOnMoreBlocksThenColumns() {
        try {
            this.evaluate(new BandCount(10), new PixelWidth(10), 12);
            Assert.fail((String)"should have thrown exception");
        }
        catch (RuntimeException runtimeException) {
            MatcherAssert.assertThat((String)"exception has correct message", (Object)runtimeException.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"blocks cannot be more then columns: blocks = 12 columns = 10"));
        }
    }

    private void evaluate(BandCount bandCount, PixelWidth pixelWidth, int n) {
        int n2;
        BandNames bandNames = BandNames.fromIndex(bandCount.value);
        RtFrame rtFrame = new RtFrame(bandCount, pixelWidth, bandNames, n);
        ShortFrame shortFrame = new ShortFrame(bandCount, pixelWidth, bandNames);
        for (n2 = 0; n2 < pixelWidth.value; ++n2) {
            shortFrame.setFrameValue(0, n2, n2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            shortFrame.copyFrameIntoBlock(rtFrame, n2, null);
        }
        for (n2 = 0; n2 < pixelWidth.value; ++n2) {
            AssertCloseTo.assertThatNumberIsCloseTo("rows=" + String.valueOf(bandCount) + ",columns=" + String.valueOf(pixelWidth) + ",blocks=" + n, rtFrame.getFrameValue(0, n2), n2, 0.001);
        }
    }
}

